/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class GraphicConfigDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private int optionSelected;
    private JRadioButton windowedRadioButton;
    private JRadioButton blackBkgRadioButton;
    private JRadioButton fullscreenRadioButton;

    public GraphicConfigDialog(int n) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"GraphicConfig.Title"), false);
        this.optionSelected = n != -1 ? n : 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GraphicConfig.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.windowedRadioButton = new JRadioButton(TC.get((String)"GraphicConfig.Windowed"));
        jPanel.add((Component)this.windowedRadioButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getContentPane().getBackground());
        jTextPane.setText(TC.get((String)"GraphicConfig.WindowedDescription"));
        jPanel.add((Component)jTextPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 0.3;
        ImageIcon imageIcon = new ImageIcon("img/graphicconf1.png");
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        this.blackBkgRadioButton = new JRadioButton(TC.get((String)"GraphicConfig.BlackBkg"));
        jPanel.add((Component)this.blackBkgRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setBackground(this.getContentPane().getBackground());
        jTextPane2.setText(TC.get((String)"GraphicConfig.BlackBkgDescription"));
        jPanel.add((Component)jTextPane2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.anchor = 22;
        imageIcon = new ImageIcon("img/graphicconf2.png");
        jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        this.fullscreenRadioButton = new JRadioButton(TC.get((String)"GraphicConfig.Fullscreen"));
        jPanel.add((Component)this.fullscreenRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setBackground(this.getContentPane().getBackground());
        jTextPane2.setText(TC.get((String)"GraphicConfig.FullscreenDescription"));
        jPanel.add((Component)jTextPane2, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 0.3;
        imageIcon = new ImageIcon("img/graphicconf3.png");
        jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton = new JButton(TC.get((String)"GeneralText.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicConfigDialog.this.setVisible(false);
                GraphicConfigDialog.this.dispose();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphicConfigDialog.this.invalidateOptionSelected();
                GraphicConfigDialog.this.setVisible(false);
                GraphicConfigDialog.this.dispose();
            }
        });
        jPanel2.add(jButton2);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.windowedRadioButton.addActionListener(new OptionChangedListener());
        this.blackBkgRadioButton.addActionListener(new OptionChangedListener());
        this.fullscreenRadioButton.addActionListener(new OptionChangedListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.windowedRadioButton);
        buttonGroup.add(this.blackBkgRadioButton);
        buttonGroup.add(this.fullscreenRadioButton);
        switch (this.optionSelected) {
            case 0: {
                this.windowedRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.blackBkgRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.fullscreenRadioButton.setSelected(true);
                break;
            }
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GraphicConfigDialog.this.invalidateOptionSelected();
                GraphicConfigDialog.this.setVisible(false);
                GraphicConfigDialog.this.dispose();
            }
        });
        this.setSize(450, 410);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public int getOptionSelected() {
        return this.optionSelected;
    }

    private void invalidateOptionSelected() {
        this.optionSelected = -1;
    }

    @Override
    public boolean updateFields() {
        switch (Controller.getInstance().getGUIConfigConfiguration()) {
            case 0: {
                this.windowedRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.blackBkgRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.fullscreenRadioButton.setSelected(true);
                break;
            }
        }
        return true;
    }

    private class OptionChangedListener
    implements ActionListener {
        private OptionChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(GraphicConfigDialog.this.windowedRadioButton)) {
                GraphicConfigDialog.this.optionSelected = 0;
            } else if (actionEvent.getSource().equals(GraphicConfigDialog.this.blackBkgRadioButton)) {
                GraphicConfigDialog.this.optionSelected = 1;
            } else if (actionEvent.getSource().equals(GraphicConfigDialog.this.fullscreenRadioButton)) {
                GraphicConfigDialog.this.optionSelected = 2;
            }
            Controller.getInstance().changeToolGraphicConfig(GraphicConfigDialog.this.optionSelected);
        }
    }
}

