/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

public class GUIStylesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int optionSelected;
    private JRadioButton traditionalRadioButton;
    private JRadioButton contextualRadioButton;

    public GUIStylesDialog(int n) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"GUIStyles.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.optionSelected = n;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"GUIStyles.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this.traditionalRadioButton = new JRadioButton(TC.get((String)"GUIStyles.Traditional"));
        jPanel.add((Component)this.traditionalRadioButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getContentPane().getBackground());
        jTextPane.setText(TC.get((String)"GUIStyles.TraditionalDescription"));
        jPanel.add((Component)jTextPane, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.contextualRadioButton = new JRadioButton(TC.get((String)"GUIStyles.Contextual"));
        this.contextualRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        jPanel.add((Component)this.contextualRadioButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setBackground(this.getContentPane().getBackground());
        jTextPane2.setText(TC.get((String)"GUIStyles.ContextualDescription"));
        jPanel.add((Component)jTextPane2, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton = new JButton(TC.get((String)"GeneralText.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIStylesDialog.this.setVisible(false);
                GUIStylesDialog.this.dispose();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIStylesDialog.this.invalidateOptionSelected();
                GUIStylesDialog.this.setVisible(false);
                GUIStylesDialog.this.dispose();
            }
        });
        jPanel2.add(jButton2);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.traditionalRadioButton.addActionListener(new OptionChangedListener());
        this.contextualRadioButton.addActionListener(new OptionChangedListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.traditionalRadioButton);
        buttonGroup.add(this.contextualRadioButton);
        if (n == 0) {
            this.traditionalRadioButton.setSelected(true);
        } else if (n == 1) {
            this.contextualRadioButton.setSelected(true);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIStylesDialog.this.invalidateOptionSelected();
                GUIStylesDialog.this.setVisible(false);
                GUIStylesDialog.this.dispose();
            }
        });
        this.setSize(400, 320);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public int getOptionSelected() {
        return this.optionSelected;
    }

    private void invalidateOptionSelected() {
        this.optionSelected = -1;
    }

    private class OptionChangedListener
    implements ActionListener {
        private OptionChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(GUIStylesDialog.this.traditionalRadioButton)) {
                GUIStylesDialog.this.optionSelected = 0;
            } else if (actionEvent.getSource().equals(GUIStylesDialog.this.contextualRadioButton)) {
                GUIStylesDialog.this.optionSelected = 1;
            }
            Controller.getInstance().changeToolGUIStyleDialog(GUIStylesDialog.this.optionSelected);
        }
    }
}

