/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ExportToLOMDialog
extends JDialog {
    private boolean validated;
    private String lomName;
    private String authorName;
    private String organizationName;
    private JTextField lomNameTextField;
    private JTextField authorNameTextField;
    private JTextField organizationTextField;
    private JCheckBox windowedCheckBox;
    private JComboBox typeComboBox;
    private String testURI;
    private JTextField testURITextField;
    private String testUserID;
    private JTextField testUserIDTextField;
    private JPanel gametelContainerPanel;
    private JPanel gametelPanel;
    private boolean windowed = false;

    public ExportToLOMDialog(String string) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"Operation.ExportToLOM.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.lomName = string;
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel = new JPanel();
        String[] stringArray = new String[]{"IMS CP", "WebCT 4 CP", "SCORM", "SCORM2004", "AGREGA", "LAMS"};
        this.typeComboBox = new JComboBox<String>(stringArray);
        this.typeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                System.out.println("TYPE SELECTED" + ExportToLOMDialog.this.typeComboBox.getSelectedIndex());
                if (ExportToLOMDialog.this.typeComboBox.getSelectedIndex() == 6) {
                    if (!ExportToLOMDialog.this.gametelContainerPanel.isAncestorOf(ExportToLOMDialog.this.gametelPanel)) {
                        ExportToLOMDialog.this.gametelContainerPanel.add(ExportToLOMDialog.this.gametelPanel);
                        ExportToLOMDialog.this.setSize(new Dimension(400, 670));
                    }
                } else if (ExportToLOMDialog.this.gametelContainerPanel.isAncestorOf(ExportToLOMDialog.this.gametelPanel)) {
                    ExportToLOMDialog.this.gametelContainerPanel.remove(ExportToLOMDialog.this.gametelPanel);
                    ExportToLOMDialog.this.setSize(new Dimension(400, 600));
                }
            }
        });
        jPanel.add(this.typeComboBox);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Operation.ExportToLOM.LOMType")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Operation.ExportToLOM.LOMName")));
        this.lomNameTextField = new JTextField(string);
        this.lomNameTextField.getDocument().addDocumentListener(new TextFieldListener(this.lomNameTextField));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(this.getContentPane().getBackground());
        jTextPane.setText(TC.get((String)"Operation.ExportToLOM.LOMName.Description"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.add((Component)jTextPane, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        jPanel2.add((Component)this.lomNameTextField, gridBagConstraints2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Operation.ExportToLOM.Credentials")));
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridy = 0;
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setBackground(this.getContentPane().getBackground());
        jTextPane2.setText(TC.get((String)"Operation.ExportToLOM.Credentials.Description"));
        jPanel3.add((Component)jTextPane2, gridBagConstraints2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Operation.ExportToLOM.AuthorName")));
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 1;
        this.authorNameTextField = new JTextField("");
        this.authorNameTextField.getDocument().addDocumentListener(new TextFieldListener(this.authorNameTextField));
        jPanel4.add((Component)this.authorNameTextField, gridBagConstraints3);
        gridBagConstraints2.gridy = 1;
        jPanel3.add((Component)jPanel4, gridBagConstraints2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Operation.ExportToLOM.OrganizationName")));
        jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 1;
        this.organizationTextField = new JTextField("");
        this.organizationTextField.getDocument().addDocumentListener(new TextFieldListener(this.organizationTextField));
        jPanel5.add((Component)this.organizationTextField, gridBagConstraints3);
        gridBagConstraints2.gridy = 2;
        jPanel3.add((Component)jPanel5, gridBagConstraints2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Operation.ExportToLOM.LOMAppletProperties")));
        this.windowedCheckBox = new JCheckBox(TC.get((String)"Operation.ExportToLOM.LOMAppletRunInsideBrowser"));
        this.windowedCheckBox.setSelected(true);
        this.windowedCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ExportToLOMDialog.this.changeWindowedMode();
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        jPanel6.add((Component)this.windowedCheckBox, gridBagConstraints2);
        this.gametelContainerPanel = new JPanel();
        this.gametelPanel = new JPanel();
        this.gametelPanel.setLayout(new GridLayout(2, 2));
        this.gametelPanel.add(new JLabel(TC.get((String)"Operation.ExportToLOM.GAMETEL.TestURI")));
        this.testURITextField = new JTextField();
        this.testURITextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExportToLOMDialog.this.testURI = ExportToLOMDialog.this.testURITextField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.gametelPanel.add(this.testURITextField);
        this.gametelPanel.add(new JLabel(TC.get((String)"Operation.ExportToLOM.GAMETEL.TestUserID")));
        this.testUserIDTextField = new JTextField();
        this.testUserIDTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ExportToLOMDialog.this.testUserID = ExportToLOMDialog.this.testUserIDTextField.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.gametelPanel.add(this.testUserIDTextField);
        JPanel jPanel7 = new JPanel();
        JButton jButton = new JButton(TC.get((String)"Operation.ExportToLOM.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportToLOMDialog.this.validated = true;
                ExportToLOMDialog.this.setVisible(false);
                ExportToLOMDialog.this.dispose();
            }
        });
        jPanel7.add(jButton);
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.getContentPane().add((Component)jPanel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.getContentPane().add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.getContentPane().add((Component)jPanel6, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.getContentPane().add((Component)this.gametelContainerPanel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridy;
        this.getContentPane().add((Component)jPanel7, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ExportToLOMDialog.this.validated = false;
                ExportToLOMDialog.this.setVisible(false);
                ExportToLOMDialog.this.dispose();
            }
        });
        this.setSize(new Dimension(400, 600));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    protected void changeWindowedMode() {
        this.windowed = !this.windowedCheckBox.isSelected();
    }

    public String getLomName() {
        return this.lomName;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public int getType() {
        return this.typeComboBox.getSelectedIndex();
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean bl) {
        this.validated = bl;
    }

    public boolean getWindowed() {
        return this.windowed;
    }

    public String getTestUserID() {
        return this.testUserID;
    }

    public String getTestReturnURI() {
        return this.testURI;
    }

    private class TextFieldListener
    implements DocumentListener {
        private JTextField textField;

        public TextFieldListener(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField == ExportToLOMDialog.this.lomNameTextField) {
                ExportToLOMDialog.this.lomName = this.textField.getText();
            } else if (this.textField == ExportToLOMDialog.this.authorNameTextField) {
                ExportToLOMDialog.this.authorName = this.textField.getText();
            } else if (this.textField == ExportToLOMDialog.this.organizationTextField) {
                ExportToLOMDialog.this.organizationName = this.textField.getText();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.insertUpdate(documentEvent);
        }
    }
}

