/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.data.chapter.book.BookPage;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.GenericOptionPaneDialog;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;

public class ExportBookDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private BookPagePreviewPanel bookPreview;
    private List<BookPage> pages;
    private int numPag;

    public ExportBookDialog(BookDataControl bookDataControl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"Export.Book"));
        this.setLayout(new BorderLayout());
        this.pages = bookDataControl.getBookPagesList().getBookPages();
        this.bookPreview = new BookPagePreviewPanel(bookDataControl, true);
        this.bookPreview.setPreferredSize(new Dimension(800, 600));
        this.bookPreview.setDrawArrows(false);
        this.add((Component)this.bookPreview, "Center");
        this.numPag = 0;
        JButton jButton = new JButton(TC.get((String)"Export.Book"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExportBookDialog.this.changePage();
            }
        });
        this.add((Component)jButton, "South");
        this.pack();
    }

    private void changePage() {
        while (this.numPag < this.pages.size() && this.pages.get(this.numPag).getType() != 1) {
            ++this.numPag;
        }
        if (this.numPag >= this.pages.size()) {
            this.setVisible(false);
        } else {
            this.bookPreview.setCurrentBookPage(this.pages.get(this.numPag++), true);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.pages.size() > 0) {
            if (bl) {
                this.changePage();
                GenericOptionPaneDialog.showMessageDialog(Controller.getInstance().peekWindow(), TC.get((String)"Export.Book"), TC.get((String)"Export.Book.Info"), 1);
            }
            super.setVisible(bl);
        } else {
            GenericOptionPaneDialog.showMessageDialog(Controller.getInstance().peekWindow(), TC.get((String)"Export.Book"), TC.get((String)"Export.Book.Error"), 1);
            super.setVisible(false);
        }
    }
}

