/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class CutsceneTypesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private int optionSelected = 10;
    private JRadioButton slidesRadioButton;
    private JRadioButton videoRadioButton;

    public CutsceneTypesDialog() {
        super(Controller.getInstance().peekWindow(), TC.get((String)"CutsceneTypes.Title"), Dialog.ModalityType.APPLICATION_MODAL);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        this.slidesRadioButton = new JRadioButton(TC.get((String)"CutsceneTypes.Slides"));
        jPanel.add((Component)this.slidesRadioButton, gridBagConstraints);
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        this.videoRadioButton = new JRadioButton(TC.get((String)"CutsceneTypes.Video"));
        jPanel.add((Component)this.videoRadioButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        JButton jButton = new JButton(TC.get((String)"GeneralText.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CutsceneTypesDialog.this.setVisible(false);
                CutsceneTypesDialog.this.dispose();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CutsceneTypesDialog.this.invalidateOptionSelected();
                CutsceneTypesDialog.this.setVisible(false);
                CutsceneTypesDialog.this.dispose();
            }
        });
        jPanel2.add(jButton2);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel2, "South");
        this.slidesRadioButton.addActionListener(new OptionChangedListener());
        this.videoRadioButton.addActionListener(new OptionChangedListener());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.slidesRadioButton);
        buttonGroup.add(this.videoRadioButton);
        this.slidesRadioButton.setSelected(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CutsceneTypesDialog.this.invalidateOptionSelected();
                CutsceneTypesDialog.this.setVisible(false);
                CutsceneTypesDialog.this.dispose();
            }
        });
        this.setSize(400, 200);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public int getOptionSelected() {
        return this.optionSelected;
    }

    private void invalidateOptionSelected() {
        this.optionSelected = -1;
    }

    private class OptionChangedListener
    implements ActionListener {
        private OptionChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(CutsceneTypesDialog.this.slidesRadioButton)) {
                CutsceneTypesDialog.this.optionSelected = 10;
            } else if (actionEvent.getSource().equals(CutsceneTypesDialog.this.videoRadioButton)) {
                CutsceneTypesDialog.this.optionSelected = 37;
            }
        }
    }
}

