/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ConditionsController;
import es.eucm.eadventure.editor.control.controllers.VarFlagsController;
import es.eucm.eadventure.editor.data.support.IdentifierSummary;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;

public class ConditionDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private boolean pressedOKButton;
    private JComboBox stateComboBox;
    private JComboBox idsComboBox;
    private JSpinner valueSpinner;
    private JPanel optionsPanel;
    private JPanel featuresPanel;
    private String selectedId;
    private int selectedMode;
    private String defaultFlag;
    private String defaultId;
    private String defaultVar;
    private String defaultState;
    private int defaultValue;
    private HashMap<String, ConditionsController.ConditionContextProperty> context;

    public ConditionDialog(String string) {
        this("flag", string, null, null, null, null, null, new HashMap<String, ConditionsController.ConditionContextProperty>());
    }

    public ConditionDialog(String string, String string2, String string3, String string4, String string5, String string6, String string7, HashMap<String, ConditionsController.ConditionContextProperty> hashMap) {
        super(Controller.getInstance().peekWindow(), string2, false);
        this.context = hashMap;
        this.defaultFlag = string4;
        this.defaultVar = string5;
        this.defaultId = string6;
        this.defaultState = string3;
        this.defaultValue = string7 != null ? Integer.parseInt(string7) : 1;
        this.pressedOKButton = false;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(14, 14, 14, 4);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JLabel(TC.get((String)"Conditions.EditConditionMessage")), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.optionsPanel = this.createOptionsPanel();
        jPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.featuresPanel = new JPanel();
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.featuresPanel, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 4, 4));
        JButton jButton = new JButton(TC.get((String)"GeneralText.OK"));
        jButton.addActionListener(new OKButtonListener());
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConditionDialog.this.setVisible(false);
            }
        });
        jPanel2.add(jButton2);
        this.add((Component)jPanel2, "South");
        this.setResizable(false);
        if (string.equals("flag")) {
            this.selectedMode = 1;
        }
        if (string.equals("var")) {
            this.selectedMode = 0;
        }
        if (string.equals("global-state")) {
            this.selectedMode = 2;
        }
        this.updateDialog();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private JPanel createOptionsPanel() {
        JPanel jPanel = new JPanel();
        jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Conditions.Type")));
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = new JToggleButton(TC.get((String)"Conditions.Flags"), new ImageIcon("img/flags.png"));
        jToggleButton.setToolTipText(TC.get((String)"Conditions.Flag.Description"));
        JToggleButton jToggleButton2 = new JToggleButton(TC.get((String)"Conditions.Var"), new ImageIcon("img/vars.png"));
        jToggleButton2.setToolTipText(TC.get((String)"Conditions.Var.Description"));
        JToggleButton jToggleButton3 = new JToggleButton(TC.get((String)"Conditions.ConditionGroup"), new ImageIcon("img/group.png"));
        jToggleButton3.setToolTipText(TC.get((String)"Conditions.Group.Description"));
        jToggleButton.addActionListener(new ConditionModeButtonListener(1));
        jToggleButton2.addActionListener(new ConditionModeButtonListener(0));
        jToggleButton3.addActionListener(new ConditionModeButtonListener(2));
        jToggleButton3.setEnabled(Controller.getInstance().getIdentifierSummary().getGlobalStatesIds().length > 0);
        jPanel.add(jToggleButton);
        jPanel.add(jToggleButton2);
        jPanel.add(jToggleButton3);
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        buttonGroup.add(jToggleButton3);
        return jPanel;
    }

    public boolean wasPressedOKButton() {
        return this.pressedOKButton;
    }

    public String getSelectedState() {
        if (this.stateComboBox != null && this.stateComboBox.getSelectedItem() != null) {
            return this.stateComboBox.getSelectedItem().toString();
        }
        return null;
    }

    public String getSelectedValue() {
        if (this.valueSpinner != null && this.valueSpinner.getValue() != null) {
            return this.valueSpinner.getValue().toString();
        }
        return null;
    }

    public String getSelectedId() {
        return this.selectedId;
    }

    public String getSelectedType() {
        if (this.selectedMode == 1) {
            return "flag";
        }
        if (this.selectedMode == 0) {
            return "var";
        }
        if (this.selectedMode == 2) {
            return "global-state";
        }
        return null;
    }

    private void updateDialog() {
        this.featuresPanel.removeAll();
        this.featuresPanel.updateUI();
        if (this.selectedMode == 1) {
            this.featuresPanel.setLayout(new GridBagLayout());
            String[] stringArray = Controller.getInstance().getVarFlagSummary().getFlags();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 2, 4);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.8;
            this.featuresPanel.add((Component)new JLabel(TC.get((String)"Conditions.Flag.Id")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.2;
            this.featuresPanel.add((Component)new JLabel(TC.get((String)"Conditions.Flag.State")), gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 4, 4, 4);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.8;
            this.idsComboBox = new JComboBox<String>(stringArray);
            this.idsComboBox.setEditable(true);
            if (this.defaultFlag != null) {
                this.idsComboBox.setSelectedItem(this.defaultFlag);
            }
            this.featuresPanel.add((Component)this.idsComboBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.2;
            this.stateComboBox = new JComboBox<String>(ConditionsController.STATE_VALUES_FLAGS);
            if (this.defaultState != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(this.defaultState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stateComboBox.setSelectedItem(ConditionsController.STATE_VALUES_FLAGS[n]);
            }
            this.featuresPanel.add((Component)this.stateComboBox, gridBagConstraints);
            this.featuresPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Conditions.Flag.Title")));
        } else if (this.selectedMode == 0) {
            this.featuresPanel.setLayout(new GridBagLayout());
            String[] stringArray = Controller.getInstance().getVarFlagSummary().getVars();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(4, 4, 2, 4);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.6;
            this.featuresPanel.add((Component)new JLabel(TC.get((String)"Conditions.Var.Id")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.2;
            this.featuresPanel.add((Component)new JLabel(TC.get((String)"Conditions.Var.State")), gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.2;
            this.featuresPanel.add((Component)new JLabel(TC.get((String)"Conditions.Var.Value")), gridBagConstraints);
            gridBagConstraints.insets = new Insets(2, 4, 4, 4);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.6;
            this.idsComboBox = new JComboBox<String>(stringArray);
            this.idsComboBox.setEditable(true);
            if (this.defaultVar != null) {
                this.idsComboBox.setSelectedItem(this.defaultVar);
            }
            this.featuresPanel.add((Component)this.idsComboBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.2;
            this.stateComboBox = new JComboBox<String>(ConditionsController.STATE_VALUES_VARS);
            if (this.defaultState != null) {
                String string = ConditionsController.getOperatorFromString(this.defaultState);
                this.stateComboBox.setSelectedItem(string);
            }
            this.featuresPanel.add((Component)this.stateComboBox, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.2;
            this.valueSpinner = new JSpinner(new SpinnerNumberModel(this.defaultValue, 0, Integer.MAX_VALUE, 1));
            this.featuresPanel.add((Component)this.valueSpinner, gridBagConstraints);
            this.featuresPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Conditions.Var.Title")));
        } else if (this.selectedMode == 2) {
            Object object;
            this.featuresPanel.setLayout(new GridBagLayout());
            String[] stringArray = null;
            if (this.context.containsKey(ConditionsController.CONDITION_RESTRICTIONS)) {
                object = (ConditionsController.ConditionRestrictions)this.context.get(ConditionsController.CONDITION_RESTRICTIONS);
                stringArray = Controller.getInstance().getIdentifierSummary().getGlobalStatesIds(((ConditionsController.ConditionRestrictions)object).getForbiddenIds());
            } else {
                stringArray = Controller.getInstance().getIdentifierSummary().getGlobalStatesIds();
            }
            object = new GridBagConstraints();
            ((GridBagConstraints)object).insets = new Insets(4, 4, 2, 4);
            ((GridBagConstraints)object).gridy = 0;
            ((GridBagConstraints)object).gridwidth = 1;
            ((GridBagConstraints)object).weightx = 1.0;
            this.featuresPanel.add((Component)new JLabel(TC.get((String)"Conditions.Group.Id")), object);
            ((GridBagConstraints)object).gridx = 0;
            ((GridBagConstraints)object).gridy = 1;
            ((GridBagConstraints)object).weightx = 1.0;
            this.idsComboBox = new JComboBox<String>(stringArray);
            this.idsComboBox.setEditable(false);
            if (this.defaultId != null) {
                this.idsComboBox.setSelectedItem(this.defaultId);
            }
            this.featuresPanel.add((Component)this.idsComboBox, object);
            this.stateComboBox = new JComboBox<String>(ConditionsController.STATE_VALUES_FLAGS);
            if (this.defaultState != null) {
                int n = 0;
                try {
                    n = Integer.parseInt(this.defaultState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.stateComboBox.setSelectedItem(ConditionsController.STATE_VALUES_FLAGS[n]);
            }
            this.featuresPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Conditions.Group.Title")));
        }
        this.featuresPanel.doLayout();
        this.pack();
    }

    @Override
    public boolean updateFields() {
        this.updateDialog();
        return true;
    }

    private class OKButtonListener
    implements ActionListener {
        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ConditionDialog.this.idsComboBox != null) {
                VarFlagsController varFlagsController = new VarFlagsController(Controller.getInstance().getVarFlagSummary());
                IdentifierSummary identifierSummary = Controller.getInstance().getIdentifierSummary();
                String string = null;
                if (ConditionDialog.this.idsComboBox.getSelectedItem() != null) {
                    string = ConditionDialog.this.idsComboBox.getSelectedItem().toString();
                }
                if (varFlagsController.existsId(string) || identifierSummary.isGlobalStateId(string)) {
                    ConditionDialog.this.idsComboBox.setSelectedItem(string);
                    ConditionDialog.this.selectedId = string;
                } else if (string != null) {
                    String string2 = varFlagsController.addShortCutFlagVar(ConditionDialog.this.selectedMode == 1, string);
                    if (ConditionDialog.this.selectedMode == 1) {
                        ConditionDialog.this.idsComboBox.setModel(new DefaultComboBoxModel<String>(Controller.getInstance().getVarFlagSummary().getFlags()));
                    } else if (ConditionDialog.this.selectedMode == 0) {
                        ConditionDialog.this.idsComboBox.setModel(new DefaultComboBoxModel<String>(Controller.getInstance().getVarFlagSummary().getVars()));
                    }
                    if (string2 != null) {
                        ConditionDialog.this.idsComboBox.setSelectedItem(string2);
                        ConditionDialog.this.selectedId = string2;
                    }
                    ConditionDialog.this.idsComboBox.updateUI();
                } else if (string == null) {
                    ConditionDialog.this.selectedId = null;
                }
            } else {
                ConditionDialog.this.selectedId = null;
            }
            ConditionDialog.this.pressedOKButton = true;
            ConditionDialog.this.setVisible(false);
        }
    }

    private class ConditionModeButtonListener
    implements ActionListener {
        private int mode;

        public ConditionModeButtonListener(int n) {
            this.mode = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConditionDialog.this.selectedMode = this.mode;
            ConditionDialog.this.updateDialog();
        }
    }
}

