/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.book.BookDataControl;
import es.eucm.eadventure.editor.control.controllers.book.BookPagesListDataControl;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import es.eucm.eadventure.editor.gui.otherpanels.bookpanels.BookPagePreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChangePageMarginsDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private BookPagesListDataControl bookPagesList;
    private BookPagePreviewPanel bookPagePreview;
    private JSlider marginSlider;
    private JSlider marginEndSlider;
    private JSlider marginTopSlider;
    private JSlider marginBottomSlider;
    private BookDataControl dataControl;
    private boolean setChanges;

    public ChangePageMarginsDialog(BookPagesListDataControl bookPagesListDataControl, BookDataControl bookDataControl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"BookPage.MarginDialog"), true);
        this.bookPagesList = bookPagesListDataControl;
        this.dataControl = bookDataControl;
        this.setChanges = true;
        this.setLayout(null);
        this.setTitle(TC.get((String)"BookPage.MarginDialog"));
        this.bookPagePreview = new BookPagePreviewPanel(this.dataControl, true);
        this.bookPagePreview.setCurrentBookPage(bookPagesListDataControl.getSelectedPage());
        this.bookPagePreview.setPreferredSize(new Dimension(800, 600));
        this.bookPagePreview.setBounds(30, 30, 800, 600);
        this.bookPagePreview.setDrawArrows(false);
        this.add(this.bookPagePreview);
        this.createMarginSlider();
        this.createMarginEndSlider();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.marginSlider, "West");
        jPanel.add((Component)this.marginEndSlider, "East");
        jPanel.setPreferredSize(new Dimension(800, 30));
        jPanel.setBounds(30, 0, 800, 30);
        this.add(jPanel);
        this.createMarginTopSlider();
        this.createMarginBottomSlider();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.marginTopSlider, "North");
        jPanel2.add((Component)this.marginBottomSlider, "South");
        jPanel2.setPreferredSize(new Dimension(30, 600));
        jPanel2.setBounds(0, 30, 30, 600);
        this.add(jPanel2);
        this.setSize(840, 660);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    private void createMarginBottomSlider() {
        this.marginBottomSlider = new JSlider(1, 0, 150, this.bookPagesList != null ? this.bookPagesList.getSelectedPage().getMarginBottom() : 0);
        this.marginBottomSlider.setMajorTickSpacing(15);
        this.marginBottomSlider.setMinorTickSpacing(5);
        this.marginBottomSlider.setPaintTicks(true);
        this.marginBottomSlider.setPaintLabels(false);
        this.marginBottomSlider.setEnabled(this.bookPagesList != null);
        this.marginBottomSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChangePageMarginsDialog.this.marginBottomSlider.getValueIsAdjusting()) {
                    ChangePageMarginsDialog.this.marginChanged();
                }
            }
        });
        this.marginBottomSlider.setToolTipText(TC.get((String)"BookPage.MarginToolTip"));
    }

    private void createMarginTopSlider() {
        this.marginTopSlider = new JSlider(1, -150, 0, this.bookPagesList != null ? -this.bookPagesList.getSelectedPage().getMarginTop() : 0);
        this.marginTopSlider.setMajorTickSpacing(15);
        this.marginTopSlider.setMinorTickSpacing(5);
        this.marginTopSlider.setPaintTicks(true);
        this.marginTopSlider.setPaintLabels(false);
        this.marginTopSlider.setEnabled(this.bookPagesList != null);
        this.marginTopSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChangePageMarginsDialog.this.marginTopSlider.getValueIsAdjusting()) {
                    ChangePageMarginsDialog.this.marginChanged();
                }
            }
        });
        this.marginTopSlider.setToolTipText(TC.get((String)"BookPage.MarginToolTip"));
    }

    private void createMarginEndSlider() {
        this.marginEndSlider = new JSlider(0, -150, 0, this.bookPagesList != null ? -this.bookPagesList.getSelectedPage().getMarginEnd() : 0);
        this.marginEndSlider.setMajorTickSpacing(15);
        this.marginEndSlider.setMinorTickSpacing(5);
        this.marginEndSlider.setPaintTicks(true);
        this.marginEndSlider.setPaintLabels(false);
        this.marginEndSlider.setEnabled(this.bookPagesList != null);
        this.marginEndSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChangePageMarginsDialog.this.marginEndSlider.getValueIsAdjusting()) {
                    ChangePageMarginsDialog.this.marginChanged();
                }
            }
        });
        this.marginEndSlider.setToolTipText(TC.get((String)"BookPage.MarginToolTip"));
    }

    private void createMarginSlider() {
        this.marginSlider = new JSlider(0, 0, 150, this.bookPagesList != null ? this.bookPagesList.getSelectedPage().getMargin() : 0);
        this.marginSlider.setMajorTickSpacing(15);
        this.marginSlider.setMinorTickSpacing(5);
        this.marginSlider.setPaintTicks(true);
        this.marginSlider.setPaintLabels(false);
        this.marginSlider.setEnabled(this.bookPagesList != null);
        this.marginSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!ChangePageMarginsDialog.this.marginSlider.getValueIsAdjusting()) {
                    ChangePageMarginsDialog.this.marginChanged();
                }
            }
        });
        this.marginSlider.setToolTipText(TC.get((String)"BookPage.MarginToolTip"));
    }

    protected void marginChanged() {
        this.bookPagesList.setMargins(this.marginSlider.getValue(), -this.marginTopSlider.getValue(), this.marginBottomSlider.getValue(), -this.marginEndSlider.getValue());
        this.bookPagePreview.updateUI();
        this.bookPagePreview.repaint();
    }

    @Override
    public boolean updateFields() {
        this.setChanges = false;
        this.marginSlider.setValue(this.bookPagesList != null ? this.bookPagesList.getSelectedPage().getMargin() : 0);
        this.marginEndSlider.setValue(this.bookPagesList != null ? -this.bookPagesList.getSelectedPage().getMarginEnd() : 0);
        this.marginTopSlider.setValue(this.bookPagesList != null ? this.bookPagesList.getSelectedPage().getMarginTop() : 0);
        this.marginBottomSlider.setValue(this.bookPagesList != null ? this.bookPagesList.getSelectedPage().getMarginBottom() : 0);
        this.remove(this.bookPagePreview);
        this.bookPagePreview = new BookPagePreviewPanel(this.dataControl, true);
        this.bookPagePreview.setCurrentBookPage(this.bookPagesList.getSelectedPage());
        this.add((Component)this.bookPagePreview, "Center");
        this.bookPagePreview.updateUI();
        this.setChanges = false;
        return true;
    }
}

