/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.editdialogs;

import es.eucm.eadventure.common.data.adventure.DescriptorData;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.editdialogs.ToolManagableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AdventureDataDialog
extends ToolManagableDialog {
    private static final long serialVersionUID = 1L;
    private Controller controller = Controller.getInstance();
    private JTextArea descriptionTextArea;
    private JTextField titleTextField;
    private JCheckBox commentariesCheckBox;
    private DocumentListener documentListener;
    private JCheckBox waitUserInteraction;

    public AdventureDataDialog() {
        this(Controller.getInstance().getAdventureTitle(), Controller.getInstance().getAdventureDescription(), Controller.getInstance().isPlayTransparent());
    }

    public AdventureDataDialog(String string, String string2, boolean bl) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"Adventure.Title"), false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this.titleTextField = new JTextField(string);
        this.titleTextField.addActionListener(new TitleTextFieldChangeListener());
        this.titleTextField.addFocusListener(new TitleTextFieldChangeListener());
        jPanel2.add(this.titleTextField);
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.AdventureTitle")));
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout());
        this.descriptionTextArea = new JTextArea(string2, 4, 0);
        this.documentListener = new DescriptionTextAreaChangesListener();
        this.descriptionTextArea.getDocument().addDocumentListener(this.documentListener);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        jPanel3.add(new JScrollPane(this.descriptionTextArea, 22, 31));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.AdventureDescription")));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.gridy = 2;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 22;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weighty = 0.35;
        gridBagConstraints2.gridy = 0;
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.AdventureDescription")));
        JTextField jTextField = null;
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBackground(jPanel4.getBackground());
        jTextArea.setBorder(BorderFactory.createEtchedBorder());
        jTextArea.setLineWrap(true);
        if (bl) {
            jTextField = new JTextField(TC.get((String)"Adventure.ModePlayerTransparent.Name"));
            jTextArea.setText(TC.get((String)"Adventure.ModePlayerTransparent.Description"));
        } else {
            jTextField = new JTextField(TC.get((String)"Adventure.ModePlayerVisible.Name"));
            jTextArea.setText(TC.get((String)"Adventure.ModePlayerVisible.Description"));
        }
        jTextField.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.CurrentPlayerMode")));
        jTextField.setEditable(false);
        gridBagConstraints2.anchor = 21;
        jPanel4.add((Component)jTextField, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.65;
        gridBagConstraints2.anchor = 10;
        jPanel4.add((Component)jTextArea, gridBagConstraints2);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Adventure.PlayerMode")));
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"MenuAdventure.Commentaries")));
        this.commentariesCheckBox = new JCheckBox(TC.get((String)"MenuAdventure.CommentariesLabel"));
        if (this.controller.isCommentaries()) {
            this.commentariesCheckBox.setSelected(true);
        } else {
            this.commentariesCheckBox.setSelected(false);
        }
        jPanel5.setLayout(new GridLayout(1, 2));
        jPanel5.add(this.commentariesCheckBox);
        this.commentariesCheckBox.addActionListener(new CheckBoxListener());
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        this.waitUserInteraction = new JCheckBox(TC.get((String)"Conversation.WaitUserInteraction"), this.controller.isKeepShowing());
        this.waitUserInteraction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdventureDataDialog.this.controller.setKeepShowing(AdventureDataDialog.this.waitUserInteraction.isSelected());
            }
        });
        this.waitUserInteraction.setSelected(this.controller.isKeepShowing());
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"MenuAdventure.KeepShowing")));
        jPanel6.add((Component)this.waitUserInteraction, "West");
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(0, 1));
        jPanel7.add(new JLabel(TC.get((String)"DefaultClickAction.Explanation")));
        String[] stringArray = new String[]{TC.get((String)"DefaultClickAction.ShowDetails"), TC.get((String)"DefaultClickAction.ShowActions")};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        switch (this.controller.getDefaultCursorAction()) {
            case SHOW_DETAILS: {
                jComboBox.setSelectedIndex(0);
                break;
            }
            case SHOW_ACTIONS: {
                jComboBox.setSelectedIndex(1);
            }
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdventureDataDialog.this.controller.setDefaultCursorAction(jComboBox.getSelectedIndex() == 0 ? DescriptorData.DefaultClickAction.SHOW_DETAILS : DescriptorData.DefaultClickAction.SHOW_ACTIONS);
            }
        });
        jPanel7.add(jComboBox);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)jPanel7, gridBagConstraints);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(0, 1));
        jPanel8.add(new JLabel(TC.get((String)"Perspective.Explanation")));
        String[] stringArray2 = new String[]{TC.get((String)"Perspective.Regular"), TC.get((String)"Perspective.Isometric")};
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        switch (this.controller.getPerspective()) {
            case REGULAR: {
                jComboBox2.setSelectedIndex(0);
                break;
            }
            case ISOMETRIC: {
                jComboBox2.setSelectedIndex(1);
            }
        }
        jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdventureDataDialog.this.controller.setPerspective(jComboBox2.getSelectedIndex() == 0 ? DescriptorData.Perspective.REGULAR : DescriptorData.Perspective.ISOMETRIC);
            }
        });
        jPanel8.add(jComboBox2);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel8, gridBagConstraints);
        JPanel jPanel9 = new JPanel();
        JButton jButton = new JButton(TC.get((String)"GeneralText.Close"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdventureDataDialog.this.setVisible(false);
                AdventureDataDialog.this.dispose();
            }
        });
        jPanel9.add(jButton);
        this.add((Component)jPanel, "Center");
        this.add((Component)jPanel9, "South");
        this.setSize(new Dimension(450, 600));
        this.setMinimumSize(new Dimension(450, 600));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    @Override
    public boolean updateFields() {
        this.descriptionTextArea.getDocument().removeDocumentListener(this.documentListener);
        this.descriptionTextArea.setText(Controller.getInstance().getAdventureDescription());
        this.descriptionTextArea.getDocument().addDocumentListener(this.documentListener);
        this.titleTextField.setText(Controller.getInstance().getAdventureTitle());
        if (this.controller.isCommentaries()) {
            this.commentariesCheckBox.setSelected(true);
        } else {
            this.commentariesCheckBox.setSelected(false);
        }
        return true;
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AdventureDataDialog.this.commentariesCheckBox.isSelected()) {
                AdventureDataDialog.this.controller.setCommentaries(true);
            } else {
                AdventureDataDialog.this.controller.setCommentaries(false);
            }
        }
    }

    private class DescriptionTextAreaChangesListener
    implements DocumentListener {
        private DescriptionTextAreaChangesListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AdventureDataDialog.this.controller.setAdventureDescription(AdventureDataDialog.this.descriptionTextArea.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AdventureDataDialog.this.controller.setAdventureDescription(AdventureDataDialog.this.descriptionTextArea.getText());
        }
    }

    private class TitleTextFieldChangeListener
    extends FocusAdapter
    implements ActionListener {
        private TitleTextFieldChangeListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AdventureDataDialog.this.controller.setAdventureTitle(AdventureDataDialog.this.titleTextField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AdventureDataDialog.this.controller.setAdventureTitle(AdventureDataDialog.this.titleTextField.getText());
        }
    }
}

