/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.displaydialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.gui.displaydialogs.GraphicDialog;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class SlidesDialog
extends GraphicDialog {
    private static final long serialVersionUID = 1L;
    private Image[] slides;
    private int currentSlideIndex;

    public SlidesDialog(String string) {
        this.slides = AssetsController.getAnimation(string + "_01.jpg");
        this.getGlassPane().setVisible(true);
        this.getGlassPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SlidesDialog.this.currentSlideIndex = (SlidesDialog.this.currentSlideIndex + 1) % SlidesDialog.this.slides.length;
                SlidesDialog.this.repaint();
            }
        });
        this.setTitle(TC.get((String)"SlidesDialog.Title", (String)AssetsController.getFilename(string)));
        this.setVisible(true);
    }

    @Override
    protected Image getCurrentImage() {
        return this.slides[this.currentSlideIndex];
    }

    @Override
    protected double getCurrentImageRatio() {
        return 1.333;
    }

    @Override
    protected void deleteImages() {
        for (Image image : this.slides) {
            image.flush();
        }
    }
}

