/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.displaydialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.imageedition.SelectImageController;
import es.eucm.eadventure.editor.gui.displaydialogs.GraphicDialog;
import es.eucm.eadventure.editor.gui.otherpanels.imageelements.ImageElementSelectImage;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SelectImageDialog
extends GraphicDialog {
    private static final long serialVersionUID = -6270014367469640519L;
    private BufferedImage image;
    private String path;
    private ImageElementSelectImage selectImage;

    public SelectImageDialog(String string) {
        this.path = string;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(TC.get((String)"SelectImageDialog.Description")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.image = (BufferedImage)AssetsController.getImage(string);
        this.setSize(this.image.getWidth() > 800 ? 800 : this.image.getWidth(), this.image.getHeight() > 600 ? 600 : this.image.getHeight());
        this.setTitle(TC.get((String)"SelectImageDialog.Title", (String)AssetsController.getFilename(string)));
        this.selectImage = new ImageElementSelectImage(this.image, string);
        SelectImageController selectImageController = new SelectImageController(this.selectImage, this);
        this.imagePanel.addMouseListener(selectImageController);
        this.imagePanel.addMouseMotionListener(selectImageController);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(TC.get((String)"SelectImageDialog.AutomaticButton"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectImageDialog.this.rescaleImage();
                SelectImageDialog.this.setVisible(false);
                SelectImageDialog.this.deleteImages();
                SelectImageDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"SelectImageDialog.SaveButton"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectImageDialog.this.saveImage();
                SelectImageDialog.this.setVisible(false);
                SelectImageDialog.this.deleteImages();
                SelectImageDialog.this.dispose();
            }
        });
        jPanel.add(jButton2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SelectImageDialog.this.rescaleImage();
                SelectImageDialog.this.setVisible(false);
                SelectImageDialog.this.deleteImages();
                SelectImageDialog.this.dispose();
            }
        });
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.setVisible(true);
    }

    protected void saveImage() {
        Object object;
        BufferedImage bufferedImage = (BufferedImage)AssetsController.getImage(this.path);
        this.image.getGraphics().drawImage(bufferedImage, 0, 0, null);
        BufferedImage bufferedImage2 = null;
        if (this.selectImage.getWidth() == 800 && this.selectImage.getHeight() == 600) {
            bufferedImage2 = this.image.getSubimage(this.selectImage.getX(), this.selectImage.getY(), this.selectImage.getWidth(), this.selectImage.getHeight());
        } else if (this.selectImage.getHeight() > 600) {
            bufferedImage2 = this.image.getSubimage(this.selectImage.getX(), this.selectImage.getY(), this.selectImage.getWidth(), this.selectImage.getHeight());
            object = bufferedImage2.getScaledInstance(800, 600, 1);
            this.image.getGraphics().drawImage((Image)object, 0, 0, null);
            bufferedImage2 = this.image.getSubimage(0, 0, 800, 600);
        } else if (this.selectImage.getHeight() == 600 && this.selectImage.getWidth() > 800) {
            bufferedImage2 = this.image.getSubimage(this.selectImage.getX(), this.selectImage.getY(), this.selectImage.getWidth(), this.selectImage.getHeight());
        }
        object = AssetsController.getFilename(this.path);
        object = ((String)object).substring(((String)object).lastIndexOf(".") + 1, ((String)object).length());
        File file = new File(Controller.getInstance().getProjectFolder(), this.path);
        try {
            ImageIO.write((RenderedImage)bufferedImage2, (String)object, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void rescaleImage() {
        Image image = AssetsController.getImage(this.path).getScaledInstance(800, 600, 1);
        this.image.getGraphics().drawImage(image, 0, 0, null);
        BufferedImage bufferedImage = this.image.getSubimage(0, 0, 800, 600);
        String string = AssetsController.getFilename(this.path);
        string = string.substring(string.lastIndexOf(".") + 1, string.length());
        File file = new File(Controller.getInstance().getProjectFolder(), this.path);
        try {
            ImageIO.write((RenderedImage)bufferedImage, string, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void deleteImages() {
        if (this.image != null) {
            this.image.flush();
        }
    }

    @Override
    protected Image getCurrentImage() {
        return this.image;
    }

    @Override
    public void repaint() {
        super.repaint();
        this.selectImage.updateMargin(this.imagePanel.getMarginX(), this.imagePanel.getMarginY());
        this.selectImage.updateSize(this.imagePanel.getWidth(), this.imagePanel.getHeight());
    }
}

