/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.displaydialogs;

import es.eucm.eadventure.editor.control.Controller;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class GraphicDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected ImagePanel imagePanel;
    protected int imageX;
    protected int imageY;
    protected int imageWidth;
    protected int imageHeight;

    public GraphicDialog() {
        super(Controller.getInstance().peekWindow(), Dialog.ModalityType.TOOLKIT_MODAL);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.imagePanel = new ImagePanel();
        this.add((Component)this.imagePanel, gridBagConstraints);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GraphicDialog.this.setVisible(false);
                GraphicDialog.this.deleteImages();
                GraphicDialog.this.dispose();
            }
        });
        this.setMinimumSize(new Dimension(400, 300));
        this.setSize(500, 380);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    protected abstract Image getCurrentImage();

    protected double getCurrentImageRatio() {
        if (this.getCurrentImage() != null) {
            return (double)this.getCurrentImage().getWidth(null) / (double)this.getCurrentImage().getHeight(null);
        }
        return Double.MIN_VALUE;
    }

    protected abstract void deleteImages();

    public class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private int marginX;
        private int marginY;

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            this.marginX = 0;
            this.marginY = 0;
            this.updateImageValues();
            graphics.drawImage(GraphicDialog.this.getCurrentImage(), GraphicDialog.this.imageX, GraphicDialog.this.imageY, GraphicDialog.this.imageWidth, GraphicDialog.this.imageHeight, null);
        }

        public void updateImageValues() {
            double d = (double)this.getWidth() / (double)this.getHeight();
            double d2 = GraphicDialog.this.getCurrentImageRatio();
            if (d2 != Double.MIN_VALUE) {
                if (d <= d2) {
                    GraphicDialog.this.imageWidth = this.getWidth();
                    GraphicDialog.this.imageHeight = (int)((double)this.getWidth() / d2);
                    GraphicDialog.this.imageX = 0;
                    GraphicDialog.this.imageY = (this.getHeight() - GraphicDialog.this.imageHeight) / 2;
                    this.marginY = (this.getHeight() - GraphicDialog.this.imageHeight) / 2;
                } else {
                    GraphicDialog.this.imageWidth = (int)((double)this.getHeight() * d2);
                    GraphicDialog.this.imageHeight = this.getHeight();
                    GraphicDialog.this.imageX = (this.getWidth() - GraphicDialog.this.imageWidth) / 2;
                    GraphicDialog.this.imageY = 0;
                    this.marginX = (this.getWidth() - GraphicDialog.this.imageWidth) / 2;
                }
            }
        }

        public int getMarginX() {
            return this.marginX;
        }

        public int getMarginY() {
            return this.marginY;
        }
    }
}

