/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.displaydialogs;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.animation.FrameDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ResourcesDataControl;
import es.eucm.eadventure.editor.control.controllers.imageedition.EditImageController;
import es.eucm.eadventure.editor.control.controllers.imageedition.ImageToolBar;
import es.eucm.eadventure.editor.control.controllers.imageedition.filter.TransparentColorFilter;
import es.eucm.eadventure.editor.gui.displaydialogs.GraphicDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EditImageDialog
extends GraphicDialog {
    private static final long serialVersionUID = 3449739085089862729L;
    private BufferedImage image;
    private String path;
    private EditImageController controller;
    private ResourcesDataControl resourcesDataControl;
    private int assetIndex;
    private FrameDataControl frameDataControl;

    public EditImageDialog(ResourcesDataControl resourcesDataControl, int n) {
        this.path = resourcesDataControl.getAssetPath(n);
        this.resourcesDataControl = resourcesDataControl;
        this.assetIndex = n;
        this.fillAndInitilize();
    }

    public EditImageDialog(FrameDataControl frameDataControl) {
        this.frameDataControl = frameDataControl;
        this.path = frameDataControl.getImageURI();
        this.fillAndInitilize();
    }

    private void fillAndInitilize() {
        BufferedImage bufferedImage = (BufferedImage)AssetsController.getImage(this.path);
        this.image = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 6);
        this.image.getGraphics().drawImage(bufferedImage, 0, 0, null);
        this.setTitle(TC.get((String)"ImageDialog.Title", (String)AssetsController.getFilename(this.path)));
        this.controller = new EditImageController(this.image, this);
        TransparentColorFilter transparentColorFilter = new TransparentColorFilter(false, 15);
        this.controller.setImageFilter(transparentColorFilter);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        final boolean bl = this.image.getColorModel().getComponentSize().length >= 4;
        ++gridBagConstraints.gridy;
        this.add((Component)new ImageToolBar(bl, transparentColorFilter, this.controller, this.imagePanel), gridBagConstraints);
        this.imagePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() - EditImageDialog.this.imageX;
                int n2 = mouseEvent.getY() - EditImageDialog.this.imageY;
                float f = (float)EditImageDialog.this.image.getWidth() / (float)EditImageDialog.this.imageWidth;
                float f2 = (float)EditImageDialog.this.image.getHeight() / (float)EditImageDialog.this.imageHeight;
                n = Math.round((float)n * f);
                n2 = Math.round((float)n2 * f2);
                EditImageDialog.this.controller.transform(n, n2);
            }
        });
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(TC.get((String)"GeneralText.OK"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (bl && EditImageDialog.this.controller.isChanged()) {
                    File file;
                    String[] stringArray = EditImageDialog.this.path.split("\\.");
                    String string = stringArray[stringArray.length - 1];
                    String string2 = EditImageDialog.this.path;
                    if (string.equals("png")) {
                        file = new File(Controller.getInstance().getProjectFolder(), EditImageDialog.this.path);
                    } else {
                        string2 = "";
                        for (int i = 0; i < stringArray.length - 1; ++i) {
                            string2 = string2 + stringArray[i] + ".";
                        }
                        string2 = string2 + "png";
                        file = new File(Controller.getInstance().getProjectFolder(), string2);
                    }
                    try {
                        ImageIO.write((RenderedImage)EditImageDialog.this.image, "png", ImageIO.createImageOutputStream(file));
                        if (!string2.equals(EditImageDialog.this.path) && EditImageDialog.this.resourcesDataControl != null) {
                            EditImageDialog.this.resourcesDataControl.setAssetPath(string2, EditImageDialog.this.assetIndex);
                        }
                        if (!string2.equals(EditImageDialog.this.path) && EditImageDialog.this.frameDataControl != null) {
                            EditImageDialog.this.frameDataControl.setImageURI(string2);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                EditImageDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(TC.get((String)"GeneralText.Cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditImageDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton2);
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        this.imagePanel.updateImageValues();
        this.pack();
        this.setVisible(true);
    }

    @Override
    protected void deleteImages() {
        if (this.image != null) {
            this.image.flush();
        }
    }

    @Override
    protected Image getCurrentImage() {
        return this.image;
    }
}

