/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.displaydialogs;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.auxiliar.TTask;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.elements.Player;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.gui.audio.SoundMp3;
import es.eucm.eadventure.editor.gui.auxiliar.clock.Clock;
import es.eucm.eadventure.editor.gui.auxiliar.clock.ClockListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ConversationDialog
extends JDialog
implements ClockListener {
    private static final long serialVersionUID = 1L;
    private static final int BUTTON_CLICKED_NONE = 0;
    private static final int BUTTON_CLICKED_LEFT = 1;
    private static final int BUTTON_CLICKED_RIGHT = 2;
    private static final int CHARACTER_IDLE = 0;
    private static final int CHARACTER_TALKING = 1;
    private static final int TIME_TALKING = 3000;
    private static final int MAX_OPTION_NUMBER_LINES = 7;
    private final int TEXT_HEIGHT;
    private static final int MAX_WIDTH_IN_TEXT = 200;
    private static final int[] POSITION_CHARACTER_X = new int[]{150, 400};
    private static final int[] POSITION_CHARACTER_Y = new int[]{120, 143};
    private static final int RESPONSE_TEXT_X = 10;
    private static final int RESPONSE_TEXT_Y = 275;
    private static final Color RESPONSE_TEXT_NORMAL = Color.YELLOW;
    private static final Color RESPONSE_TEXT_HIGHLIGHTED = Color.RED;
    private static final Color RESPONSE_TEXT_BORDER = Color.BLACK;
    private int mouseClickedButton = 0;
    private Clock animationClock;
    private NPC talking;
    private boolean firstTime;
    private long audioId = -1L;
    private TTask task;
    private TSound soundTask;
    private int lineTimeElapsed;
    private ConversationNodeView currentNode;
    private int currentLine;
    private String[] currentText;
    private int characterTalking;
    private int firstOptionDisplayed;
    private int optionHighlighted;
    private Font textFont;
    private Image[][][] characterFrames = new Image[2][2][];
    private int[] characterCurrentFrame = new int[2];

    public ConversationDialog(ConversationDataControl conversationDataControl, ConversationNodeView conversationNodeView) {
        super(Controller.getInstance().peekWindow(), TC.get((String)"ConversationDialog.Title", (String)conversationDataControl.getId()));
        this.characterCurrentFrame[0] = 0;
        this.characterFrames[0][0] = this.loadAnimation("img/animations/npc1_standing");
        this.characterFrames[0][1] = this.loadAnimation("img/animations/npc1_talking");
        this.characterCurrentFrame[1] = 0;
        this.characterFrames[1][0] = this.loadAnimation("img/animations/npc2_standing");
        this.characterFrames[1][1] = this.loadAnimation("img/animations/npc2_talking");
        this.addMouseListener(new GeneralMouseListener());
        this.addMouseMotionListener(new GeneralMouseListener());
        this.addWindowListener(new WindowClosingListener());
        this.setLayout(new BorderLayout());
        this.add((Component)new DisplayPanel(), "Center");
        this.characterTalking = -1;
        this.currentNode = conversationNodeView;
        this.currentLine = 0;
        this.firstOptionDisplayed = 0;
        this.optionHighlighted = -1;
        this.task = new TTask();
        this.soundTask = new TSound();
        this.setSize(new Dimension(650, 450));
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        this.setVisible(true);
        this.textFont = new Font("Arial", 1, 20);
        this.TEXT_HEIGHT = this.getGraphics().getFontMetrics(this.textFont).getHeight();
        this.lineTimeElapsed = 0;
        this.animationClock = new Clock(this);
        this.animationClock.start();
        this.setVisible(false);
        this.setModal(true);
        this.setVisible(true);
    }

    private void playNextLine() {
        this.talking = null;
        this.firstTime = true;
        if (this.characterTalking != -1) {
            this.characterCurrentFrame[this.characterTalking] = 0;
            this.characterTalking = -1;
            this.stopSound();
            this.stopTTSTalking();
        }
        if (this.currentLine < this.currentNode.getLineCount()) {
            int n;
            ConversationLine conversationLine = this.currentNode.getLine(this.currentLine);
            if (this.currentNode.isPlayerLine(this.currentLine)) {
                n = 0;
                this.talking = Controller.getInstance().getPlayer();
            } else {
                n = 1;
                this.talking = Controller.getInstance().getNPC(conversationLine.getName());
            }
            this.characterCurrentFrame[n] = 0;
            if (this.currentNode.getLine(this.currentLine).isValidAudio()) {
                this.setAudio(conversationLine.getAudioPath());
            } else if (conversationLine.getSynthesizerVoice().booleanValue() || this.talking.isAlwaysSynthesizer().booleanValue()) {
                this.setSpeakFreeTTS(conversationLine.getText(), n == 0 ? ((Player)this.talking).getVoice() : this.talking.getVoice());
            }
            this.currentText = this.splitText(conversationLine.getText());
            this.characterTalking = n;
            this.lineTimeElapsed = 0;
            ++this.currentLine;
        } else if (this.currentNode.isTerminal()) {
            this.setVisible(false);
            this.dispose();
        } else {
            this.currentNode = this.currentNode.getChildView(0);
            this.firstOptionDisplayed = 0;
            this.currentLine = 0;
        }
    }

    public void setAudio(String string) {
        this.soundTask = new TSound(string);
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.soundTask, 0L);
    }

    public void setSpeakFreeTTS(String string, String string2) {
        this.task = new TTask(string2, string);
        Timer timer = new Timer();
        timer.schedule((TimerTask)this.task, 0L);
    }

    public void stopTTSTalking() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    public void stopSound() {
        if (this.soundTask != null) {
            this.soundTask.cancel();
        }
    }

    @Override
    public void update(long l) {
        this.lineTimeElapsed = (int)((long)this.lineTimeElapsed + l);
        for (int i = 0; i < 2; ++i) {
            int n = this.characterTalking == i ? 1 : 0;
            int n2 = i;
            this.characterCurrentFrame[n2] = (int)((long)this.characterCurrentFrame[n2] + l / 100L);
            int n3 = i;
            this.characterCurrentFrame[n3] = this.characterCurrentFrame[n3] % this.characterFrames[i][n].length;
        }
        this.repaint();
        if (this.currentNode.getType() == 0) {
            if (this.mouseClickedButton == 0) {
                if (this.characterTalking == -1 || this.characterTalking != -1 && this.lineTimeElapsed > 3000 && this.soundTask.isEnd() && this.task.isEnd()) {
                    this.playNextLine();
                }
            } else if (this.mouseClickedButton == 1) {
                this.playNextLine();
                this.mouseClickedButton = 0;
            } else if (this.mouseClickedButton == 2) {
                this.currentLine = this.currentNode.getLineCount();
                this.playNextLine();
                this.mouseClickedButton = 0;
            }
        }
    }

    private Image[] loadAnimation(String string) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        boolean bl = false;
        for (int i = 1; i < 100 && !bl; ++i) {
            File file = new File(string + String.format("_%02d.png", i));
            if (file.exists()) {
                arrayList.add(new ImageIcon(string + String.format("_%02d.png", i)).getImage());
                continue;
            }
            bl = true;
        }
        return arrayList.toArray(new Image[0]);
    }

    private String[] splitText(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
        boolean bl = false;
        while (!bl) {
            int n = fontMetrics.stringWidth(string);
            if (n > 200) {
                int n2 = (int)Math.ceil((double)n / 200.0);
                int n3 = string.lastIndexOf(32, string.length() / n2);
                if (n3 == -1) {
                    n3 = string.indexOf(32);
                }
                if (n3 == -1) {
                    n3 = string.length();
                    bl = true;
                }
                arrayList.add(string.substring(0, n3));
                string = string.substring(n3).trim();
                continue;
            }
            arrayList.add(string);
            bl = true;
        }
        return arrayList.toArray(new String[0]);
    }

    private void drawStringsOnto(Graphics graphics, String[] stringArray, int n, int n2) {
        int n3 = n2 - this.TEXT_HEIGHT * (stringArray.length - 1);
        Color color = new Color(Integer.valueOf(this.talking.getTextFrontColor().substring(1), 16));
        Color color2 = new Color(Integer.valueOf(this.talking.getTextBorderColor().substring(1), 16));
        for (int i = 0; i < stringArray.length; ++i) {
            this.drawStringOnto(graphics, stringArray[i], n, n3, true, color, color2);
            n3 += this.TEXT_HEIGHT;
        }
    }

    private void drawStringOnto(Graphics graphics, String string, int n, int n2, boolean bl, Color color, Color color2) {
        if (bl) {
            n -= graphics.getFontMetrics().stringWidth(string) / 2;
        }
        graphics.setColor(color2);
        graphics.drawString(string, n - 1, n2 - 1);
        graphics.drawString(string, n - 1, n2 + 1);
        graphics.drawString(string, n + 1, n2 - 1);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
    }

    static /* synthetic */ String[] access$902(ConversationDialog conversationDialog, String[] stringArray) {
        conversationDialog.currentText = stringArray;
        return stringArray;
    }

    public class TSound
    extends TimerTask {
        private boolean end = true;
        private SoundMp3 sound;

        public TSound() {
        }

        public TSound(String string) {
            this.sound = new SoundMp3(string);
        }

        @Override
        public void run() {
            try {
                this.end = false;
                this.sound.startPlaying();
                while (this.sound.isAlive()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.end = true;
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("Error at playing sound.");
            }
        }

        @Override
        public boolean cancel() {
            if (this.sound != null) {
                this.sound.stopPlaying();
            }
            return true;
        }

        public boolean isEnd() {
            return this.end;
        }
    }

    private class GeneralMouseListener
    implements MouseListener,
    MouseMotionListener {
        private GeneralMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ConversationDialog.this.currentNode.getType() == 0) {
                if (mouseEvent.getButton() == 1) {
                    ConversationDialog.this.mouseClickedButton = 1;
                } else if (mouseEvent.getButton() == 3) {
                    ConversationDialog.this.mouseClickedButton = 2;
                }
            } else if (275 <= mouseEvent.getY()) {
                int n;
                int n2 = (mouseEvent.getY() - 275) / ConversationDialog.this.TEXT_HEIGHT;
                if (ConversationDialog.this.currentNode.getLineCount() <= 7) {
                    if (n2 < ConversationDialog.this.currentNode.getLineCount()) {
                        ((ConversationDialog)ConversationDialog.this).characterCurrentFrame[0] = 0;
                        ConversationLine conversationLine = ConversationDialog.this.currentNode.getLine(ConversationDialog.this.currentLine);
                        ConversationDialog.this.talking = (NPC)Controller.getInstance().getPlayer();
                        if (ConversationDialog.this.currentNode.getLine(ConversationDialog.this.currentLine).isValidAudio()) {
                            ConversationDialog.this.setAudio(conversationLine.getAudioPath());
                        } else if (conversationLine.getSynthesizerVoice().booleanValue() || ConversationDialog.this.talking.isAlwaysSynthesizer().booleanValue()) {
                            ConversationDialog.this.setSpeakFreeTTS(conversationLine.getText(), ((Player)ConversationDialog.this.talking).getVoice());
                        }
                        ConversationDialog.access$902(ConversationDialog.this, ConversationDialog.this.splitText(ConversationDialog.this.currentNode.getLineText(n2)));
                        ConversationDialog.this.characterTalking = 0;
                        ConversationDialog.this.lineTimeElapsed = 0;
                        ConversationDialog.this.currentNode = ConversationDialog.this.currentNode.getChildView(n2);
                    }
                } else if ((n2 += ConversationDialog.this.firstOptionDisplayed) == (n = Math.min(ConversationDialog.this.firstOptionDisplayed + 7 - 1, ConversationDialog.this.currentNode.getLineCount()))) {
                    ConversationDialog.this.firstOptionDisplayed += 6;
                    if (ConversationDialog.this.firstOptionDisplayed >= ConversationDialog.this.currentNode.getLineCount()) {
                        ConversationDialog.this.firstOptionDisplayed = 0;
                    }
                } else if (n2 < ConversationDialog.this.currentNode.getLineCount()) {
                    ((ConversationDialog)ConversationDialog.this).characterCurrentFrame[0] = 0;
                    ConversationDialog.access$902(ConversationDialog.this, ConversationDialog.this.splitText(ConversationDialog.this.currentNode.getLineText(n2)));
                    ConversationDialog.this.characterTalking = 0;
                    ConversationDialog.this.lineTimeElapsed = 0;
                    ConversationDialog.this.currentNode = ConversationDialog.this.currentNode.getChildView(n2);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (275 <= mouseEvent.getY()) {
                ConversationDialog.this.optionHighlighted = (mouseEvent.getY() - 275) / ConversationDialog.this.TEXT_HEIGHT;
            } else {
                ConversationDialog.this.optionHighlighted = -1;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            try {
                ConversationDialog.this.animationClock.stopClock();
                ConversationDialog.this.animationClock.join();
                ConversationDialog.this.animationClock = null;
            }
            catch (InterruptedException interruptedException) {
                ReportDialog.GenerateErrorReport((Exception)interruptedException, (boolean)true, (String)"UNKNOWERROR");
            }
        }
    }

    private class DisplayPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private DisplayPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2;
            super.paint(graphics);
            graphics.setFont(ConversationDialog.this.textFont);
            for (n2 = 0; n2 < 2; ++n2) {
                n = ConversationDialog.this.characterTalking == n2 ? 1 : 0;
                graphics.drawImage(ConversationDialog.this.characterFrames[n2][n][ConversationDialog.this.characterCurrentFrame[n2]], POSITION_CHARACTER_X[n2], POSITION_CHARACTER_Y[n2], null);
            }
            if (ConversationDialog.this.characterTalking != -1) {
                ConversationDialog.this.drawStringsOnto(graphics, ConversationDialog.this.currentText, POSITION_CHARACTER_X[ConversationDialog.this.characterTalking] + ConversationDialog.this.characterFrames[ConversationDialog.this.characterTalking][1][ConversationDialog.this.characterCurrentFrame[ConversationDialog.this.characterTalking]].getWidth(null) / 2, POSITION_CHARACTER_Y[ConversationDialog.this.characterTalking] - 10);
            }
            if (ConversationDialog.this.currentNode.getType() == 1) {
                if (ConversationDialog.this.firstTime) {
                    ((OptionConversationNode)ConversationDialog.this.currentNode).doRandom();
                    ConversationDialog.this.firstTime = false;
                }
                if (ConversationDialog.this.currentNode.getLineCount() <= 7) {
                    for (n2 = 0; n2 < ConversationDialog.this.currentNode.getLineCount(); ++n2) {
                        Color color = n2 == ConversationDialog.this.optionHighlighted ? RESPONSE_TEXT_HIGHLIGHTED : RESPONSE_TEXT_NORMAL;
                        ConversationDialog.this.drawStringOnto(graphics, n2 + 1 + ".- " + ConversationDialog.this.currentNode.getLineText(n2), 10, 275 + ConversationDialog.this.TEXT_HEIGHT * n2, false, color, RESPONSE_TEXT_BORDER);
                    }
                } else {
                    Color color;
                    n2 = Math.min(ConversationDialog.this.firstOptionDisplayed + 7 - 1, ConversationDialog.this.currentNode.getLineCount());
                    for (n = ConversationDialog.this.firstOptionDisplayed; n < n2; ++n) {
                        color = n - ConversationDialog.this.firstOptionDisplayed == ConversationDialog.this.optionHighlighted ? RESPONSE_TEXT_HIGHLIGHTED : RESPONSE_TEXT_NORMAL;
                        ConversationDialog.this.drawStringOnto(graphics, n + 1 + ".- " + ConversationDialog.this.currentNode.getLineText(n), 10, 275 + (n - ConversationDialog.this.firstOptionDisplayed) * ConversationDialog.this.TEXT_HEIGHT, false, color, RESPONSE_TEXT_BORDER);
                    }
                    color = n - ConversationDialog.this.firstOptionDisplayed == ConversationDialog.this.optionHighlighted ? RESPONSE_TEXT_HIGHLIGHTED : RESPONSE_TEXT_NORMAL;
                    ConversationDialog.this.drawStringOnto(graphics, "More...", 10, 275 + (n - ConversationDialog.this.firstOptionDisplayed) * ConversationDialog.this.TEXT_HEIGHT, false, color, RESPONSE_TEXT_BORDER);
                }
            }
        }
    }
}

