/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.auxiliar.components;

import es.eucm.eadventure.common.gui.TC;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import javax.swing.JPanel;

public class TextPreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Color textFrontColor;
    private Color textBorderColor;
    private boolean speechBubble;
    private Color bubbleBkgColor;
    private Color bubbleBorderColor;

    public TextPreviewPanel(Color color, Color color2, boolean bl, Color color3, Color color4) {
        this.textFrontColor = color;
        this.textBorderColor = color2;
        this.speechBubble = bl;
        this.bubbleBkgColor = color3;
        this.bubbleBorderColor = color4;
    }

    public void setTextFrontColor(Color color) {
        this.textFrontColor = color;
        this.repaint();
    }

    public void setTextBorderColor(Color color) {
        this.textBorderColor = color;
        this.repaint();
    }

    public void setBubbleBkgColor(Color color) {
        this.bubbleBkgColor = color;
        this.repaint();
    }

    public void setBubbleBorderColor(Color color) {
        this.bubbleBorderColor = color;
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        String string = TC.get((String)"GeneralText.PreviewText");
        graphics.setFont(graphics.getFont().deriveFont(18.0f));
        Hashtable<TextAttribute, Float> hashtable = new Hashtable<TextAttribute, Float>();
        hashtable.put(TextAttribute.WIDTH, TextAttribute.WIDTH_SEMI_EXTENDED);
        graphics.setFont(graphics.getFont().deriveFont(hashtable));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = this.getWidth() / 2 - fontMetrics.stringWidth(string) / 2;
        int n2 = this.getHeight() / 2 + fontMetrics.getAscent() / 2;
        int n3 = fontMetrics.getHeight() - fontMetrics.getLeading();
        if (this.speechBubble) {
            int n4 = fontMetrics.stringWidth(string);
            graphics.setColor(this.bubbleBkgColor);
            graphics.fillRoundRect(this.getWidth() / 2 - n4 / 2 - 5, n2 - n3 - 5, n4 + 10, n3 + 10, 20, 20);
            graphics.setColor(this.bubbleBorderColor);
            graphics.drawRoundRect(this.getWidth() / 2 - n4 / 2 - 5, n2 - n3 - 5, n4 + 10, n3 + 10, 20, 20);
            graphics.setColor(this.bubbleBkgColor);
        }
        graphics.setColor(this.textBorderColor);
        graphics.drawString(string, n - 1, n2 - 1);
        graphics.drawString(string, n - 1, n2 + 1);
        graphics.drawString(string, n + 1, n2 - 1);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(this.textFrontColor);
        graphics.drawString(string, n, n2);
    }

    public void setShowsSpeechBubbles(boolean bl) {
        this.speechBubble = bl;
        this.repaint();
    }
}

