/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.auxiliar;

import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.ChapterToolManager;
import es.eucm.eadventure.editor.control.controllers.general.ChapterListDataControl;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;

public class ToolSystemDebugger
extends JDialog {
    private ChapterListDataControl dataControl;
    private List<JList> chapterLists;
    private JPanel mainPanel;

    public ToolSystemDebugger(ChapterListDataControl chapterListDataControl) {
        super(Controller.getInstance().peekWindow(), "", Dialog.ModalityType.MODELESS);
        this.dataControl = chapterListDataControl;
        this.update();
        this.setVisible(true);
    }

    public void update() {
        if (this.mainPanel != null) {
            this.remove(this.mainPanel);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayout(1, this.dataControl.getChaptersCount()));
        String[] stringArray = this.dataControl.getChapterTitles();
        this.chapterLists = new ArrayList<JList>();
        for (int i = 0; i < this.dataControl.getChapterToolManagers().size(); ++i) {
            int n;
            ChapterToolManager chapterToolManager = this.dataControl.getChapterToolManagers().get(i);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), stringArray[i]));
            String[] stringArray2 = new String[chapterToolManager.getGlobalToolManager().getRedoList().size() + chapterToolManager.getGlobalToolManager().getUndoList().size() + 1];
            for (n = 0; n < chapterToolManager.getGlobalToolManager().getRedoList().size(); ++n) {
                stringArray2[n] = chapterToolManager.getGlobalToolManager().getRedoList().get(n).getToolName();
            }
            stringArray2[chapterToolManager.getGlobalToolManager().getRedoList().size()] = "[[CURRENT]]]";
            for (n = 0; n < chapterToolManager.getGlobalToolManager().getUndoList().size(); ++n) {
                stringArray2[chapterToolManager.getGlobalToolManager().getRedoList().size() + chapterToolManager.getGlobalToolManager().getUndoList().size() - n] = chapterToolManager.getGlobalToolManager().getUndoList().get(n).getToolName();
            }
            JList<String> jList = new JList<String>(stringArray2);
            jPanel.setLayout(new BorderLayout());
            jPanel.add(jList, "Center");
            this.mainPanel.add(jPanel);
        }
        this.add(this.mainPanel);
        this.pack();
        this.repaint();
    }
}

