/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.audio;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.gui.audio.Sound;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundMp3
extends Sound {
    private String filename;
    private AudioFormat decodedFormat;
    private AudioInputStream audioInputStream;
    private SourceDataLine line;
    private boolean stop;

    public SoundMp3(String string) {
        this.filename = string;
        this.stop = false;
        try {
            InputStream inputStream = AssetsController.getInputStream(string);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            AudioFormat audioFormat = audioInputStream.getFormat();
            this.decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            this.audioInputStream = AudioSystem.getAudioInputStream(this.decodedFormat, audioInputStream);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.decodedFormat);
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(this.decodedFormat);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.err.println("WARNING - \"" + string + "\" is a no supported MP3 file - sound will be disabled");
        }
        catch (IOException iOException) {
            System.err.println("WARNING - could not open \"" + string + "\" - sound will be disabled");
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.err.println("WARNING - audio device is unavailable to play \"" + string + "\" - sound will be disabled");
        }
    }

    @Override
    public void playOnce() {
        if (this.line != null) {
            try {
                int n;
                this.line.open(this.decodedFormat);
                byte[] byArray = new byte[4096];
                this.line.start();
                while (!this.stop && (n = this.audioInputStream.read(byArray, 0, byArray.length)) != -1) {
                    this.line.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                this.stopPlaying();
                System.out.println("WARNING - could not open \"" + this.filename + "\" - sound will be disabled");
            }
            catch (LineUnavailableException lineUnavailableException) {
                this.stopPlaying();
                System.out.println("WARNING - audio device is unavailable to play \"" + this.filename + "\" - sound will be disabled");
            }
        } else {
            this.stopPlaying();
        }
    }

    @Override
    public void stopPlaying() {
        this.stop = true;
        if (this.line != null) {
            this.line.drain();
            this.line.stop();
            this.line.close();
        }
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException iOException) {
                ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)false, (String)("WARNING - could not close \"" + this.filename + "\" - sound will be disabled"));
            }
        }
    }
}

