/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.audio;

import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.gui.audio.Sound;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class SoundMidi
extends Sound {
    private Sequencer sequencer;
    private Sequence sequence;

    public SoundMidi(String string) {
        try {
            InputStream inputStream = AssetsController.getInputStream(string);
            this.sequence = MidiSystem.getSequence(inputStream);
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.setSequence(this.sequence);
            inputStream.close();
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            this.sequencer = null;
            System.err.println("WARNING - \"" + string + "\" is an invalid MIDI file - sound will be disabled");
        }
        catch (IOException iOException) {
            this.sequencer = null;
            System.err.println("WARNING - could not open \"" + string + "\" - sound will be disabled");
        }
        catch (MidiUnavailableException midiUnavailableException) {
            this.sequencer = null;
            System.err.println("WARNING - MIDI device is unavailable to play \"" + string + "\" - sound will be disabled");
        }
    }

    @Override
    public void playOnce() {
        if (this.sequencer != null) {
            this.sequencer.setTickPosition(this.sequencer.getLoopStartPoint());
            this.sequencer.start();
            while (this.sequencer.isRunning()) {
                try {
                    SoundMidi.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.stopPlaying();
        }
    }

    @Override
    public void stopPlaying() {
        if (this.sequencer != null && this.sequencer.isOpen()) {
            this.sequencer.stop();
            this.sequencer.close();
        }
    }
}

