/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui.assetchooser;

import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import sun.swing.FilePane;
import sun.swing.WindowsPlacesBar;

public abstract class AssetChooser
extends JFileChooser {
    public static final int DEFAULT_ASSET_CHOOSER = 0;
    public static final int WINDOWS_ASSET_CHOOSER = 1;
    public static final int PREVIEW_LOCATION_WEST = 1;
    public static final int PREVIEW_LOCATION_SOUTH = 0;
    public static final int ASSET_FROM_ZIP = 4;
    public static final int ASSET_FROM_OUTSIDE = 5;
    private JToolBar placesBar;
    private JToggleButton zipContentsButton;
    private ArrayList<JToggleButton> placeButtons;
    private JPanel mainPanel;
    private JPanel centralPanel;
    private Container explorerPanel;
    private JPanel filePanel;
    private JScrollPane zipContentsPanel;
    protected JList assetsList;
    private boolean showingZipContents;
    protected JPanel southPanel;
    private JPanel buttonsPanel;
    private JButton approveButton;
    private JButton cancelButton;
    private int type;
    private int assetCategory;
    protected int filter;
    private int previewLocation;
    private String selectedAsset;
    private List<String> selectedAssets;
    private String title;

    public AssetChooser(int n, int n2, int n3, String string) {
        this.assetCategory = n;
        this.previewLocation = n3;
        this.filter = n2;
        this.type = this.categorizeAssetChooser();
        this.setCurrentDirectory((File)new es.eucm.eadventure.common.auxiliar.File(Controller.getInstance().getLastDirectory()));
        super.setFileFilter((FileFilter)this.getFilter());
        if (this.type == 1) {
            this.customizeWindowsChooser();
        }
        this.title = string;
        this.selectedAssets = new ArrayList<String>();
    }

    private int categorizeAssetChooser() {
        if (this.isWindowsCompatible()) {
            return 1;
        }
        return 0;
    }

    private boolean isWindowsCompatible() {
        boolean bl = true;
        try {
            JPanel jPanel;
            JPanel jPanel2;
            if (!(this.getComponent(0) instanceof WindowsPlacesBar) || !(this.getComponent(2) instanceof JPanel)) {
                bl = false;
            }
            if (!((jPanel2 = (JPanel)this.getComponent(2)).getComponent(1) instanceof FilePane) || !(jPanel2.getComponent(2) instanceof JPanel)) {
                bl = false;
            }
            if (!((jPanel = (JPanel)jPanel2.getComponent(2)).getComponent(4) instanceof JPanel)) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void customizeWindowsChooser() {
        this.placeButtons = new ArrayList();
        this.placesBar = (WindowsPlacesBar)this.getComponent(0);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Component component : this.placesBar.getComponents()) {
            if (!(component instanceof JToggleButton)) continue;
            this.placeButtons.add((JToggleButton)component);
            buttonGroup.add((JToggleButton)component);
        }
        this.zipContentsButton = new JToggleButton(new ImageIcon("img/file32.png"));
        this.zipContentsButton.setVerticalTextPosition(3);
        this.zipContentsButton.setHorizontalTextPosition(0);
        this.zipContentsButton.setAlignmentX(0.5f);
        this.zipContentsButton.setText(TC.get((String)"GeneralText.Project"));
        buttonGroup.add(this.zipContentsButton);
        this.placesBar.add(this.zipContentsButton);
        this.filePanel = (JPanel)this.getComponent(2);
        ((JPanel)this.filePanel.getComponent(2)).remove(4);
        ((JPanel)this.filePanel.getComponent(2)).remove(3);
        this.remove(2);
        this.explorerPanel = this.filePanel;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.createCentralPanel();
        this.addPropertyChangeListener(new ChangeDirectoryListener());
        this.zipContentsButton.addActionListener(new ChangeDirectoryListener());
    }

    private void customizeDefaultChooser(Container container) {
        Component component = container.getComponent(0);
        container.removeAll();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.getLayout());
        this.createDefaultAssetsList();
        this.assetsList.addListSelectionListener(new DefaultResourcesListListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Select Asset");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AssetChooser.this.assetsList.getSelectedValue() != null) {
                    AssetChooser.this.selectedAsset = AssetChooser.this.assetsList.getSelectedValue().toString();
                    AssetChooser.this.approveSelection();
                }
            }
        });
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
        jPanel2.add((Component)this.zipContentsPanel, "Center");
        JPanel jPanel4 = new JPanel();
        if (this.previewLocation == 0) {
            container.setLayout(new BoxLayout(container, 2));
            jPanel4.setLayout(new BoxLayout(jPanel4, 3));
        } else if (this.previewLocation == 1) {
            container.setLayout(new BoxLayout(container, 3));
            jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        }
        jPanel4.add(component);
        this.zipContentsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Assets in .ead file"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        this.createPreviewPanel(jPanel5);
        jPanel4.add(jPanel5);
        container.add(jPanel4);
        container.add(jPanel2);
        this.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AssetChooser.this.getSelectedFile() != null) {
                    AssetChooser.this.setSelectedAsset(null);
                }
                AssetChooser.this.updatePreview();
            }
        });
        this.setSize(600, 600);
    }

    private void createAssetsList() {
        Dimension dimension = ((JPanel)this.filePanel.getComponent(0)).getPreferredSize();
        Dimension dimension2 = ((JPanel)this.filePanel.getComponent(0)).getMinimumSize();
        this.assetsList = new JList();
        this.assetsList.setLayoutOrientation(1);
        String[] stringArray = AssetsController.getAssetFilenames(this.assetCategory, this.filter);
        if (this.isMultiSelectionEnabled()) {
            this.assetsList.setSelectionMode(2);
        } else {
            this.assetsList.setSelectionMode(0);
        }
        this.assetsList.setListData(stringArray);
        this.assetsList.addListSelectionListener(new ResourcesListListener());
        this.zipContentsPanel = new JScrollPane(22, 32);
        this.zipContentsPanel.setViewportView(this.assetsList);
    }

    private void createDefaultAssetsList() {
        this.assetsList = new JList();
        if (this.previewLocation == 1) {
            this.assetsList.setLayoutOrientation(0);
            this.zipContentsPanel = new JScrollPane(20, 31);
        } else if (this.previewLocation == 0) {
            this.assetsList.setLayoutOrientation(0);
            this.zipContentsPanel = new JScrollPane(20, 31);
        }
        String[] stringArray = AssetsController.getAssetFilenames(this.assetCategory);
        if (this.isMultiSelectionEnabled()) {
            this.assetsList.setSelectionMode(2);
        } else {
            this.assetsList.setSelectionMode(0);
        }
        this.assetsList.setListData(stringArray);
        this.assetsList.addListSelectionListener(new ResourcesListListener());
        this.zipContentsPanel.setViewportView(this.assetsList);
    }

    private void createCentralPanel() {
        this.centralPanel = new JPanel();
        this.centralPanel.setLayout(new BoxLayout(this.centralPanel, 3));
        this.mainPanel.add((Component)this.centralPanel, "Center");
        this.add((Component)this.mainPanel, "Center");
        this.showingZipContents = false;
        this.createAssetsList();
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 2));
        this.approveButton = new JButton(TC.get((String)"GeneralText.OK"));
        this.approveButton.addActionListener(new ButtonsListener());
        this.cancelButton = new JButton(TC.get((String)"GeneralText.Cancel"));
        this.cancelButton.addActionListener(new ButtonsListener());
        this.buttonsPanel.add(this.approveButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(1));
        this.buttonsPanel.add(this.cancelButton);
        this.centralPanel.add(this.explorerPanel);
        if (this.previewLocation == 0) {
            this.createPreviewPanel(this.centralPanel);
        } else if (this.previewLocation == 1) {
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
            this.createPreviewPanel(this.mainPanel);
        }
        this.centralPanel.add(this.buttonsPanel);
    }

    protected abstract void updatePreview();

    protected abstract void createPreviewPanel(Container var1);

    protected es.eucm.eadventure.common.auxiliar.FileFilter getFilter() {
        return AssetsController.getAssetsFileFilter(this.assetCategory, this.filter);
    }

    public String getSelectedAsset() {
        return this.selectedAsset;
    }

    public void setSelectedAsset(String string) {
        this.selectedAsset = string;
    }

    public Object[] getSelectedAssets() {
        return this.selectedAssets.toArray();
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = super.createDialog(component);
        jDialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        Controller.getInstance().pushWindow(jDialog);
        if (this.type == 0) {
            Container container = jDialog.getContentPane();
            this.customizeDefaultChooser(container);
            jDialog.setSize(800, 800);
        }
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                Controller.getInstance().popWindow();
            }
        });
        return jDialog;
    }

    public int showAssetChooser(Component component) {
        int n = this.showDialog(component, this.title);
        if (n == 0) {
            if (this.selectedAsset == null && (!this.isMultiSelectionEnabled() && this.getSelectedFile() != null || this.isMultiSelectionEnabled() && this.getSelectedFiles().length > 0)) {
                if (!this.isMultiSelectionEnabled() && this.getSelectedFile().getAbsolutePath().startsWith(AssetsController.getCategoryAbsoluteFolder(this.assetCategory))) {
                    this.selectedAsset = this.getSelectedFile().getName();
                    return 4;
                }
                if (this.isMultiSelectionEnabled() && this.getSelectedFiles()[0].getAbsolutePath().startsWith(AssetsController.getCategoryAbsoluteFolder(this.assetCategory))) {
                    this.selectedAsset = this.getSelectedFile().getName();
                    return 4;
                }
                return 5;
            }
            if (this.selectedAsset != null && this.getSelectedFile() == null) {
                return 4;
            }
            return 1;
        }
        return n;
    }

    public class ButtonsListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == AssetChooser.this.approveButton) {
                if (AssetChooser.this.showingZipContents) {
                    if (!AssetChooser.this.isMultiSelectionEnabled()) {
                        if (AssetChooser.this.assetsList.getSelectedValue() == null) {
                            AssetChooser.this.selectedAsset = null;
                            AssetChooser.this.selectedAssets.clear();
                        } else {
                            AssetChooser.this.selectedAsset = AssetChooser.this.assetsList.getSelectedValue().toString();
                        }
                    } else {
                        AssetChooser.this.selectedAssets.clear();
                        for (Object object : AssetChooser.this.assetsList.getSelectedValues()) {
                            AssetChooser.this.selectedAssets.add(object.toString());
                        }
                    }
                } else if (AssetChooser.this.getSelectedFile() != null && AssetChooser.this.getSelectedFile().getParentFile() != null) {
                    Controller.getInstance().setLastDirectory(AssetChooser.this.getSelectedFile().getParent());
                }
                AssetChooser.this.approveSelection();
            } else if (actionEvent.getSource() == AssetChooser.this.cancelButton) {
                AssetChooser.this.selectedAsset = null;
                AssetChooser.this.selectedAssets.clear();
                AssetChooser.this.cancelSelection();
            }
        }
    }

    public class ChangeDirectoryListener
    implements ActionListener,
    PropertyChangeListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AssetChooser.this.setCurrentDirectory((File)new es.eucm.eadventure.common.auxiliar.File(Controller.getInstance().getProjectFolder()));
            AssetChooser.this.explorerPanel = AssetChooser.this.zipContentsPanel;
            AssetChooser.this.showingZipContents = true;
            AssetChooser.this.setSelectedFile(null);
            AssetChooser.this.mainPanel.removeAll();
            AssetChooser.this.createCentralPanel();
            AssetChooser.this.mainPanel.updateUI();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("directoryChanged")) {
                AssetChooser.this.explorerPanel = AssetChooser.this.filePanel;
                AssetChooser.this.showingZipContents = false;
                AssetChooser.this.setSelectedAsset(null);
                AssetChooser.this.mainPanel.removeAll();
                AssetChooser.this.createCentralPanel();
                AssetChooser.this.mainPanel.updateUI();
            } else if (propertyChangeEvent.getPropertyName().equals("SelectedFileChangedProperty")) {
                AssetChooser.this.updatePreview();
            }
        }
    }

    private class DefaultResourcesListListener
    implements ListSelectionListener {
        private DefaultResourcesListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (((JList)listSelectionEvent.getSource()).getSelectedIndex() >= 0) {
                AssetChooser.this.setSelectedFile(null);
            }
        }
    }

    private class ResourcesListListener
    implements ListSelectionListener {
        private ResourcesListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (AssetChooser.this.isMultiSelectionEnabled()) {
                AssetChooser.this.selectedAssets.clear();
                for (Object object : ((JList)listSelectionEvent.getSource()).getSelectedValues()) {
                    AssetChooser.this.selectedAssets.add(object.toString());
                }
            }
            if (((JList)listSelectionEvent.getSource()).getSelectedIndex() >= 0) {
                AssetChooser.this.setSelectedAsset(((JList)listSelectionEvent.getSource()).getSelectedValue().toString());
            } else {
                AssetChooser.this.setSelectedAsset(null);
            }
            AssetChooser.this.updatePreview();
        }
    }
}

