/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.auxiliar.filefilters.FolderFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ProjectFolderChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private JTextField projectName = null;

    private static File getDefaultSelectedFile() {
        String string = TC.get((String)"Operation.NewFileTitle");
        File file = ProjectFolderChooser.getProjectsFolder();
        int n = 0;
        while (new File(file, string).exists()) {
            string = TC.get((String)"Operation.NewFileTitle") + " (" + ++n + ")";
        }
        return new File(string);
    }

    private static File getProjectsFolder() {
        es.eucm.eadventure.common.auxiliar.File file = ReleaseFolders.projectsFolder();
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public ProjectFolderChooser(boolean bl, boolean bl2) {
        super(ProjectFolderChooser.getProjectsFolder());
        super.setDialogTitle(TC.get((String)"Operation.NewProjectTitle"));
        super.setMultiSelectionEnabled(false);
        super.setFileSelectionMode(2);
        for (FileFilter fileFilter : super.getChoosableFileFilters()) {
            super.removeChoosableFileFilter(fileFilter);
        }
        FolderFileFilter folderFileFilter = new FolderFileFilter(bl, bl2, this);
        super.addChoosableFileFilter((FileFilter)((Object)folderFileFilter));
        super.setFileFilter((FileFilter)((Object)folderFileFilter));
        super.setFileHidingEnabled(true);
        super.setSelectedFile(ProjectFolderChooser.getDefaultSelectedFile());
        super.setAcceptAllFileFilterUsed(false);
        this.preparePanel();
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            this.setPreferredSize(new Dimension(700, 600));
        }
    }

    private void preparePanel() {
        String string = TC.get((String)"Operation.NewProjectTitle");
        this.putClientProperty("AccessibleDescription", string);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setColumns(10);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFont(new Font("Serif", 0, 12));
        jTextArea.setEditable(false);
        jTextArea.setBackground(jPanel2.getBackground());
        jTextArea.setText(TC.get((String)"Operation.NewProjectMessage", (String)FolderFileFilter.getAllowedChars()));
        jPanel2.add((Component)jTextArea, "North");
        String string2 = System.getProperty("os.name");
        if (string2.contains("MAC") || string2.contains("mac") || string2.contains("Mac")) {
            this.projectName = new JTextField(30);
            this.projectName.setText(ProjectFolderChooser.getDefaultSelectedFile().getName());
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel(TC.get((String)"Operation.NewProjectName")));
            jPanel3.add(this.projectName);
            JButton jButton = new JButton(TC.get((String)"Operation.CreateNewProject"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ProjectFolderChooser.this.projectName.getText() != null) {
                        File file;
                        String string = ProjectFolderChooser.this.projectName.getText();
                        if (!string.endsWith(".eap")) {
                            string = string + ".eap";
                        }
                        if (!(file = new File(ProjectFolderChooser.this.getCurrentDirectory().getAbsolutePath() + File.separatorChar + string)).exists()) {
                            try {
                                file.createNewFile();
                                ProjectFolderChooser.this.updateUI();
                                ProjectFolderChooser.this.setSelectedFile(file);
                                ProjectFolderChooser.this.approveSelection();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
            jPanel3.add(jButton);
            jPanel2.add((Component)jPanel3, "South");
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createOpenFilePanel(), "Center");
        jPanel.add((Component)jPanel2, "North");
        this.add(jPanel);
    }

    private JPanel createOpenFilePanel() {
        JPanel jPanel;
        block3: {
            LayoutManager layoutManager;
            block2: {
                jPanel = new JPanel();
                layoutManager = this.getLayout();
                if (!(layoutManager instanceof BorderLayout)) break block2;
                jPanel.setLayout(new BorderLayout());
                BorderLayout borderLayout = (BorderLayout)this.getLayout();
                for (Component component : this.getComponents()) {
                    jPanel.add(component, borderLayout.getConstraints(component));
                }
                break block3;
            }
            if (!(layoutManager instanceof BoxLayout)) break block3;
            BoxLayout boxLayout = (BoxLayout)this.getLayout();
            jPanel.setLayout(new BoxLayout(jPanel, boxLayout.getAxis()));
            for (Component component : this.getComponents()) {
                jPanel.add(component);
            }
        }
        return jPanel;
    }
}

