/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui;

import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.auxiliar.filefilters.FolderFileFilter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.gui.Updateable;
import es.eucm.eadventure.editor.gui.editdialogs.GenericFileChooserDialog;
import es.eucm.eadventure.editor.gui.editdialogs.GenericOptionPaneDialog;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;
import es.eucm.eadventure.editor.gui.structurepanel.StructurePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Controller controller = Controller.getInstance();
    private JMenu chaptersMenu;
    private JMenuItem itPlayerMode;
    private StructurePanel structurePanel;
    private Stack<Window> windowsStack;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenu fileMenu;
    private JCheckBoxMenuItem itAutoBackup;
    private JMenu configurationMenu;
    private JMenu runMenu;

    public MainWindow() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(new ImageIcon("img/Icono-Editor-16x16.png").getImage());
        arrayList.add(new ImageIcon("img/Icono-Editor-32x32.png").getImage());
        arrayList.add(new ImageIcon("img/Icono-Editor-64x64.png").getImage());
        arrayList.add(new ImageIcon("img/Icono-Editor-128x128.png").getImage());
        this.setIconImages(arrayList);
        this.setJMenuBar(this.createMenuBar());
        JPanel jPanel = new JPanel(){

            @Override
            public Component add(Component component) {
                this.removeAll();
                return super.add(component);
            }
        };
        jPanel.setMinimumSize(new Dimension(400, 0));
        jPanel.setLayout(new BorderLayout());
        this.structurePanel = new StructurePanel(jPanel);
        this.structurePanel.recreateElements();
        this.structurePanel.setMinimumSize(new Dimension(210, 0));
        this.structurePanel.setMaximumSize(new Dimension(210, Integer.MAX_VALUE));
        this.structurePanel.setPreferredSize(new Dimension(210, 0));
        StructureControl.getInstance().setStructurePanel(this.structurePanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setMinimumSize(new Dimension(210, 0));
        jPanel2.setMaximumSize(new Dimension(210, Integer.MAX_VALUE));
        jPanel2.add((Component)this.structurePanel, "Center");
        JPanel jPanel3 = this.createToolsPanel();
        jPanel2.add((Component)jPanel3, "North");
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, jPanel);
        jSplitPane.setBorder(null);
        this.setLayout(new BorderLayout());
        this.add((Component)jSplitPane, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainWindow.this.controller.exit();
            }
        });
        this.windowsStack = new Stack();
        this.setMinimumSize(new Dimension(640, 400));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)Math.min(960.0, dimension.getWidth());
        int n2 = (int)Math.min(720.0, dimension.getHeight());
        this.setSize(n, n2);
        this.setLocation(Math.max((dimension.width - n) / 2, 0), Math.max((dimension.height - n2) / 2, 0));
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.updateTitle();
    }

    private JPanel createToolsPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = this.createToolButton("img/icons/undo.png", TC.get((String)"Tools.Undo"));
        JButton jButton2 = this.createToolButton("img/icons/redo.png", TC.get((String)"Tools.Redo"));
        JButton jButton3 = this.createToolButton("img/icons/moveNodeLeft.png", TC.get((String)"Tools.Back"));
        JButton jButton4 = this.createToolButton("img/icons/moveNodeRight.png", TC.get((String)"Tools.Forward"));
        JButton jButton5 = this.createToolButton("img/icons/find.png", TC.get((String)"Tools.Find"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.undoTool();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.redoTool();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.search();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureControl.getInstance().goBack();
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureControl.getInstance().goForward();
            }
        });
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 24));
        jPanel.add(jSeparator);
        jPanel.add(jButton5);
        jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 24));
        jPanel.add(jSeparator);
        jPanel.add(jButton3);
        jPanel.add(jButton4);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), TC.get((String)"Tools.Title")));
        return jPanel;
    }

    private JButton createToolButton(String string, String string2) {
        JButton jButton = new JButton(new ImageIcon(string));
        jButton.setPreferredSize(new Dimension(24, 22));
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        jButton.setToolTipText(string2);
        return jButton;
    }

    private JMenuBar createMenuBar() {
        return this.createMenuBarAdventureMode();
    }

    private JMenuBar createMenuBarAdventureMode() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setLayout(new FlowLayout(0));
        this.fileMenu = new JMenu(TC.get((String)"MenuFile.Title"));
        this.fileMenu.setMnemonic(70);
        jMenuBar.add(this.fileMenu);
        JMenu jMenu = new JMenu(TC.get((String)"MenuEdit.Title"));
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(TC.get((String)"MenuAdventure.Title"));
        jMenu2.setEnabled(Controller.getInstance().isFolderLoaded());
        jMenu2.setMnemonic(65);
        jMenuBar.add(jMenu2);
        this.chaptersMenu = new JMenu(TC.get((String)"MenuChapters.Title"));
        this.chaptersMenu.setEnabled(Controller.getInstance().isFolderLoaded());
        this.chaptersMenu.setMnemonic(72);
        jMenuBar.add(this.chaptersMenu);
        this.runMenu = new JMenu(TC.get((String)"MenuRun.Title"));
        this.runMenu.setEnabled(Controller.getInstance().isFolderLoaded());
        jMenuBar.add(this.runMenu);
        this.configurationMenu = new JMenu(TC.get((String)"MenuConfiguration.Title"));
        this.configurationMenu.setMnemonic(84);
        jMenuBar.add(this.configurationMenu);
        JMenu jMenu3 = new JMenu(TC.get((String)"Menu.About"));
        JMenuItem jMenuItem = new JMenuItem(TC.get((String)"Menu.AboutEAD"));
        jMenu3.add(jMenuItem);
        jMenuItem.setArmed(false);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showAboutDialog();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(TC.get((String)"Menu.SendComments"));
        jMenu3.add(jMenuItem2);
        jMenuItem2.setArmed(false);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.GenerateCommentsReport();
            }
        });
        jMenuBar.add(jMenu3);
        JMenuItem jMenuItem3 = new JMenuItem(TC.get((String)"MenuFile.New"));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.controller.newFile();
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setDaemon(false);
                thread.start();
            }
        });
        this.fileMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem(TC.get((String)"MenuFile.Load"));
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        MainWindow.this.controller.loadFile();
                    }
                };
                Thread thread = new Thread(runnable);
                thread.setDaemon(false);
                thread.start();
            }
        });
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.fileMenu.add(jMenuItem4);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem(TC.get((String)"MenuFile.Save"));
        jMenuItem5.setEnabled(this.controller.isFolderLoaded());
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.saveFile(false);
            }
        });
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(TC.get((String)"MenuFile.SaveAs"));
        jMenuItem6.setEnabled(this.controller.isFolderLoaded());
        jMenuItem6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.saveFile(true);
            }
        });
        this.fileMenu.add(jMenuItem6);
        this.fileMenu.addSeparator();
        JMenu jMenu4 = new JMenu(TC.get((String)"MenuFile.AllLOMProperties"));
        JMenuItem jMenuItem7 = new JMenuItem(TC.get((String)"MenuFile.LOMProperties"));
        jMenuItem7.setEnabled(this.controller.isFolderLoaded());
        jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showLOMDataDialog();
            }
        });
        jMenu4.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(TC.get((String)"MenuFile.LOMSCORMProperties"));
        jMenuItem8.setEnabled(this.controller.isFolderLoaded());
        jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showLOMSCORMDataDialog();
            }
        });
        jMenu4.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem(TC.get((String)"MenuFile.LOMESProperties"));
        jMenuItem9.setEnabled(this.controller.isFolderLoaded() && this.controller.getLanguage().toLowerCase().contains("es"));
        jMenuItem9.setToolTipText(this.controller.getLanguage().toLowerCase().contains("es") ? "" : TC.get((String)"LOMES.Disabled"));
        jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showLOMESDataDialog();
            }
        });
        jMenu4.add(jMenuItem9);
        this.fileMenu.add(jMenu4);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem10 = new JMenuItem(TC.get((String)"MenuFile.ImportChapter"));
        jMenuItem10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.importChapter();
            }
        });
        JMenu jMenu5 = new JMenu(TC.get((String)"MenuFile.Export"));
        jMenu5.setEnabled(this.controller.isFolderLoaded());
        JMenuItem jMenuItem11 = new JMenuItem(TC.get((String)"MenuFile.ExportGame"));
        jMenuItem11.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.exportGame();
            }
        });
        JMenuItem jMenuItem12 = new JMenuItem(TC.get((String)"MenuFile.ExportStandalone"));
        jMenuItem12.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.exportStandaloneGame();
            }
        });
        JMenuItem jMenuItem13 = new JMenuItem(TC.get((String)"MenuFile.ExportLOM"));
        jMenuItem13.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.exportToLOM();
            }
        });
        jMenu5.add(jMenuItem11);
        jMenu5.add(jMenuItem12);
        jMenu5.add(jMenuItem13);
        this.fileMenu.add(jMenu5);
        this.fileMenu.addSeparator();
        JMenuItem jMenuItem14 = new JMenuItem(TC.get((String)"MenuFile.Exit"));
        jMenuItem14.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.exit();
            }
        });
        this.fileMenu.add(jMenuItem14);
        this.undo = new JMenuItem(TC.get((String)"MenuEdit.Undo"));
        this.undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.undoTool();
            }
        });
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.redo = new JMenuItem(TC.get((String)"MenuEdit.Redo"));
        this.redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.redoTool();
            }
        });
        this.redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        JMenuItem jMenuItem15 = new JMenuItem(TC.get((String)"Search.DialogTitle"));
        jMenuItem15.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.search();
            }
        });
        jMenu.add(this.undo);
        jMenu.add(this.redo);
        jMenu.add(jMenuItem15);
        JMenuItem jMenuItem16 = new JMenuItem(TC.get((String)"MenuAdventure.CheckConsistency"));
        jMenuItem16.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.checkAdventureConsistency();
            }
        });
        jMenu2.add(jMenuItem16);
        jMenu2.addSeparator();
        JMenuItem jMenuItem17 = new JMenuItem(TC.get((String)"MenuAdventure.AdventureData"));
        jMenuItem17.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showAdventureDataDialog();
            }
        });
        jMenu2.add(jMenuItem17);
        JMenu jMenu6 = new JMenu(TC.get((String)"MenuAdventure.Visualization"));
        JMenuItem jMenuItem18 = new JMenuItem(TC.get((String)"MenuAdventure.CustomizeGUI"));
        jMenuItem18.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showCustomizeGUIDialog();
            }
        });
        jMenu6.add(jMenuItem18);
        JMenuItem jMenuItem19 = new JMenuItem(TC.get((String)"MenuAdventure.GraphicConfig"));
        jMenuItem19.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showGraphicConfigDialog();
            }
        });
        jMenu6.add(jMenuItem19);
        jMenu2.add(jMenu6);
        if (this.controller.isFolderLoaded()) {
            if (this.controller.isPlayTransparent()) {
                this.itPlayerMode = new JMenuItem(TC.get((String)"MenuAdventure.ChangeToModePlayerVisible"));
                this.itPlayerMode.setToolTipText(TC.get((String)"MenuAdventure.ModePlayerVisible"));
            } else {
                this.itPlayerMode = new JMenuItem(TC.get((String)"MenuAdventure.ChangeToModePlayerTransparent"));
                this.itPlayerMode.setToolTipText(TC.get((String)"MenuAdventure.ModePlayerTransparent"));
            }
        } else {
            this.itPlayerMode = new JMenuItem(TC.get((String)"MenuAdventure.ChangeToModePlayerVisible"));
            this.itPlayerMode.setEnabled(false);
        }
        this.itPlayerMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.swapPlayerMode(true);
                MainWindow.this.reloadData();
            }
        });
        jMenu2.add(this.itPlayerMode);
        jMenu2.addSeparator();
        JMenuItem jMenuItem20 = new JMenuItem(TC.get((String)"MenuAdventure.DeleteUnusedAssets"));
        jMenuItem20.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.deleteUnsuedAssets();
            }
        });
        jMenu2.add(jMenuItem20);
        JMenuItem jMenuItem21 = new JMenuItem(TC.get((String)"MenuChapters.AddChapter"));
        jMenuItem21.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.addChapter();
            }
        });
        this.chaptersMenu.add(jMenuItem21);
        JMenuItem jMenuItem22 = new JMenuItem(TC.get((String)"MenuChapters.DeleteChapter"));
        jMenuItem22.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.deleteChapter();
            }
        });
        this.chaptersMenu.add(jMenuItem22);
        JMenuItem jMenuItem23 = new JMenuItem(TC.get((String)"MenuChapters.ImportChapter"));
        jMenuItem23.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.importChapter();
            }
        });
        this.chaptersMenu.add(jMenuItem23);
        this.chaptersMenu.addSeparator();
        JMenuItem jMenuItem24 = new JMenuItem(TC.get((String)"MenuChapters.MoveChapterUp"));
        jMenuItem24.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.moveChapterUp();
            }
        });
        this.chaptersMenu.add(jMenuItem24);
        JMenuItem jMenuItem25 = new JMenuItem(TC.get((String)"MenuChapters.MoveChapterDown"));
        jMenuItem25.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.moveChapterDown();
            }
        });
        this.chaptersMenu.add(jMenuItem25);
        this.chaptersMenu.addSeparator();
        JMenuItem jMenuItem26 = new JMenuItem(TC.get((String)"MenuChapters.Flags"));
        jMenuItem26.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.showEditFlagDialog();
            }
        });
        jMenuItem26.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.chaptersMenu.add(jMenuItem26);
        this.chaptersMenu.addSeparator();
        this.updateChapterMenu();
        JMenuItem jMenuItem27 = new JMenuItem(TC.get((String)"MenuRun.Normal"));
        jMenuItem27.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem27.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.run();
            }
        });
        this.runMenu.add(jMenuItem27);
        JMenuItem jMenuItem28 = new JMenuItem(TC.get((String)"MenuRun.Debug"));
        jMenuItem28.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenuItem28.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.debugRun();
            }
        });
        this.runMenu.add(jMenuItem28);
        this.itAutoBackup = new JCheckBoxMenuItem(TC.get((String)"MenuConfiguration.AutoBackup"), this.controller.getAutoSaveEnabled());
        this.itAutoBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.controller.setAutoSaveEnabled(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        JMenu jMenu7 = new JMenu(TC.get((String)"MenuConfiguration.Language"));
        for (final String string : ReleaseFolders.getLanguages((String)"editor")) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(ReleaseFolders.getLanguageName((String)string), this.controller.getLanguage().equals(string));
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MainWindow.this.controller.setLanguage(string);
                }
            });
            jMenu7.add(jCheckBoxMenuItem);
        }
        this.configurationMenu.add(jMenu7);
        return jMenuBar;
    }

    public void setNormalRunAvailable(boolean bl) {
        this.runMenu.setEnabled(bl);
        this.fileMenu.setEnabled(bl);
        this.chaptersMenu.setEnabled(bl);
        this.itPlayerMode.setEnabled(bl);
        this.configurationMenu.setEnabled(bl);
    }

    public void reloadData() {
        this.structurePanel.recreateElements();
        this.updateChapterMenu();
        if (this.controller.isPlayTransparent()) {
            this.itPlayerMode.setText(TC.get((String)"MenuAdventure.ChangeToModePlayerVisible"));
            this.itPlayerMode.setToolTipText(TC.get((String)"MenuAdventure.ModePlayerVisible"));
        } else {
            this.itPlayerMode.setText(TC.get((String)"MenuAdventure.ChangeToModePlayerTransparent"));
            this.itPlayerMode.setToolTipText(TC.get((String)"MenuAdventure.ModePlayerTransparent"));
        }
        this.itAutoBackup.setSelected(this.controller.getAutoSaveEnabled());
        StructureControl.getInstance().changeDataControl(this.controller.getSelectedChapterDataControl());
        StructureControl.getInstance().visitDataControl(this.controller.getSelectedChapterDataControl());
        this.setJMenuBar(this.createMenuBar());
        this.getJMenuBar().updateUI();
        this.updateTitle();
        this.repaint();
    }

    public void updateTitle() {
        String string = this.controller.isDataModified() ? " *" : "";
        this.setTitle(TC.get((String)"MainWindow.Title", (String)this.controller.getFileName()) + string);
    }

    public void updateChapterMenu() {
        int n = 0;
        while (this.chaptersMenu.getItemCount() > 8) {
            this.chaptersMenu.remove(8);
        }
        if (Controller.getInstance().isFolderLoaded()) {
            n = 0;
            ButtonGroup buttonGroup = new ButtonGroup();
            for (String string : this.controller.getChapterTitles()) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(n + 1 + ": " + string, this.controller.getSelectedChapter() == n);
                jRadioButtonMenuItem.setEnabled(true);
                jRadioButtonMenuItem.addActionListener(new ChapterMenuItemListener(n));
                if (n < 9) {
                    jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(49 + n++, 2));
                }
                buttonGroup.add(jRadioButtonMenuItem);
                this.chaptersMenu.add(jRadioButtonMenuItem);
            }
        }
        if (n < 2) {
            this.chaptersMenu.getItem(4).setEnabled(false);
            this.chaptersMenu.getItem(5).setEnabled(false);
        }
    }

    public void updateStructure() {
        this.structurePanel.update();
    }

    public void updatePanel() {
        for (Window window : this.windowsStack) {
            if (!(window instanceof Updateable)) continue;
            ((Updateable)((Object)window)).updateFields();
        }
        this.structurePanel.updateElementPanel();
    }

    public void reloadPanel() {
        for (Window window : this.windowsStack) {
            if (!(window instanceof Updateable)) continue;
            ((Updateable)((Object)window)).updateFields();
        }
        this.structurePanel.reloadElementPanel();
    }

    public Window peekWindow() {
        Window window = this.windowsStack.empty() ? this : this.windowsStack.peek();
        return window;
    }

    public void pushWindow(Window window) {
        this.windowsStack.push(window);
    }

    public void popWindow() {
        if (!this.windowsStack.isEmpty()) {
            this.windowsStack.pop();
        }
        this.structurePanel.updateElementPanel();
    }

    public String showSingleSelectionLoadDialog(String string, FileFilter fileFilter) {
        String string2 = null;
        if (string == null) {
            string = ".";
        }
        GenericFileChooserDialog genericFileChooserDialog = new GenericFileChooserDialog(string);
        genericFileChooserDialog.setAcceptAllFileFilterUsed(false);
        genericFileChooserDialog.setFileFilter(fileFilter);
        if (genericFileChooserDialog.showOpenDialog(this.peekWindow()) == 0) {
            string2 = genericFileChooserDialog.getSelectedFile().getAbsolutePath();
        }
        return string2;
    }

    public String[] showMultipleSelectionLoadDialog(String string, FileFilter fileFilter) {
        String[] stringArray = null;
        if (string == null) {
            string = ".";
        }
        GenericFileChooserDialog genericFileChooserDialog = new GenericFileChooserDialog(string);
        genericFileChooserDialog.setAcceptAllFileFilterUsed(false);
        genericFileChooserDialog.setMultiSelectionEnabled(true);
        genericFileChooserDialog.setFileFilter(fileFilter);
        if (genericFileChooserDialog.showOpenDialog(this.peekWindow()) == 0) {
            File[] fileArray = genericFileChooserDialog.getSelectedFiles();
            stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getAbsolutePath();
            }
        }
        return stringArray;
    }

    public String showSaveDialog(String string, FileFilter fileFilter) {
        String string2 = null;
        GenericFileChooserDialog genericFileChooserDialog = new GenericFileChooserDialog(string);
        if (fileFilter instanceof FolderFileFilter) {
            ((FolderFileFilter)((Object)fileFilter)).setFileChooser(genericFileChooserDialog);
        }
        genericFileChooserDialog.setFileFilter(fileFilter);
        if (genericFileChooserDialog.showSaveDialog(this.peekWindow()) == 0) {
            string2 = genericFileChooserDialog.getSelectedFile().getAbsolutePath();
        }
        return string2;
    }

    public int showOptionDialog(String string, String string2, String[] stringArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTextPane jTextPane = new JTextPane();
        jTextPane.setPreferredSize(new Dimension(220, 80));
        jTextPane.setEditable(false);
        jTextPane.setBackground(jPanel.getBackground());
        jTextPane.setText(string2);
        jPanel.add((Component)jTextPane, "Center");
        return (Integer)GenericOptionPaneDialog.showOptionDialog(this.peekWindow(), string, string2, -1, stringArray);
    }

    public int showConfirmDialog(String string, String string2) {
        return (Integer)GenericOptionPaneDialog.showConfirmDialog(this.peekWindow(), string, string2, 3, 1);
    }

    public boolean showStrictConfirmDialog(String string, String string2) {
        return (Integer)GenericOptionPaneDialog.showConfirmDialog(this.peekWindow(), string, string2, 3, 0) == 0;
    }

    public String showInputDialog(String string, String string2, String string3) {
        return (String)GenericOptionPaneDialog.showInputDialog(this.peekWindow(), string, string2, -1, null, string3);
    }

    public String showInputDialog(String string, String string2) {
        return (String)GenericOptionPaneDialog.showInputDialog(this.peekWindow(), string, string2, -1, null, null);
    }

    public String showInputDialog(String string, String string2, Object[] objectArray) {
        return (String)GenericOptionPaneDialog.showInputDialog(this.peekWindow(), string, string2, -1, objectArray, null);
    }

    public void showInformationDialog(String string, String string2) {
        GenericOptionPaneDialog.showMessageDialog(this.peekWindow(), string, string2, 1);
    }

    public void showWarningDialog(String string, String string2) {
        GenericOptionPaneDialog.showMessageDialog(this.peekWindow(), string, string2, 2);
    }

    public void showErrorDialog(String string, String string2) {
        GenericOptionPaneDialog.showMessageDialog(this.peekWindow(), string, string2, 0);
    }

    private class ChapterMenuItemListener
    implements ActionListener {
        private int chapterIndex;

        public ChapterMenuItemListener(int n) {
            this.chapterIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainWindow.this.controller.setSelectedChapter(this.chapterIndex);
        }
    }
}

