/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.gui;

import es.eucm.eadventure.common.auxiliar.CreateImage;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class LoadingScreen
extends JFrame {
    private String message;
    private ImageIcon icon;
    private int status;
    private Timer thread;

    private void setStatus(int n) {
        this.status = n;
    }

    private int getStatus() {
        return this.status;
    }

    public LoadingScreen(String string, String string2, Window window) {
        super.setUndecorated(true);
        this.setImage(string2);
        this.message = string;
        int n = this.icon.getImage().getWidth(this);
        int n2 = this.icon.getImage().getHeight(this);
        this.setSize(n, n2);
        this.setResizable(false);
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int n3 = Math.round((float)((int)d - n) / 2.0f);
        int n4 = Math.round((float)((int)d2 - n2) / 2.0f);
        this.setLocation(n3, n4);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setResizable(false);
        ArrayList<Image> arrayList = new ArrayList<Image>();
        arrayList.add(AssetsController.getImage("img/Icono-Editor-16x16.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-32x32.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-64x64.png"));
        arrayList.add(AssetsController.getImage("img/Icono-Editor-128x128.png"));
        this.setIconImages(arrayList);
        this.status = 0;
        this.thread = new Timer();
        this.thread.start();
    }

    public void close() {
        this.thread.setStop(true);
        this.dispose();
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setImage(String string) {
        this.icon = string != null ? new ImageIcon(string) : null;
        if (this.icon != null && this.icon.getImage() == null) {
            this.icon = null;
        }
        if (this.icon == null) {
            this.icon = new ImageIcon(CreateImage.createImage((int)400, (int)300, (Color)new Color(250, 208, 108), (int)15, (Color)new Color(158, 94, 30), (String)"Loading / Cargando", (Color)new Color(158, 94, 30), (int)0, (int)0, (Font)new Font("Arial", 0, 14)));
        }
    }

    public void paintComponent(Graphics graphics) {
        LoadingScreen.paintLoadingScreen(graphics, this.message, this.icon, this.status, 0, 0);
    }

    public static void paintLoadingScreen(Graphics graphics, String string, ImageIcon imageIcon, int n, int n2, int n3) {
        String string2 = string;
        switch (n) {
            case 1: {
                string2 = string2 + " .";
                break;
            }
            case 2: {
                string2 = string2 + " ..";
                break;
            }
            case 3: {
                string2 = string2 + " ...";
                break;
            }
            case 4: {
                string2 = string2 + " ....";
            }
        }
        graphics.drawImage(imageIcon.getImage(), n2, n3, null);
        if (string2.length() >= 45) {
            int n4 = string2.substring(0, 45).lastIndexOf(32);
            graphics.drawString(string2.substring(0, n4), n2 + 100, n3 + 263);
            graphics.drawString(string2.substring(n4 + 1, string2.length()), n2 + 100, n3 + 278);
        } else {
            graphics.drawString(string2, n2 + 100, n3 + 265);
        }
        graphics.dispose();
    }

    public class Timer
    extends Thread {
        boolean stop = false;

        private boolean isStop() {
            return this.stop;
        }

        @Override
        public void run() {
            while (!this.isStop()) {
                try {
                    Thread.sleep(400L);
                    LoadingScreen.this.setStatus((LoadingScreen.this.getStatus() + 1) % 5);
                    if (!LoadingScreen.this.isVisible()) continue;
                    LoadingScreen.this.paintComponent(LoadingScreen.this.getGraphics());
                }
                catch (InterruptedException interruptedException) {
                    ReportDialog.GenerateErrorReport((Exception)interruptedException, (boolean)true, (String)"UNKNOWERROR");
                }
            }
        }

        public void setStop(boolean bl) {
            this.stop = bl;
        }
    }
}

