/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.data.support;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import java.util.ArrayList;
import java.util.List;

public class VarFlagSummary {
    private List<String> flags = new ArrayList<String>();
    private List<Integer> flagReferences = new ArrayList<Integer>();
    private List<String> vars = new ArrayList<String>();
    private List<Integer> varReferences = new ArrayList<Integer>();

    public void clearReferences() {
        int n;
        this.flagReferences.clear();
        for (n = 0; n < this.flags.size(); ++n) {
            this.flagReferences.add(0);
        }
        this.varReferences.clear();
        for (n = 0; n < this.vars.size(); ++n) {
            this.varReferences.add(0);
        }
    }

    public void clean() {
        int n;
        for (n = 0; n < this.flagReferences.size(); ++n) {
            if (this.flagReferences.get(n) != 0) continue;
            this.flags.remove(n);
        }
        while (this.flagReferences.contains(0)) {
            this.flagReferences.remove(new Integer(0));
        }
        for (n = 0; n < this.varReferences.size(); ++n) {
            if (this.varReferences.get(n) != 0) continue;
            this.vars.remove(n);
        }
        while (this.varReferences.contains(0)) {
            this.varReferences.remove(new Integer(0));
        }
    }

    public boolean addFlag(String string) {
        boolean bl = false;
        if (!this.existsFlag(string)) {
            this.flags.add(string);
            this.flagReferences.add(0);
            bl = true;
            this.sortList(this.flags, this.flagReferences);
        }
        return bl;
    }

    public boolean deleteFlag(String string) {
        boolean bl = false;
        int n = this.flags.indexOf(string);
        if (n >= 0) {
            this.flags.remove(n);
            this.flagReferences.remove(n);
            bl = true;
        }
        return bl;
    }

    public boolean addVar(String string) {
        boolean bl = false;
        if (!this.existsFlag(string)) {
            this.vars.add(string);
            this.varReferences.add(0);
            bl = true;
            this.sortList(this.vars, this.varReferences);
        }
        return bl;
    }

    public boolean deleteVar(String string) {
        boolean bl = false;
        int n = this.vars.indexOf(string);
        if (n >= 0) {
            this.vars.remove(n);
            this.varReferences.remove(n);
            bl = true;
        }
        return bl;
    }

    public void addReference(String string) {
        if (this.flags.contains(string)) {
            this.addFlagReference(string);
        } else if (this.vars.contains(string)) {
            this.addVarReference(string);
        }
    }

    public void addFlagReference(String string) {
        int n = this.flags.indexOf(string);
        if (n >= 0) {
            int n2 = this.flagReferences.get(n) + 1;
            this.flagReferences.set(n, n2);
        } else {
            this.flags.add(string);
            this.flagReferences.add(1);
            this.sortList(this.flags, this.flagReferences);
        }
    }

    public void deleteFlagReference(String string) {
        int n = this.flags.indexOf(string);
        if (n >= 0) {
            int n2 = this.flagReferences.get(n) - 1;
            this.flagReferences.set(n, n2);
        } else {
            System.err.println("Error: Trying to delete a nonexistent flag");
        }
    }

    public void deleteReference(String string) {
        if (this.flags.contains(string)) {
            this.deleteFlagReference(string);
        } else if (this.vars.contains(string)) {
            this.deleteVarReference(string);
        }
    }

    public void addVarReference(String string) {
        int n = this.vars.indexOf(string);
        if (n >= 0) {
            int n2 = this.varReferences.get(n) + 1;
            this.varReferences.set(n, n2);
        } else {
            this.vars.add(string);
            this.varReferences.add(1);
            this.sortList(this.vars, this.varReferences);
        }
    }

    public void deleteVarReference(String string) {
        int n = this.vars.indexOf(string);
        if (n >= 0) {
            int n2 = this.varReferences.get(n) - 1;
            this.varReferences.set(n, n2);
        } else {
            System.err.println("Error: Trying to delete a nonexistent var");
        }
    }

    public boolean existsFlag(String string) {
        return this.flags.contains(string);
    }

    public boolean existsVar(String string) {
        return this.vars.contains(string);
    }

    public boolean existsId(String string) {
        return this.existsFlag(string) || this.existsVar(string);
    }

    public int getFlagCount() {
        return this.flags.size();
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public String getFlag(int n) {
        return this.flags.get(n);
    }

    public String getVar(int n) {
        return this.vars.get(n);
    }

    public int getFlagReferences(int n) {
        return this.flagReferences.get(n);
    }

    public int getVarReferences(int n) {
        return this.varReferences.get(n);
    }

    public String[] getFlags() {
        return this.flags.toArray(new String[0]);
    }

    public String[] getVars() {
        return this.vars.toArray(new String[0]);
    }

    public String[] getVarsAndFlags() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.vars);
        arrayList.addAll(this.flags);
        arrayList.add("report");
        return arrayList.toArray(new String[0]);
    }

    private void sortList(List<String> list, List<Integer> list2) {
        try {
            for (int i = 0; i < list.size() - 1; ++i) {
                for (int j = 0; j < list.size() - 1 - i; ++j) {
                    if (list.get(j).compareTo(list.get(j + 1)) <= 0) continue;
                    list.add(j + 1, list.remove(j));
                    list2.add(j + 1, list2.remove(j));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            ReportDialog.GenerateErrorReport((Exception)nullPointerException, (boolean)true, (String)"UNKNOWERROR");
        }
    }
}

