/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.data.support;

import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdentifierSummary {
    private List<String> globalIdentifiers = new ArrayList<String>();
    private List<String> generalSceneIdentifiers = new ArrayList<String>();
    private List<String> sceneIdentifiers = new ArrayList<String>();
    private List<String> cutsceneIdentifiers = new ArrayList<String>();
    private List<String> bookIdentifiers = new ArrayList<String>();
    private List<String> itemIdentifiers = new ArrayList<String>();
    private List<String> atrezzoIdentifiers = new ArrayList<String>();
    private List<String> npcIdentifiers = new ArrayList<String>();
    private List<String> conversationIdentifiers = new ArrayList<String>();
    private Map<String, List<String>> assessmentIdentifiers = new HashMap<String, List<String>>();
    private Map<String, List<String>> adaptationIdentifiers = new HashMap<String, List<String>>();
    private List<String> globalStateIdentifiers = new ArrayList<String>();
    private List<String> macroIdentifiers = new ArrayList<String>();
    private List<String> activeAreaIdentifiers = new ArrayList<String>();

    public IdentifierSummary(Chapter chapter) {
        this.loadIdentifiers(chapter);
    }

    public void loadIdentifiers(Chapter chapter) {
        Object object;
        this.globalIdentifiers.clear();
        this.generalSceneIdentifiers.clear();
        this.sceneIdentifiers.clear();
        this.cutsceneIdentifiers.clear();
        this.bookIdentifiers.clear();
        this.itemIdentifiers.clear();
        this.atrezzoIdentifiers.clear();
        this.npcIdentifiers.clear();
        this.conversationIdentifiers.clear();
        this.globalStateIdentifiers.clear();
        this.macroIdentifiers.clear();
        this.activeAreaIdentifiers.clear();
        this.assessmentIdentifiers.clear();
        this.adaptationIdentifiers.clear();
        for (Scene scene : chapter.getScenes()) {
            this.addSceneId(scene.getId());
            for (Object object2 : scene.getActiveAreas()) {
                if (object2.getId() == null || object2.getId().equals("")) continue;
                this.addActiveAreaId(object2.getId());
            }
        }
        for (Scene scene : chapter.getCutscenes()) {
            this.addCutsceneId(scene.getId());
        }
        for (Scene scene : chapter.getBooks()) {
            this.addBookId(scene.getId());
        }
        for (Scene scene : chapter.getItems()) {
            this.addItemId(scene.getId());
        }
        for (Scene scene : chapter.getAtrezzo()) {
            this.addAtrezzoId(scene.getId());
        }
        for (Scene scene : chapter.getCharacters()) {
            this.addNPCId(scene.getId());
        }
        for (Scene scene : chapter.getConversations()) {
            this.addConversationId(scene.getId());
        }
        for (Scene scene : chapter.getGlobalStates()) {
            this.addGlobalStateId(scene.getId());
        }
        for (Scene scene : chapter.getMacros()) {
            this.addMacroId(scene.getId());
        }
        for (Scene scene : chapter.getAssessmentProfiles()) {
            object = scene.getName();
            this.addAssessmentProfileId((String)object);
            for (AssessmentRule assessmentRule : scene.getRules()) {
                this.addAssessmentRuleId(assessmentRule.getId(), (String)object);
            }
        }
        for (Scene scene : chapter.getAdaptationProfiles()) {
            object = scene.getName();
            this.addAdaptationProfileId((String)object);
            for (AssessmentRule assessmentRule : scene.getRules()) {
                this.addAdaptationRuleId(assessmentRule.getId(), (String)object);
            }
        }
    }

    public boolean existsId(String string) {
        return this.globalIdentifiers.contains(string);
    }

    public boolean isScene(String string) {
        return this.sceneIdentifiers.contains(string);
    }

    public boolean isConversation(String string) {
        return this.conversationIdentifiers.contains(string);
    }

    public String[] getGeneralSceneIds() {
        return this.generalSceneIdentifiers.toArray(new String[0]);
    }

    public String[] getSceneIds() {
        return this.sceneIdentifiers.toArray(new String[0]);
    }

    public String[] getCutsceneIds() {
        return this.cutsceneIdentifiers.toArray(new String[0]);
    }

    public String[] getAllSceneIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.cutsceneIdentifiers);
        arrayList.addAll(new ArrayList<String>(this.sceneIdentifiers));
        return arrayList.toArray(new String[0]);
    }

    public String[] getBookIds() {
        return this.bookIdentifiers.toArray(new String[0]);
    }

    public String[] getItemIds() {
        return this.itemIdentifiers.toArray(new String[0]);
    }

    public String[] getAtrezzoIds() {
        return this.atrezzoIdentifiers.toArray(new String[0]);
    }

    public String[] getNPCIds() {
        return this.npcIdentifiers.toArray(new String[0]);
    }

    public String[] getConversationsIds() {
        return this.conversationIdentifiers.toArray(new String[0]);
    }

    public String[] getGlobalStatesIds() {
        return this.globalStateIdentifiers.toArray(new String[0]);
    }

    public String[] getMacroIds() {
        return this.macroIdentifiers.toArray(new String[0]);
    }

    public String[] getGlobalStatesIds(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.globalStateIdentifiers) {
            for (String string2 : stringArray) {
                if (string.equals(string2)) continue;
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getMacroIds(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.macroIdentifiers) {
            if (string2.equals(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public void addSceneId(String string) {
        this.globalIdentifiers.add(string);
        this.generalSceneIdentifiers.add(string);
        this.sceneIdentifiers.add(string);
    }

    public void addCutsceneId(String string) {
        this.globalIdentifiers.add(string);
        this.generalSceneIdentifiers.add(string);
        this.cutsceneIdentifiers.add(string);
    }

    public void addBookId(String string) {
        this.globalIdentifiers.add(string);
        this.bookIdentifiers.add(string);
    }

    public void addItemId(String string) {
        this.globalIdentifiers.add(string);
        this.itemIdentifiers.add(string);
    }

    public void addAtrezzoId(String string) {
        this.globalIdentifiers.add(string);
        this.atrezzoIdentifiers.add(string);
    }

    public void addNPCId(String string) {
        this.globalIdentifiers.add(string);
        this.npcIdentifiers.add(string);
    }

    public void addConversationId(String string) {
        this.globalIdentifiers.add(string);
        this.conversationIdentifiers.add(string);
    }

    public void addGlobalStateId(String string) {
        this.globalIdentifiers.add(string);
        this.globalStateIdentifiers.add(string);
    }

    public void addMacroId(String string) {
        this.globalIdentifiers.add(string);
        this.macroIdentifiers.add(string);
    }

    public void addAssessmentRuleId(String string, String string2) {
        this.globalIdentifiers.add(string2 + "." + string);
        this.assessmentIdentifiers.get(string2).add(string);
    }

    public void addAdaptationRuleId(String string, String string2) {
        this.globalIdentifiers.add(string2 + "." + string);
        this.adaptationIdentifiers.get(string2).add(string);
    }

    public void addAssessmentProfileId(String string) {
        this.globalIdentifiers.add(string);
        this.assessmentIdentifiers.put(string, new ArrayList());
    }

    public void addAdaptationProfileId(String string) {
        this.globalIdentifiers.add(string);
        this.adaptationIdentifiers.put(string, new ArrayList());
    }

    public void deleteSceneId(String string) {
        this.globalIdentifiers.remove(string);
        this.generalSceneIdentifiers.remove(string);
        this.sceneIdentifiers.remove(string);
    }

    public void deleteCutsceneId(String string) {
        this.globalIdentifiers.remove(string);
        this.generalSceneIdentifiers.remove(string);
        this.cutsceneIdentifiers.remove(string);
    }

    public void deleteBookId(String string) {
        this.globalIdentifiers.remove(string);
        this.bookIdentifiers.remove(string);
    }

    public void deleteItemId(String string) {
        this.globalIdentifiers.remove(string);
        this.itemIdentifiers.remove(string);
    }

    public void deleteAtrezzoId(String string) {
        this.globalIdentifiers.remove(string);
        this.atrezzoIdentifiers.remove(string);
    }

    public void deleteNPCId(String string) {
        this.globalIdentifiers.remove(string);
        this.npcIdentifiers.remove(string);
    }

    public void deleteConversationId(String string) {
        this.globalIdentifiers.remove(string);
        this.conversationIdentifiers.remove(string);
    }

    public void deleteGlobalStateId(String string) {
        this.globalIdentifiers.remove(string);
        this.globalStateIdentifiers.remove(string);
    }

    public void deleteMacroId(String string) {
        this.globalIdentifiers.remove(string);
        this.macroIdentifiers.remove(string);
    }

    public void deleteAssessmentRuleId(String string, String string2) {
        this.globalIdentifiers.remove(string2 + "." + string);
        this.assessmentIdentifiers.get(string2).remove(string);
    }

    public void deleteAdaptationRuleId(String string, String string2) {
        this.globalIdentifiers.remove(string2 + "." + string);
        this.adaptationIdentifiers.get(string2).remove(string);
    }

    public void deleteAssessmentProfileId(String string) {
        this.globalIdentifiers.remove(string);
        this.assessmentIdentifiers.remove(string);
    }

    public void deleteAdaptationProfileId(String string) {
        this.globalIdentifiers.remove(string);
        this.adaptationIdentifiers.remove(string);
    }

    public void renameAdaptationProfile(String string, String string2) {
        int n;
        List<String> list = this.adaptationIdentifiers.get(string);
        for (n = 0; n < list.size(); ++n) {
            this.deleteAdaptationRuleId(list.get(n), string);
        }
        this.deleteAdaptationProfileId(string);
        this.addAdaptationProfileId(string2);
        for (n = 0; n < list.size(); ++n) {
            this.addAdaptationRuleId(list.get(n), string2);
        }
    }

    public void renameAssessmentProfile(String string, String string2) {
        int n;
        List<String> list = this.assessmentIdentifiers.get(string);
        for (n = 0; n < list.size(); ++n) {
            this.deleteAssessmentRuleId(list.get(n), string);
        }
        this.deleteAssessmentProfileId(string);
        this.addAssessmentProfileId(string2);
        for (n = 0; n < list.size(); ++n) {
            this.addAssessmentRuleId(list.get(n), string2);
        }
    }

    public boolean isAdaptationProfileId(String string) {
        return this.adaptationIdentifiers.keySet().contains(string);
    }

    public boolean isAdaptationRuleId(String string, String string2) {
        return this.adaptationIdentifiers.get(string2).contains(string);
    }

    public boolean isAssessmentProfileId(String string) {
        return this.assessmentIdentifiers.keySet().contains(string);
    }

    public boolean isAssessmentRuleId(String string, String string2) {
        return this.assessmentIdentifiers.get(string2).contains(string);
    }

    public boolean isGlobalStateId(String string) {
        return this.globalStateIdentifiers.contains(string);
    }

    public boolean isMacroId(String string) {
        return this.macroIdentifiers.contains(string);
    }

    public void addActiveAreaId(String string) {
        this.globalIdentifiers.add(string);
        this.activeAreaIdentifiers.add(string);
    }

    public void deleteActiveAreaId(String string) {
        if (this.activeAreaIdentifiers.contains(string)) {
            this.globalIdentifiers.remove(string);
            this.activeAreaIdentifiers.remove(string);
        }
    }

    public String[] getItemAndActiveAreaIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.itemIdentifiers);
        arrayList.addAll(this.activeAreaIdentifiers);
        return arrayList.toArray(new String[0]);
    }

    public String[] getItemActiveAreaNPCIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this.itemIdentifiers);
        arrayList.addAll(this.activeAreaIdentifiers);
        arrayList.addAll(this.npcIdentifiers);
        return arrayList.toArray(new String[0]);
    }
}

