/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.data.meta.lomes;

import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.Vocabulary;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMESGeneralId;
import es.eucm.eadventure.editor.data.meta.auxiliar.LOMIdentifier;
import java.util.ArrayList;

public class LOMESGeneral {
    private LOMIdentifier identifier;
    private LangString title = null;
    private ArrayList<String> language = new ArrayList();
    private ArrayList<LangString> description = new ArrayList();
    private ArrayList<LangString> keyword = new ArrayList();
    private Vocabulary aggregationLevel = new Vocabulary(Vocabulary.GE_AGGREGATION_LEVEL_1_8, "LOM-ESv1.0", 0);

    public LOMESGeneral() {
        this.identifier = new LOMIdentifier(false);
    }

    public void addTitle(LangString langString) {
        this.title = langString;
    }

    public void addLanguage(String string) {
        this.language.add(string);
    }

    public void addDescription(LangString langString) {
        this.description.add(langString);
    }

    public void addKeyword(LangString langString) {
        this.keyword.add(langString);
    }

    public void addIdentifier(String string, String string2) {
        this.identifier.addIdentifier(string, string2);
    }

    public void setTitle(LangString langString) {
        this.title = langString;
    }

    public void setLanguage(String string) {
        this.language = new ArrayList();
        this.language.add(string);
    }

    public void setDescription(LangString langString) {
        this.description = new ArrayList();
        this.description.add(langString);
    }

    public void setKeyword(LangString langString) {
        this.keyword = new ArrayList();
        this.keyword.add(langString);
    }

    public void setAggregationLevel(int n) {
        this.aggregationLevel.setValueIndex(n);
    }

    public LOMESGeneralId getIdentifier(int n) {
        return (LOMESGeneralId)this.identifier.get(n);
    }

    public int getNIdentifier() {
        return this.identifier.getSize();
    }

    public LOMIdentifier getIdentifier() {
        return this.identifier;
    }

    public LangString getTitle() {
        return this.title;
    }

    public String getLanguage() {
        return this.language.get(0);
    }

    public String getLanguage(int n) {
        return this.language.get(n);
    }

    public int getNLanguage() {
        return this.language.size();
    }

    public ArrayList<String> getLanguages() {
        return this.language;
    }

    public LangString getDescription() {
        return this.description.get(0);
    }

    public LangString getDescription(int n) {
        return this.description.get(n);
    }

    public int getNDescription() {
        return this.description.size();
    }

    public ArrayList<LangString> getDescriptions() {
        return this.description;
    }

    public LangString getKeyword() {
        return this.keyword.get(0);
    }

    public LangString getKeyword(int n) {
        return this.keyword.get(n);
    }

    public ArrayList<LangString> getKeywords() {
        return this.keyword;
    }

    public String[] keywordsToString() {
        String[] stringArray = new String[this.keyword.size()];
        for (int i = 0; i < this.keyword.size(); ++i) {
            stringArray[i] = this.keyword.get(i).getValue(0);
        }
        return stringArray;
    }

    public int getNKeyword() {
        return this.keyword.size();
    }

    public void deleteKey(int n) {
    }

    public Vocabulary getAggregationLevel() {
        return this.aggregationLevel;
    }
}

