/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.data.meta.lomes;

import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.Vocabulary;
import java.util.ArrayList;

public class LOMESEducational {
    private Vocabulary interactivityType;
    private ArrayList<Vocabulary> learningResourceType;
    private Vocabulary interactivityLevel;
    private Vocabulary semanticDensity;
    private ArrayList<Vocabulary> intendedEndUserRole;
    private ArrayList<Vocabulary> context;
    private ArrayList<LangString> typicalAgeRange;
    private Vocabulary difficulty;
    private String typicalLearningTime = null;
    private ArrayList<LangString> description;
    private ArrayList<String> language = new ArrayList();
    private ArrayList<Vocabulary> cognitiveProcess;

    public LOMESEducational() {
        this.context = new ArrayList();
        this.intendedEndUserRole = new ArrayList();
        this.learningResourceType = new ArrayList();
        this.cognitiveProcess = new ArrayList();
        this.description = new ArrayList();
        this.typicalAgeRange = new ArrayList();
        this.difficulty = new Vocabulary(Vocabulary.ED_DIFFICULTY_5_8, "LOM-ESv1.0", 0);
        this.interactivityLevel = new Vocabulary(Vocabulary.ED_INTERACTIVITY_LEVEL_5_3, "LOM-ESv1.0", 0);
        this.interactivityType = new Vocabulary(Vocabulary.ED_INTERACTIVITY_TYPE_5_1, "LOM-ESv1.0", 0);
        this.semanticDensity = new Vocabulary(Vocabulary.ED_SEMANTIC_DENSITY_5_4, "LOM-ESv1.0", 0);
    }

    public void addLanguage(String string) {
        this.language.add(string);
    }

    public void addContext(int n) {
        this.context.add(new Vocabulary(Vocabulary.LOMES_ED_CONTEXT_5_6, "LOM-ESv1.0", n));
    }

    public void addIntendedEndUserRole(int n) {
        this.intendedEndUserRole.add(new Vocabulary(Vocabulary.LOMES_ED_INTENDED_END_USER_ROLE_5_5, "LOM-ESv1.0", n));
    }

    public void addLearningResourceType(int n) {
        this.learningResourceType.add(new Vocabulary(Vocabulary.LOMES_ED_LEARNING_RESOURCE_TYPE_5_2, "LOM-ESv1.0", n));
    }

    public void addDescription(LangString langString) {
        this.description.add(langString);
    }

    public void addTypicalAgeRange(LangString langString) {
        this.typicalAgeRange.add(langString);
    }

    public void addCognitiveProcess(int n) {
        this.cognitiveProcess.add(new Vocabulary(Vocabulary.LOMES_ED_COGNITIVE_PROCESS_5_12, "LOM-ESv1.0", n));
    }

    public void setTypicalLearningTime(String string) {
        this.typicalLearningTime = string;
    }

    public void setLanguage(String string) {
        this.language = new ArrayList();
        this.language.add(string);
    }

    public void setContext(int n) {
        this.context = new ArrayList();
        this.context.add(new Vocabulary(Vocabulary.LOMES_ED_CONTEXT_5_6, "LOM-ESv1.0", n));
    }

    public void setIntendedEndUserRole(int n) {
        this.intendedEndUserRole = new ArrayList();
        this.intendedEndUserRole.add(new Vocabulary(Vocabulary.LOMES_ED_INTENDED_END_USER_ROLE_5_5, "LOM-ESv1.0", n));
    }

    public void setSemanticDensity(int n) {
        this.semanticDensity = new Vocabulary(Vocabulary.ED_SEMANTIC_DENSITY_5_4, "LOM-ESv1.0", n);
    }

    public void setDifficulty(int n) {
        this.difficulty = new Vocabulary(Vocabulary.ED_DIFFICULTY_5_8, "LOM-ESv1.0", n);
    }

    public void setInteractivityLevel(int n) {
        this.interactivityLevel = new Vocabulary(Vocabulary.ED_INTERACTIVITY_LEVEL_5_3, "LOM-ESv1.0", n);
    }

    public void setInteractivityType(int n) {
        this.interactivityType = new Vocabulary(Vocabulary.ED_INTERACTIVITY_TYPE_5_1, "LOM-ESv1.0", n);
    }

    public void setCognitiveProcess(int n) {
        this.cognitiveProcess = new ArrayList();
        this.cognitiveProcess.add(new Vocabulary(Vocabulary.LOMES_ED_COGNITIVE_PROCESS_5_12, "LOM-ESv1.0", n));
    }

    public void setLearningResourceType(int n) {
        this.learningResourceType = new ArrayList();
        this.learningResourceType.add(new Vocabulary(Vocabulary.LOMES_ED_LEARNING_RESOURCE_TYPE_5_2, "LOM-ESv1.0", n));
    }

    public void setDescription(LangString langString) {
        this.description = new ArrayList();
        this.description.add(langString);
    }

    public void setTypicalAgeRange(LangString langString) {
        this.typicalAgeRange = new ArrayList();
        this.typicalAgeRange.add(langString);
    }

    public String getTypicalLearningTime() {
        return this.typicalLearningTime;
    }

    public String getLanguage() {
        return this.language.get(0);
    }

    public ArrayList<Vocabulary> getContext() {
        return this.context;
    }

    public ArrayList<Vocabulary> getIntendedEndUserRole() {
        return this.intendedEndUserRole;
    }

    public ArrayList<Vocabulary> getLearningResourceType() {
        return this.learningResourceType;
    }

    public ArrayList<Vocabulary> getCognitiveProcess() {
        return this.cognitiveProcess;
    }

    public ArrayList<LangString> getDescription() {
        return this.description;
    }

    public ArrayList<LangString> getTypicalAgeRange() {
        return this.typicalAgeRange;
    }

    public Vocabulary getDifficulty() {
        return this.difficulty;
    }

    public Vocabulary getInteractivityLevel() {
        return this.interactivityLevel;
    }

    public Vocabulary getInteractivityType() {
        return this.interactivityType;
    }

    public Vocabulary getSemanticDensity() {
        return this.semanticDensity;
    }
}

