/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters.lomes;

import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.Vocabulary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LOMESSimpleDataWriter {
    public static Node buildVocabularyNode(Document document, String string, Vocabulary vocabulary) {
        Element element = null;
        element = document.createElement(string);
        int n = string.indexOf(":");
        element.setAttribute("vocElement", string.substring(n + 1, string.length()));
        Element element2 = document.createElement("lomes:source");
        element2.setAttribute("vocElement", "source");
        element2.setTextContent(vocabulary.getSource());
        element.appendChild(element2);
        Element element3 = document.createElement("lomes:value");
        element3.setAttribute("vocElement", "value");
        element3.setTextContent(vocabulary.getValue());
        element.appendChild(element3);
        return element;
    }

    public static Node buildLangStringNode(Document document, LangString langString) {
        Element element = null;
        String string = new String("x-none");
        String string2 = new String("");
        element = document.createElement("lomes:string");
        if (langString != null) {
            if (langString.getLanguage(0) != null && !(string = langString.getLanguage(0)).equals("") && !string.equals("XXlan")) {
                element.setAttribute("language", string);
            }
            if (langString.getValue(0) != null) {
                string2 = langString.getValue(0);
            }
        }
        element.setTextContent(string2);
        return element;
    }

    public static Node buildLangWithoutAttrStringNode(Document document, LangString langString) {
        Element element = null;
        element = document.createElement("lomes:string");
        element.setTextContent(langString.getValue(0));
        return element;
    }

    public static Node buildStringNode(Document document, String string) {
        return LOMESSimpleDataWriter.buildLangStringNode(document, new LangString("x-none", string));
    }

    public static boolean isStringSet(String string) {
        return string != null && !string.equals("");
    }

    public static boolean isStringSet(LangString langString) {
        return langString != null && langString.getLanguage(0) != null && !langString.getLanguage(0).equals("") && langString.getValue(0) != null && !langString.getValue(0).equals("");
    }
}

