/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters.lom;

import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.Vocabulary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LOMSimpleDataWriter {
    public static Node buildVocabularyNode(Document document, String string, Vocabulary vocabulary, boolean bl) {
        Element element = null;
        element = document.createElement("imsmd:" + string);
        Element element2 = document.createElement("imsmd:source");
        element2.appendChild(LOMSimpleDataWriter.buildStringNode(document, vocabulary.getSource(), bl));
        element.appendChild(element2);
        Element element3 = document.createElement("imsmd:value");
        element3.appendChild(LOMSimpleDataWriter.buildStringNode(document, vocabulary.getValue(), bl));
        element.appendChild(element3);
        return element;
    }

    public static Node buildLangStringNode(Document document, LangString langString, boolean bl) {
        Element element = null;
        element = document.createElement(bl ? "imsmd:string" : "imsmd:langstring");
        element.setAttribute(bl ? "language" : "xml:lang", langString.getLanguage(0));
        element.setTextContent(langString.getValue(0));
        return element;
    }

    public static Node buildStringNode(Document document, String string, boolean bl) {
        return LOMSimpleDataWriter.buildLangStringNode(document, new LangString("x-none", string), bl);
    }

    public static boolean isStringSet(String string) {
        return string != null && !string.equals("");
    }

    public static boolean isStringSet(LangString langString) {
        return langString != null && langString.getLanguage(0) != null && !langString.getLanguage(0).equals("") && langString.getValue(0) != null && !langString.getValue(0).equals("");
    }
}

