/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters.lom;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.editor.control.controllers.metadata.lom.LOMDataControl;
import es.eucm.eadventure.editor.control.writer.domwriters.lom.LOMEducationalDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.lom.LOMGeneralDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.lom.LOMLifeCycleDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.lom.LOMTechnicalDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LOMDOMWriter {
    public static Node buildManifestDOM(LOMDataControl lOMDataControl) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("manifest");
            element.setAttribute("identifier", "imsaccmdv1p0_manifest");
            element.setAttribute("xmlns", "http://www.imsglobal.org/xsd/imscp_v1p1");
            element.setAttribute("xmlns:imsmd", "http://www.imsglobal.org/xsd/imsmd_v1p2");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.imsglobal.org/xsd/imscp_v1p1 imscp_v1p1.xsd http://www.imsglobal.org/xsd/imsmd_v1p2 imsmd_v1p2p4.xsd");
            element.setAttribute("version", "IMS CP 1.1.3");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }

    public static Node buildLOMDOM(LOMDataControl lOMDataControl, boolean bl) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("imsmd:lom");
            Node node = LOMGeneralDOMWriter.buildDOM(lOMDataControl.getGeneral().getData(), bl);
            document.adoptNode(node);
            element.appendChild(node);
            Node node2 = LOMLifeCycleDOMWriter.buildDOM(lOMDataControl.getLifeCycle().getData(), bl);
            document.adoptNode(node2);
            element.appendChild(node2);
            Node node3 = LOMTechnicalDOMWriter.buildDOM(lOMDataControl.getTechnical().getData(), bl);
            document.adoptNode(node3);
            element.appendChild(node3);
            Node node4 = LOMEducationalDOMWriter.buildDOM(lOMDataControl.getEducational().getData(), bl);
            document.adoptNode(node4);
            element.appendChild(node4);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

