/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters.ims;

import es.eucm.eadventure.editor.data.meta.LangString;
import es.eucm.eadventure.editor.data.meta.Vocabulary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IMSSimpleDataWriter {
    public static Node buildVocabularyNode(Document document, String string, Vocabulary vocabulary) {
        Element element = null;
        element = document.createElement(string);
        Element element2 = document.createElement("source");
        element2.appendChild(IMSSimpleDataWriter.buildStringNode(document, vocabulary.getSource()));
        element.appendChild(element2);
        Element element3 = document.createElement("value");
        element3.appendChild(IMSSimpleDataWriter.buildStringNode(document, vocabulary.getValue()));
        element.appendChild(element3);
        return element;
    }

    public static Node buildLangStringNode(Document document, LangString langString) {
        Element element = null;
        String string = new String("x-none");
        String string2 = new String("");
        element = document.createElement("langstring");
        if (langString != null) {
            if (langString.getLanguage(0) != null) {
                string = langString.getLanguage(0);
            }
            if (langString.getValue(0) != null) {
                string2 = langString.getValue(0);
            }
        }
        element.setAttribute("xml:lang", string);
        element.setTextContent(string2);
        return element;
    }

    public static Node buildLangWithoutAttrStringNode(Document document, LangString langString) {
        Element element = null;
        element = document.createElement("langstring");
        element.setTextContent(langString.getValue(0));
        return element;
    }

    public static Node buildStringNode(Document document, String string) {
        return IMSSimpleDataWriter.buildLangStringNode(document, new LangString("x-none", string));
    }

    public static boolean isStringSet(String string) {
        return string != null && !string.equals("");
    }

    public static boolean isStringSet(LangString langString) {
        return langString != null && langString.getLanguage(0) != null && !langString.getLanguage(0).equals("") && langString.getValue(0) != null && !langString.getValue(0).equals("");
    }
}

