/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Trajectory;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TrajectoryDOMWriter {
    private TrajectoryDOMWriter() {
    }

    public static Node buildDOM(Trajectory trajectory) {
        Element element = null;
        try {
            Element element2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("trajectory");
            for (Trajectory.Node node : trajectory.getNodes()) {
                element2 = document.createElement("node");
                element2.setAttribute("id", node.getID());
                element2.setAttribute("x", String.valueOf(node.getX()));
                element2.setAttribute("y", String.valueOf(node.getY()));
                element2.setAttribute("scale", String.valueOf(node.getScale()));
                element.appendChild(element2);
            }
            if (trajectory.getInitial() != null) {
                Iterator iterator = document.createElement("initialnode");
                iterator.setAttribute("id", trajectory.getInitial().getID());
                element.appendChild((Node)((Object)iterator));
            }
            for (Trajectory.Node node : trajectory.getSides()) {
                element2 = document.createElement("side");
                element2.setAttribute("idStart", node.getIDStart());
                element2.setAttribute("idEnd", node.getIDEnd());
                element2.setAttribute("length", String.valueOf((int)node.getLength()));
                element.appendChild(element2);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

