/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.EffectsDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimerDOMWriter {
    private TimerDOMWriter() {
    }

    public static Node buildDOM(Timer timer) {
        Element element = null;
        try {
            Node node;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("timer");
            element.setAttribute("time", Long.toString(timer.getTime()));
            element.setAttribute("usesEndCondition", timer.isUsesEndCondition() != false ? "yes" : "no");
            element.setAttribute("multipleStarts", timer.isMultipleStarts() != false ? "yes" : "no");
            element.setAttribute("runsInLoop", timer.isRunsInLoop() != false ? "yes" : "no");
            element.setAttribute("showTime", timer.isShowTime() != false ? "yes" : "no");
            element.setAttribute("displayName", timer.getDisplayName());
            element.setAttribute("countDown", timer.isCountDown() != false ? "yes" : "no");
            element.setAttribute("showWhenStopped", timer.isShowWhenStopped() != false ? "yes" : "no");
            if (timer.getDocumentation() != null) {
                node = document.createElement("documentation");
                node.appendChild(document.createTextNode(timer.getDocumentation()));
                element.appendChild(node);
            }
            if (!timer.getInitCond().isEmpty()) {
                node = ConditionsDOMWriter.buildDOM(1, timer.getInitCond());
                document.adoptNode(node);
                element.appendChild(node);
            }
            if (!timer.getEndCond().isEmpty()) {
                node = ConditionsDOMWriter.buildDOM(2, timer.getEndCond());
                document.adoptNode(node);
                element.appendChild(node);
            }
            if (!timer.getEffects().isEmpty()) {
                node = EffectsDOMWriter.buildDOM("effect", timer.getEffects());
                document.adoptNode(node);
                element.appendChild(node);
            }
            if (!timer.getPostEffects().isEmpty()) {
                node = EffectsDOMWriter.buildDOM("post-effect", timer.getPostEffects());
                document.adoptNode(node);
                element.appendChild(node);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

