/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourcesDOMWriter {
    public static final int RESOURCES_NONE = 0;
    public static final int RESOURCES_ITEM = 1;
    public static final int RESOURCES_SCENE = 2;
    public static final int RESOURCES_CUTSCENE = 3;
    public static final int RESOURCES_CHARACTER = 4;
    public static final int RESOURCES_ANIMATION = 5;
    public static final int RESOURCES_CUSTOM_ACTION = 6;
    public static final int RESOURCES_BOOK = 7;

    private ResourcesDOMWriter() {
    }

    public static Node buildDOM(Resources resources) {
        return ResourcesDOMWriter.buildDOM(resources, 0);
    }

    public static Node buildDOM(Resources resources, int n) {
        Element element = null;
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("resources");
            element.setAttribute("name", resources.getName());
            if (!resources.getConditions().isEmpty()) {
                object = ConditionsDOMWriter.buildDOM(resources.getConditions());
                document.adoptNode((Node)object);
                element.appendChild((Node)object);
            }
            object = resources.getAssetTypes();
            String[] stringArray = resources.getAssetValues();
            for (int i = 0; i < resources.getAssetCount(); ++i) {
                String[] stringArray2 = document.createElement("asset");
                stringArray2.setAttribute("type", object[i]);
                stringArray2.setAttribute("uri", stringArray[i]);
                element.appendChild((Node)stringArray2);
            }
            if (n == 1) {
                if (resources.getAssetPath("image") == null) {
                    Element element2 = document.createElement("asset");
                    element2.setAttribute("type", "image");
                    element2.setAttribute("uri", "assets/special/EmptyImage.png");
                    element.appendChild(element2);
                }
                if (resources.getAssetPath("icon") == null) {
                    Element element3 = document.createElement("asset");
                    element3.setAttribute("type", "icon");
                    element3.setAttribute("uri", "assets/special/EmptyIcon.png");
                    element.appendChild(element3);
                }
            }
            if (n == 2 && resources.getAssetPath("background") == null) {
                Element element4 = document.createElement("asset");
                element4.setAttribute("type", "background");
                element4.setAttribute("uri", "assets/special/EmptyBackground.png");
                element.appendChild(element4);
            }
            if (n == 3) {
                if (resources.getAssetPath("slides") == null) {
                    Element element5 = document.createElement("asset");
                    element5.setAttribute("type", "slides");
                    element5.setAttribute("uri", "assets/special/EmptyAnimation");
                    element.appendChild(element5);
                }
            } else if (n == 4) {
                String[] stringArray3 = new String[]{"standup", "standdown", "standright", "standleft", "speakup", "speakdown", "speakright", "speakleft", "useright", "useleft", "walkup", "walkdown", "walkright", "walkleft"};
                for (String string : stringArray3) {
                    if (resources.getAssetPath(string) != null) continue;
                    Element element6 = document.createElement("asset");
                    element6.setAttribute("type", string);
                    element6.setAttribute("uri", "assets/special/EmptyAnimation");
                    element.appendChild(element6);
                }
            } else if (n == 6) {
                String[] stringArray4 = new String[]{"buttonNormal", "buttonOver", "buttonPressed"};
                for (String string : stringArray4) {
                    if (resources.getAssetPath(string) != null) continue;
                    Element element7 = document.createElement("asset");
                    element7.setAttribute("type", string);
                    element7.setAttribute("uri", "assets/special/EmptyIcon.png");
                    element.appendChild(element7);
                }
            } else if (n == 7) {
                String[] stringArray5;
                for (String string : stringArray5 = new String[]{"background"}) {
                    if (resources.getAssetPath(string) != null) continue;
                    Element element8 = document.createElement("asset");
                    element8.setAttribute("type", string);
                    element8.setAttribute("uri", "assets/special/EmptyBackground.png");
                    element.appendChild(element8);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

