/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.UOLProperty;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.editor.control.Controller;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExpectedGameIODOMWriter {
    private static final String STRING = "string";
    private static final String BOOLEAN = "boolean";
    private static final String INTEGER = "integer";

    public static String getType(String string, boolean bl) {
        if (bl) {
            if (Controller.getInstance().getVarFlagSummary().existsVar(string)) {
                return INTEGER;
            }
            return BOOLEAN;
        }
        try {
            Integer.parseInt(string);
            return INTEGER;
        }
        catch (NumberFormatException numberFormatException) {
            if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false"))) {
                return BOOLEAN;
            }
            return STRING;
        }
    }

    private static boolean defaultVar(String string) {
        if (string.equals("game-completed")) {
            return true;
        }
        if (string.equals("score")) {
            return true;
        }
        if (string.equals("total-time")) {
            return true;
        }
        return string.equals("real-time");
    }

    public static Element buildExpectedInputs(Document document, List<AdaptationRule> list, List<AssessmentRule> list2) {
        Element element;
        Element element2 = null;
        element2 = document.createElement("io-parameter-list");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (AdaptationRule adaptationRule : list) {
            for (UOLProperty uOLProperty : adaptationRule.getUOLProperties()) {
                if (hashSet.contains(uOLProperty.getId())) continue;
                hashSet.add(uOLProperty.getId());
                element = document.createElement("i-parameter");
                element.setAttribute("name", uOLProperty.getId());
                element.setAttribute("type", ExpectedGameIODOMWriter.getType(uOLProperty.getValue(), false));
                element2.appendChild(element);
            }
        }
        for (AssessmentRule assessmentRule : list2) {
            for (UOLProperty uOLProperty : assessmentRule.getAssessmentProperties()) {
                if (hashSet2.contains(uOLProperty.getId()) || ExpectedGameIODOMWriter.defaultVar(uOLProperty.getId())) continue;
                hashSet2.add(uOLProperty.getId());
                element = document.createElement("o-parameter");
                element.setAttribute("name", uOLProperty.getId());
                element.setAttribute("type", ExpectedGameIODOMWriter.getType(uOLProperty.getVarName() != null ? uOLProperty.getVarName() : uOLProperty.getValue(), uOLProperty.getVarName() != null));
                element2.appendChild(element);
            }
        }
        return element2;
    }
}

