/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.effects.AbstractEffect;
import es.eucm.eadventure.common.data.chapter.effects.ActivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.ConsumeObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.DeactivateEffect;
import es.eucm.eadventure.common.data.chapter.effects.DecrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.Effects;
import es.eucm.eadventure.common.data.chapter.effects.GenerateObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.HighlightItemEffect;
import es.eucm.eadventure.common.data.chapter.effects.IncrementVarEffect;
import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.common.data.chapter.effects.MacroReferenceEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveNPCEffect;
import es.eucm.eadventure.common.data.chapter.effects.MoveObjectEffect;
import es.eucm.eadventure.common.data.chapter.effects.MovePlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlayAnimationEffect;
import es.eucm.eadventure.common.data.chapter.effects.PlaySoundEffect;
import es.eucm.eadventure.common.data.chapter.effects.RandomEffect;
import es.eucm.eadventure.common.data.chapter.effects.SetValueEffect;
import es.eucm.eadventure.common.data.chapter.effects.ShowTextEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakCharEffect;
import es.eucm.eadventure.common.data.chapter.effects.SpeakPlayerEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerBookEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerConversationEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerCutsceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.TriggerSceneEffect;
import es.eucm.eadventure.common.data.chapter.effects.WaitTimeEffect;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EffectsDOMWriter {
    public static final String EFFECTS = "effect";
    public static final String POST_EFFECTS = "post-effect";
    public static final String NOT_EFFECTS = "not-effect";
    public static final String MACRO = "macro";

    private EffectsDOMWriter() {
    }

    public static Node buildDOM(String string, Effects effects) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement(string);
            EffectsDOMWriter.appendEffects(document, element, effects);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }

    public static Element buildDOM(Macro macro) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement(MACRO);
            element.setAttribute("id", macro.getId());
            Element element2 = document.createElement("documentation");
            element2.appendChild(document.createTextNode(macro.getDocumentation()));
            element.appendChild(element2);
            EffectsDOMWriter.appendEffects(document, element, (Effects)macro);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }

    public static void appendEffects(Document document, Node node, Effects effects) {
        for (AbstractEffect abstractEffect : effects.getEffects()) {
            Element element = null;
            Node node2 = null;
            if (abstractEffect.getType() != 16) {
                element = EffectsDOMWriter.buildEffectNode(abstractEffect, document);
            } else {
                RandomEffect randomEffect = (RandomEffect)abstractEffect;
                element = document.createElement("random-effect");
                element.setAttribute("probability", Integer.toString(randomEffect.getProbability()));
                Element element2 = null;
                Element element3 = null;
                if (randomEffect.getPositiveEffect() != null) {
                    element2 = EffectsDOMWriter.buildEffectNode(randomEffect.getPositiveEffect(), document);
                    element.appendChild(element2);
                    if (randomEffect.getNegativeEffect() != null) {
                        element3 = EffectsDOMWriter.buildEffectNode(randomEffect.getNegativeEffect(), document);
                        element.appendChild(element3);
                    }
                }
            }
            node2 = ConditionsDOMWriter.buildDOM(abstractEffect.getConditions());
            document.adoptNode(node2);
            node.appendChild(element);
            node.appendChild(node2);
        }
    }

    private static Element buildEffectNode(AbstractEffect abstractEffect, Document document) {
        Element element = null;
        block0 : switch (abstractEffect.getType()) {
            case 0: {
                ActivateEffect activateEffect = (ActivateEffect)abstractEffect;
                element = document.createElement("activate");
                element.setAttribute("flag", activateEffect.getTargetId());
                break;
            }
            case 1: {
                DeactivateEffect deactivateEffect = (DeactivateEffect)abstractEffect;
                element = document.createElement("deactivate");
                element.setAttribute("flag", deactivateEffect.getTargetId());
                break;
            }
            case 17: {
                SetValueEffect setValueEffect = (SetValueEffect)abstractEffect;
                element = document.createElement("set-value");
                element.setAttribute("var", setValueEffect.getTargetId());
                element.setAttribute("value", Integer.toString(setValueEffect.getValue()));
                break;
            }
            case 18: {
                IncrementVarEffect incrementVarEffect = (IncrementVarEffect)abstractEffect;
                element = document.createElement("increment");
                element.setAttribute("var", incrementVarEffect.getTargetId());
                element.setAttribute("value", Integer.toString(incrementVarEffect.getIncrement()));
                break;
            }
            case 19: {
                DecrementVarEffect decrementVarEffect = (DecrementVarEffect)abstractEffect;
                element = document.createElement("decrement");
                element.setAttribute("var", decrementVarEffect.getTargetId());
                element.setAttribute("value", Integer.toString(decrementVarEffect.getDecrement()));
                break;
            }
            case 20: {
                MacroReferenceEffect macroReferenceEffect = (MacroReferenceEffect)abstractEffect;
                element = document.createElement("macro-ref");
                element.setAttribute("id", macroReferenceEffect.getTargetId());
                break;
            }
            case 2: {
                ConsumeObjectEffect consumeObjectEffect = (ConsumeObjectEffect)abstractEffect;
                element = document.createElement("consume-object");
                element.setAttribute("idTarget", consumeObjectEffect.getTargetId());
                break;
            }
            case 3: {
                GenerateObjectEffect generateObjectEffect = (GenerateObjectEffect)abstractEffect;
                element = document.createElement("generate-object");
                element.setAttribute("idTarget", generateObjectEffect.getTargetId());
                break;
            }
            case 4: {
                element = document.createElement("cancel-action");
                break;
            }
            case 5: {
                SpeakPlayerEffect speakPlayerEffect = (SpeakPlayerEffect)abstractEffect;
                element = document.createElement("speak-player");
                element.appendChild(document.createTextNode(speakPlayerEffect.getLine()));
                break;
            }
            case 6: {
                SpeakCharEffect speakCharEffect = (SpeakCharEffect)abstractEffect;
                element = document.createElement("speak-char");
                element.setAttribute("idTarget", speakCharEffect.getTargetId());
                element.appendChild(document.createTextNode(speakCharEffect.getLine()));
                break;
            }
            case 7: {
                TriggerBookEffect triggerBookEffect = (TriggerBookEffect)abstractEffect;
                element = document.createElement("trigger-book");
                element.setAttribute("idTarget", triggerBookEffect.getTargetId());
                break;
            }
            case 8: {
                PlaySoundEffect playSoundEffect = (PlaySoundEffect)abstractEffect;
                element = document.createElement("play-sound");
                if (!playSoundEffect.isBackground()) {
                    element.setAttribute("background", "no");
                }
                element.setAttribute("uri", playSoundEffect.getPath());
                break;
            }
            case 9: {
                PlayAnimationEffect playAnimationEffect = (PlayAnimationEffect)abstractEffect;
                element = document.createElement("play-animation");
                element.setAttribute("uri", playAnimationEffect.getPath());
                element.setAttribute("x", String.valueOf(playAnimationEffect.getX()));
                element.setAttribute("y", String.valueOf(playAnimationEffect.getY()));
                break;
            }
            case 10: {
                MovePlayerEffect movePlayerEffect = (MovePlayerEffect)abstractEffect;
                element = document.createElement("move-player");
                element.setAttribute("x", String.valueOf(movePlayerEffect.getX()));
                element.setAttribute("y", String.valueOf(movePlayerEffect.getY()));
                break;
            }
            case 11: {
                MoveNPCEffect moveNPCEffect = (MoveNPCEffect)abstractEffect;
                element = document.createElement("move-npc");
                element.setAttribute("idTarget", moveNPCEffect.getTargetId());
                element.setAttribute("x", String.valueOf(moveNPCEffect.getX()));
                element.setAttribute("y", String.valueOf(moveNPCEffect.getY()));
                break;
            }
            case 12: {
                TriggerConversationEffect triggerConversationEffect = (TriggerConversationEffect)abstractEffect;
                element = document.createElement("trigger-conversation");
                element.setAttribute("idTarget", triggerConversationEffect.getTargetId());
                break;
            }
            case 13: {
                TriggerCutsceneEffect triggerCutsceneEffect = (TriggerCutsceneEffect)abstractEffect;
                element = document.createElement("trigger-cutscene");
                element.setAttribute("idTarget", triggerCutsceneEffect.getTargetId());
                break;
            }
            case 15: {
                element = document.createElement("trigger-last-scene");
                break;
            }
            case 14: {
                TriggerSceneEffect triggerSceneEffect = (TriggerSceneEffect)abstractEffect;
                element = document.createElement("trigger-scene");
                element.setAttribute("idTarget", triggerSceneEffect.getTargetId());
                element.setAttribute("x", String.valueOf(triggerSceneEffect.getX()));
                element.setAttribute("y", String.valueOf(triggerSceneEffect.getY()));
                break;
            }
            case 21: {
                WaitTimeEffect waitTimeEffect = (WaitTimeEffect)abstractEffect;
                element = document.createElement("wait-time");
                element.setAttribute("time", Integer.toString(waitTimeEffect.getTime()));
                break;
            }
            case 22: {
                ShowTextEffect showTextEffect = (ShowTextEffect)abstractEffect;
                element = document.createElement("show-text");
                element.setAttribute("x", String.valueOf(showTextEffect.getX()));
                element.setAttribute("y", String.valueOf(showTextEffect.getY()));
                element.setAttribute("frontColor", String.valueOf(showTextEffect.getRgbFrontColor()));
                element.setAttribute("borderColor", String.valueOf(showTextEffect.getRgbBorderColor()));
                element.appendChild(document.createTextNode(showTextEffect.getText()));
                break;
            }
            case 24: {
                MoveObjectEffect moveObjectEffect = (MoveObjectEffect)abstractEffect;
                element = document.createElement("move-object");
                element.setAttribute("idTarget", moveObjectEffect.getTargetId());
                element.setAttribute("x", String.valueOf(moveObjectEffect.getX()));
                element.setAttribute("y", String.valueOf(moveObjectEffect.getY()));
                element.setAttribute("scale", String.valueOf(moveObjectEffect.getScale()));
                element.setAttribute("animated", moveObjectEffect.isAnimated() ? "yes" : "no");
                element.setAttribute("translateSpeed", String.valueOf(moveObjectEffect.getTranslateSpeed()));
                element.setAttribute("scaleSpeed", String.valueOf(moveObjectEffect.getScaleSpeed()));
                break;
            }
            case 23: {
                HighlightItemEffect highlightItemEffect = (HighlightItemEffect)abstractEffect;
                element = document.createElement("highlight-item");
                element.setAttribute("idTarget", highlightItemEffect.getTargetId());
                element.setAttribute("animated", highlightItemEffect.isHighlightAnimated() ? "yes" : "no");
                switch (highlightItemEffect.getHighlightType()) {
                    case 1: {
                        element.setAttribute("type", "blue");
                        break block0;
                    }
                    case 4: {
                        element.setAttribute("type", "border");
                        break block0;
                    }
                    case 2: {
                        element.setAttribute("type", "red");
                        break block0;
                    }
                    case 3: {
                        element.setAttribute("type", "green");
                        break block0;
                    }
                    case 0: {
                        element.setAttribute("type", "none");
                    }
                }
            }
        }
        return element;
    }
}

