/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adventure.CustomArrow;
import es.eucm.eadventure.common.data.adventure.CustomButton;
import es.eucm.eadventure.common.data.adventure.CustomCursor;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DescriptorDOMWriter {
    private DescriptorDOMWriter() {
    }

    public static Node buildDOM(AdventureDataControl adventureDataControl, boolean bl) {
        Element element = null;
        try {
            Element element2;
            Element element3;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("game-descriptor");
            element.setAttribute("versionNumber", adventureDataControl.getAdventureData().getVersionNumber());
            Element element4 = document.createElement("title");
            element4.appendChild(document.createTextNode(adventureDataControl.getTitle()));
            element.appendChild(element4);
            Element element5 = document.createElement("description");
            element5.appendChild(document.createTextNode(adventureDataControl.getDescription()));
            element.appendChild(element5);
            if (!bl) {
                element.appendChild(document.createElement("invalid"));
            }
            if (adventureDataControl.isCommentaries()) {
                element.appendChild(document.createElement("automatic-commentaries"));
            }
            Element element6 = document.createElement("configuration");
            if (adventureDataControl.isKeepShowing()) {
                element6.setAttribute("keepShowing", "yes");
            } else {
                element6.setAttribute("keepShowing", "no");
            }
            switch (adventureDataControl.getDefaultClickAction()) {
                case SHOW_DETAILS: {
                    element6.setAttribute("defaultClickAction", "showDetails");
                    break;
                }
                case SHOW_ACTIONS: {
                    element6.setAttribute("defaultClickAction", "showActions");
                }
            }
            switch (adventureDataControl.getPerspective()) {
                case REGULAR: {
                    element6.setAttribute("perspective", "regular");
                    break;
                }
                case ISOMETRIC: {
                    element6.setAttribute("perspective", "isometric");
                }
            }
            Element element7 = document.createElement("gui");
            if (adventureDataControl.getGUIType() == 0) {
                element7.setAttribute("type", "traditional");
            } else if (adventureDataControl.getGUIType() == 1) {
                element7.setAttribute("type", "contextual");
            }
            switch (adventureDataControl.getInventoryPosition()) {
                case 0: {
                    element7.setAttribute("inventoryPosition", "none");
                    break;
                }
                case 1: {
                    element7.setAttribute("inventoryPosition", "top_bottom");
                    break;
                }
                case 2: {
                    element7.setAttribute("inventoryPosition", "top");
                    break;
                }
                case 3: {
                    element7.setAttribute("inventoryPosition", "bottom");
                }
            }
            if (adventureDataControl.getCursors().size() > 0) {
                element3 = document.createElement("cursors");
                for (CustomCursor object2 : adventureDataControl.getCursors()) {
                    element2 = document.createElement("cursor");
                    element2.setAttribute("type", object2.getType());
                    element2.setAttribute("uri", object2.getPath());
                    element3.appendChild(element2);
                }
                element7.appendChild(element3);
            }
            if (adventureDataControl.getButtons().size() > 0) {
                element3 = document.createElement("buttons");
                for (CustomButton customButton : adventureDataControl.getButtons()) {
                    element2 = document.createElement("button");
                    element2.setAttribute("action", customButton.getAction());
                    element2.setAttribute("type", customButton.getType());
                    element2.setAttribute("uri", customButton.getPath());
                    element3.appendChild(element2);
                }
                element7.appendChild(element3);
            }
            if (adventureDataControl.getArrows().size() > 0) {
                element3 = document.createElement("arrows");
                for (CustomArrow customArrow : adventureDataControl.getArrows()) {
                    element2 = document.createElement("arrow");
                    element2.setAttribute("type", customArrow.getType());
                    element2.setAttribute("uri", customArrow.getPath());
                    element3.appendChild(element2);
                }
                element7.appendChild(element3);
            }
            element6.appendChild(element7);
            element3 = document.createElement("mode");
            if (adventureDataControl.getPlayerMode() == 0) {
                element3.setAttribute("playerTransparent", "yes");
            } else if (adventureDataControl.getPlayerMode() == 1) {
                element3.setAttribute("playerTransparent", "no");
            }
            element6.appendChild(element3);
            Element element8 = document.createElement("graphics");
            if (adventureDataControl.getGraphicConfig() == 0) {
                element8.setAttribute("mode", "windowed");
            } else if (adventureDataControl.getGraphicConfig() == 2) {
                element8.setAttribute("mode", "fullscreen");
            } else if (adventureDataControl.getGraphicConfig() == 1) {
                element8.setAttribute("mode", "blackbkg");
            }
            element6.appendChild(element8);
            element.appendChild(element6);
            Element element9 = document.createElement("contents");
            int n = 1;
            for (Chapter chapter : adventureDataControl.getChapters()) {
                Element element10 = document.createElement("chapter");
                element10.setAttribute("path", "chapter" + n++ + ".xml");
                Element element11 = document.createElement("title");
                element11.appendChild(document.createTextNode(chapter.getTitle()));
                element10.appendChild(element11);
                Element element12 = document.createElement("description");
                element12.appendChild(document.createTextNode(chapter.getDescription()));
                element10.appendChild(element12);
                element9.appendChild(element10);
            }
            element.appendChild(element9);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

