/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.common.data.chapter.scenes.Cutscene;
import es.eucm.eadventure.editor.control.writer.domwriters.EffectsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ResourcesDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CutsceneDOMWriter {
    private CutsceneDOMWriter() {
    }

    public static Node buildDOM(Cutscene cutscene, boolean bl) {
        Element element = null;
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            if (cutscene.getType() == 1) {
                element = document.createElement("slidescene");
            } else if (cutscene.getType() == 2) {
                element = document.createElement("videoscene");
            }
            element.setAttribute("id", cutscene.getId());
            if (bl) {
                element.setAttribute("start", "yes");
            } else {
                element.setAttribute("start", "no");
            }
            if (cutscene.getNext() == 2) {
                element.setAttribute("idTarget", cutscene.getTargetId());
                element.setAttribute("destinyX", String.valueOf(cutscene.getPositionX()));
                element.setAttribute("destinyY", String.valueOf(cutscene.getPositionY()));
                element.setAttribute("transitionTime", String.valueOf(cutscene.getTransitionTime()));
                element.setAttribute("transitionType", String.valueOf(cutscene.getTransitionType()));
            }
            if (cutscene.getNext() == 0) {
                element.setAttribute("next", "go-back");
            } else if (cutscene.getNext() == 1) {
                element.setAttribute("next", "end-chapter");
            } else if (cutscene.getNext() == 2) {
                element.setAttribute("next", "new-scene");
            }
            if (cutscene.getDocumentation() != null) {
                object = document.createElement("documentation");
                object.appendChild(document.createTextNode(cutscene.getDocumentation()));
                element.appendChild((Node)object);
            }
            if (!cutscene.getEffects().isEmpty()) {
                object = EffectsDOMWriter.buildDOM("effect", cutscene.getEffects());
                document.adoptNode((Node)object);
                element.appendChild((Node)object);
            }
            for (Resources resources : cutscene.getResources()) {
                Node node = ResourcesDOMWriter.buildDOM(resources, 3);
                document.adoptNode(node);
                element.appendChild(node);
            }
            object = document.createElement("name");
            object.appendChild(document.createTextNode(cutscene.getName()));
            element.appendChild((Node)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

