/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.conversation.GraphConversation;
import es.eucm.eadventure.common.data.chapter.conversation.TreeConversation;
import es.eucm.eadventure.common.data.chapter.conversation.line.ConversationLine;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.data.chapter.conversation.node.DialogueConversationNode;
import es.eucm.eadventure.common.data.chapter.conversation.node.OptionConversationNode;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.EffectsDOMWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConversationDOMWriter {
    private ConversationDOMWriter() {
    }

    public static Node buildDOM(Conversation conversation) {
        Node node = null;
        if (conversation.getType() == 0) {
            node = ConversationDOMWriter.buildTreeConversationDOM((TreeConversation)conversation);
        } else if (conversation.getType() == 1) {
            node = ConversationDOMWriter.buildGraphConversationDOM((GraphConversation)conversation);
        }
        return node;
    }

    protected static Node buildTreeConversationDOM(TreeConversation treeConversation) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("tree-conversation");
            element.setAttribute("id", treeConversation.getId());
            ConversationDOMWriter.writeNodeInDOM(treeConversation.getRootNode(), element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }

    private static void writeNodeInDOM(ConversationNode conversationNode, Node node) {
        Document document = node.getOwnerDocument();
        if (conversationNode.getType() == 0) {
            Node node2;
            for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                Node node3 = null;
                ConversationLine conversationLine = conversationNode.getLine(i);
                if (conversationLine.isPlayerLine()) {
                    node2 = document.createElement("speak-player");
                } else {
                    node2 = document.createElement("speak-char");
                    if (!conversationLine.getName().equals("NPC")) {
                        node2.setAttribute("idTarget", conversationLine.getName());
                    }
                }
                node2.setTextContent(conversationLine.getText());
                if (conversationLine.isValidAudio()) {
                    node2.setAttribute("uri", conversationLine.getAudioPath());
                }
                if (conversationLine.getSynthesizerVoice().booleanValue()) {
                    node2.setAttribute("synthesize", "yes");
                }
                node.appendChild(node2);
                node3 = ConditionsDOMWriter.buildDOM(conversationLine.getConditions());
                document.adoptNode(node3);
                node.appendChild(node3);
            }
            if (conversationNode.isTerminal()) {
                Element element = document.createElement("end-conversation");
                if (conversationNode.hasEffects()) {
                    node2 = EffectsDOMWriter.buildDOM("effect", conversationNode.getEffects());
                    document.adoptNode(node2);
                    element.appendChild(node2);
                }
                node.appendChild(element);
            } else if (TreeConversation.thereIsGoBackTag((ConversationNodeView)conversationNode)) {
                node.appendChild(document.createElement("go-back"));
            } else {
                ConversationDOMWriter.writeNodeInDOM(conversationNode.getChild(0), node);
            }
        } else if (conversationNode.getType() == 1) {
            Element element = document.createElement("response");
            if (((OptionConversationNode)conversationNode).isRandom().booleanValue()) {
                element.setAttribute("random", "yes");
            }
            for (int i = 0; i < conversationNode.getLineCount(); ++i) {
                Element element2 = document.createElement("option");
                ConversationLine conversationLine = conversationNode.getLine(i);
                Element element3 = document.createElement("speak-player");
                element3.setTextContent(conversationNode.getLine(i).getText());
                if (conversationLine.isValidAudio()) {
                    element3.setAttribute("uri", conversationLine.getAudioPath());
                }
                if (conversationLine.getSynthesizerVoice().booleanValue()) {
                    element3.setAttribute("synthesize", "yes");
                }
                element2.appendChild(element3);
                ConversationDOMWriter.writeNodeInDOM(conversationNode.getChild(i), element2);
                element.appendChild(element2);
            }
            if (conversationNode.hasEffects()) {
                Node node4 = EffectsDOMWriter.buildDOM("effect", conversationNode.getEffects());
                document.adoptNode(node4);
                element.appendChild(node4);
            }
            node.appendChild(element);
        }
    }

    private static Node buildGraphConversationDOM(GraphConversation graphConversation) {
        Element element = null;
        try {
            List list = graphConversation.getAllNodes();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("graph-conversation");
            element.setAttribute("id", graphConversation.getId());
            for (int i = 0; i < list.size(); ++i) {
                Node node;
                Object object;
                ConversationNode conversationNode = (ConversationNode)list.get(i);
                Element element2 = null;
                Node node2 = null;
                if (conversationNode instanceof DialogueConversationNode) {
                    element2 = document.createElement("dialogue-node");
                    element2.setAttribute("nodeindex", String.valueOf(i));
                    if (((DialogueConversationNode)conversationNode).isKeepShowing().booleanValue()) {
                        element2.setAttribute("keepShowing", "yes");
                    }
                    for (int j = 0; j < conversationNode.getLineCount(); ++j) {
                        object = conversationNode.getLine(j);
                        if (object.isPlayerLine()) {
                            node = document.createElement("speak-player");
                        } else {
                            node = document.createElement("speak-char");
                            if (!object.getName().equals("NPC")) {
                                node.setAttribute("idTarget", object.getName());
                            }
                        }
                        if (object.isValidAudio()) {
                            node.setAttribute("uri", object.getAudioPath());
                        }
                        if (object.getSynthesizerVoice().booleanValue()) {
                            node.setAttribute("synthesize", "yes");
                        }
                        node.setTextContent(object.getText());
                        element2.appendChild(node);
                        node2 = ConditionsDOMWriter.buildDOM(object.getConditions());
                        document.adoptNode(node2);
                        element2.appendChild(node2);
                    }
                    if (conversationNode.isTerminal()) {
                        Element element3 = document.createElement("end-conversation");
                        if (conversationNode.hasEffects()) {
                            node = EffectsDOMWriter.buildDOM("effect", conversationNode.getEffects());
                            document.adoptNode(node);
                            element3.appendChild(node);
                        }
                        element2.appendChild(element3);
                    } else {
                        Element element4 = document.createElement("child");
                        element4.setAttribute("nodeindex", String.valueOf(list.indexOf(conversationNode.getChild(0))));
                        element2.appendChild(element4);
                        if (conversationNode.hasEffects()) {
                            node = EffectsDOMWriter.buildDOM("effect", conversationNode.getEffects());
                            document.adoptNode(node);
                            element2.appendChild(node);
                        }
                    }
                }
                if (conversationNode instanceof OptionConversationNode) {
                    element2 = document.createElement("option-node");
                    element2.setAttribute("nodeindex", String.valueOf(i));
                    if (((OptionConversationNode)conversationNode).isRandom().booleanValue()) {
                        element2.setAttribute("random", "yes");
                    }
                    if (((OptionConversationNode)conversationNode).isKeepShowing().booleanValue()) {
                        element2.setAttribute("keepShowing", "yes");
                    }
                    if (((OptionConversationNode)conversationNode).isShowUserOption().booleanValue()) {
                        element2.setAttribute("showUserOption", "yes");
                    }
                    if (((OptionConversationNode)conversationNode).isPreListening().booleanValue()) {
                        element2.setAttribute("preListening", "yes");
                    }
                    for (int j = 0; j < conversationNode.getLineCount(); ++j) {
                        node = conversationNode.getLine(j);
                        object = document.createElement("speak-player");
                        object.setTextContent(conversationNode.getLine(j).getText());
                        if (node.isValidAudio()) {
                            object.setAttribute("uri", node.getAudioPath());
                        }
                        if (node.getSynthesizerVoice().booleanValue()) {
                            object.setAttribute("synthesize", "yes");
                        }
                        node2 = ConditionsDOMWriter.buildDOM(node.getConditions());
                        document.adoptNode(node2);
                        Element element5 = document.createElement("child");
                        element5.setAttribute("nodeindex", String.valueOf(list.indexOf(conversationNode.getChild(j))));
                        element2.appendChild((Node)object);
                        element2.appendChild(node2);
                        element2.appendChild(element5);
                    }
                    if (conversationNode.hasEffects()) {
                        Node node3 = EffectsDOMWriter.buildDOM("effect", conversationNode.getEffects());
                        document.adoptNode(node3);
                        element2.appendChild(node3);
                    }
                }
                element.appendChild(element2);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

