/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.conditions.Condition;
import es.eucm.eadventure.common.data.chapter.conditions.Conditions;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalStateCondition;
import es.eucm.eadventure.common.data.chapter.conditions.VarCondition;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConditionsDOMWriter {
    public static final int CONDITIONS = 0;
    public static final int INIT_CONDITIONS = 1;
    public static final int END_CONDITIONS = 2;
    public static final int GLOBAL_STATE = 3;

    private ConditionsDOMWriter() {
    }

    public static Node buildDOM(Conditions conditions) {
        return ConditionsDOMWriter.buildDOM(0, conditions);
    }

    public static Element buildDOM(GlobalState globalState) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("global-state");
            element.setAttribute("id", globalState.getId());
            Element element2 = document.createElement("documentation");
            element2.appendChild(document.createTextNode(globalState.getDocumentation()));
            element.appendChild(element2);
            for (int i = 0; i < globalState.size(); ++i) {
                Node node;
                List list = globalState.get(i);
                if (list.size() == 1) {
                    node = ConditionsDOMWriter.createConditionElement(document, (Condition)list.get(0));
                    document.adoptNode(node);
                    element.appendChild(node);
                    continue;
                }
                if (list.size() <= 1) continue;
                node = ConditionsDOMWriter.createElementWithList("either", list);
                document.adoptNode(node);
                element.appendChild(node);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }

    public static Node buildDOM(int n, Conditions conditions) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            if (n == 0) {
                element = document.createElement("condition");
            } else if (n == 1) {
                element = document.createElement("init-condition");
            } else if (n == 2) {
                element = document.createElement("end-condition");
            }
            document.adoptNode(element);
            for (int i = 0; i < conditions.size(); ++i) {
                Node node;
                List list = conditions.get(i);
                if (list.size() == 1) {
                    node = ConditionsDOMWriter.createConditionElement(document, (Condition)list.get(0));
                    document.adoptNode(node);
                    element.appendChild(node);
                    continue;
                }
                if (list.size() <= 1) continue;
                node = ConditionsDOMWriter.createElementWithList("either", list);
                document.adoptNode(node);
                element.appendChild(node);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }

    private static Node createElementWithList(String string, List<Condition> list) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement(string);
            ConditionsDOMWriter.createElementWithList(document, element, list);
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
            return null;
        }
    }

    private static Element createConditionElement(Document document, Condition condition) {
        Element element = null;
        if (condition.getType() == 1) {
            if (condition.getState() == 0) {
                element = document.createElement("active");
            } else if (condition.getState() == 1) {
                element = document.createElement("inactive");
            }
            element.setAttribute("flag", condition.getId());
        } else if (condition.getType() == 0) {
            VarCondition varCondition = (VarCondition)condition;
            if (varCondition.getState() == 4) {
                element = document.createElement("equals");
            } else if (condition.getState() == 3) {
                element = document.createElement("greater-equals-than");
            } else if (condition.getState() == 2) {
                element = document.createElement("greater-than");
            } else if (condition.getState() == 5) {
                element = document.createElement("less-equals-than");
            } else if (condition.getState() == 6) {
                element = document.createElement("less-than");
            }
            element.setAttribute("var", varCondition.getId());
            element.setAttribute("value", Integer.toString(varCondition.getValue()));
        } else if (condition.getType() == 2) {
            GlobalStateCondition globalStateCondition = (GlobalStateCondition)condition;
            element = document.createElement("global-state-ref");
            element.setAttribute("id", globalStateCondition.getId());
        }
        return element;
    }

    private static void createElementWithList(Document document, Element element, List<Condition> list) {
        for (Condition condition : list) {
            element.appendChild(ConditionsDOMWriter.createConditionElement(document, condition));
        }
    }
}

