/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.writer.domwriters.ActionsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ResourcesDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CharacterDOMWriter {
    private CharacterDOMWriter() {
    }

    public static Node buildDOM(NPC nPC) {
        Element element = null;
        try {
            Node node;
            Object object3;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("character");
            element.setAttribute("id", nPC.getId());
            if (nPC.getDocumentation() != null) {
                object2 = document.createElement("documentation");
                object2.appendChild(document.createTextNode(nPC.getDocumentation()));
                element.appendChild((Node)object2);
            }
            for (Object object3 : nPC.getResources()) {
                node = ResourcesDOMWriter.buildDOM((Resources)object3, 4);
                document.adoptNode(node);
                element.appendChild(node);
            }
            object2 = document.createElement("textcolor");
            object2.setAttribute("showsSpeechBubble", nPC.getShowsSpeechBubbles() != false ? "yes" : "no");
            object2.setAttribute("bubbleBkgColor", nPC.getBubbleBkgColor());
            object2.setAttribute("bubbleBorderColor", nPC.getBubbleBorderColor());
            object3 = document.createElement("frontcolor");
            object3.setAttribute("color", nPC.getTextFrontColor());
            object2.appendChild((Node)object3);
            node = document.createElement("bordercolor");
            node.setAttribute("color", nPC.getTextBorderColor());
            object2.appendChild(node);
            element.appendChild((Node)object2);
            Element element2 = document.createElement("description");
            Element element3 = document.createElement("name");
            element3.appendChild(document.createTextNode(nPC.getName()));
            element2.appendChild(element3);
            Element element4 = document.createElement("brief");
            element4.appendChild(document.createTextNode(nPC.getDescription()));
            element2.appendChild(element4);
            Element element5 = document.createElement("detailed");
            element5.appendChild(document.createTextNode(nPC.getDetailedDescription()));
            element2.appendChild(element5);
            element.appendChild(element2);
            Element element6 = document.createElement("voice");
            element6.setAttribute("name", nPC.getVoice());
            if (nPC.isAlwaysSynthesizer().booleanValue()) {
                element6.setAttribute("synthesizeAlways", "yes");
            } else {
                element6.setAttribute("synthesizeAlways", "no");
            }
            element.appendChild(element6);
            if (nPC.getActionsCount() > 0) {
                Node node2 = ActionsDOMWriter.buildDOM(nPC.getActions());
                document.adoptNode(node2);
                element.appendChild(node2);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

