/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.conditions.GlobalState;
import es.eucm.eadventure.common.data.chapter.conversation.Conversation;
import es.eucm.eadventure.common.data.chapter.effects.Macro;
import es.eucm.eadventure.common.data.chapter.elements.Atrezzo;
import es.eucm.eadventure.common.data.chapter.elements.Item;
import es.eucm.eadventure.common.data.chapter.elements.NPC;
import es.eucm.eadventure.common.data.chapter.scenes.Cutscene;
import es.eucm.eadventure.common.data.chapter.scenes.Scene;
import es.eucm.eadventure.editor.control.writer.domwriters.AtrezzoDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.BookDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.CharacterDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ConversationDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.CutsceneDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.EffectsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ItemDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.PlayerDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.SceneDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.TimerDOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChapterDOMWriter {
    private ChapterDOMWriter() {
    }

    public static Node buildDOM(Chapter chapter, String string, Document document) {
        Node node;
        boolean bl;
        Element element = null;
        element = document.createElement("eAdventure");
        if (!chapter.getAdaptationName().equals("")) {
            element.setAttribute("adaptProfile", chapter.getAdaptationName());
        }
        if (!chapter.getAssessmentName().equals("")) {
            element.setAttribute("assessProfile", chapter.getAssessmentName());
        }
        for (Object object : chapter.getScenes()) {
            bl = chapter.getTargetId().equals(object.getId());
            node = SceneDOMWriter.buildDOM((Scene)object, bl);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (Object object : chapter.getCutscenes()) {
            bl = chapter.getTargetId().equals(object.getId());
            node = CutsceneDOMWriter.buildDOM((Cutscene)object, bl);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (Object object : chapter.getBooks()) {
            Node node2 = BookDOMWriter.buildDOM((Book)object);
            document.adoptNode(node2);
            element.appendChild(node2);
        }
        for (Object object : chapter.getItems()) {
            Node node3 = ItemDOMWriter.buildDOM((Item)object);
            document.adoptNode(node3);
            element.appendChild(node3);
        }
        Node node4 = PlayerDOMWriter.buildDOM(chapter.getPlayer());
        document.adoptNode(node4);
        element.appendChild(node4);
        for (NPC nPC : chapter.getCharacters()) {
            node = CharacterDOMWriter.buildDOM(nPC);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (Conversation conversation : chapter.getConversations()) {
            node = ConversationDOMWriter.buildDOM(conversation);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (Timer timer : chapter.getTimers()) {
            node = TimerDOMWriter.buildDOM(timer);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (GlobalState globalState : chapter.getGlobalStates()) {
            node = ConditionsDOMWriter.buildDOM(globalState);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (Macro macro : chapter.getMacros()) {
            node = EffectsDOMWriter.buildDOM(macro);
            document.adoptNode(node);
            element.appendChild(node);
        }
        for (Atrezzo atrezzo : chapter.getAtrezzo()) {
            node = AtrezzoDOMWriter.buildDOM(atrezzo);
            document.adoptNode(node);
            element.appendChild(node);
        }
        return element;
    }
}

