/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.book.Book;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.writer.domwriters.ResourcesDOMWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BookDOMWriter {
    private BookDOMWriter() {
    }

    public static Node buildDOM(Book book) {
        Element element = null;
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("book");
            element.setAttribute("id", book.getId());
            if (book.getNextPagePoint() != null) {
                element.setAttribute("xNextPage", book.getNextPagePoint().x + "");
                element.setAttribute("yNextPage", book.getNextPagePoint().y + "");
            }
            if (book.getPreviousPagePoint() != null) {
                element.setAttribute("xPreviousPage", book.getPreviousPagePoint().x + "");
                element.setAttribute("yPreviousPage", book.getPreviousPagePoint().y + "");
            }
            if (book.getDocumentation() != null) {
                object = document.createElement("documentation");
                object.appendChild(document.createTextNode(book.getDocumentation()));
                element.appendChild((Node)object);
            }
            for (Object object2 : book.getResources()) {
                Node node = ResourcesDOMWriter.buildDOM((Resources)object2, 7);
                document.adoptNode(node);
                element.appendChild(node);
            }
            object = null;
            if (book.getType() == 0) {
                object = document.createElement("text");
                for (Node node : book.getParagraphs()) {
                    Node node2 = null;
                    if (node.getType() == 2) {
                        node2 = document.createTextNode(node.getContent());
                    }
                    if (node.getType() == 3) {
                        node2 = document.createElement("title");
                        node2.appendChild(document.createTextNode(node.getContent()));
                    } else if (node.getType() == 0) {
                        node2 = document.createElement("bullet");
                        node2.appendChild(document.createTextNode(node.getContent()));
                    } else if (node.getType() == 1) {
                        Element element2 = document.createElement("img");
                        element2.setAttribute("src", node.getContent());
                        node2 = element2;
                    }
                    object.appendChild(node2);
                }
            } else if (book.getType() == 1) {
                object = document.createElement("pages");
                for (Node node : book.getPageURLs()) {
                    if (node.getUri().isEmpty()) continue;
                    Element element3 = document.createElement("page");
                    element3.setAttribute("scrollable", node.getScrollable() ? "yes" : "no");
                    element3.setAttribute("margin", Integer.toString(node.getMargin()));
                    if (node.getMarginEnd() != 0) {
                        element3.setAttribute("marginEnd", Integer.toString(node.getMarginEnd()));
                    }
                    if (node.getMarginTop() != 0) {
                        element3.setAttribute("marginTop", Integer.toString(node.getMarginTop()));
                    }
                    if (node.getMarginBottom() != 0) {
                        element3.setAttribute("marginBottom", Integer.toString(node.getMarginBottom()));
                    }
                    element3.setAttribute("uri", node.getUri());
                    switch (node.getType()) {
                        case 1: {
                            element3.setAttribute("type", "resource");
                            break;
                        }
                        case 2: {
                            element3.setAttribute("type", "image");
                            break;
                        }
                        case 0: {
                            element3.setAttribute("type", "url");
                            break;
                        }
                        default: {
                            element3.setAttribute("type", "url");
                        }
                    }
                    object.appendChild(element3);
                }
            }
            element.appendChild((Node)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

