/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentProperty;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentEffect;
import es.eucm.eadventure.common.data.assessment.TimedAssessmentRule;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AssessmentDOMWriter {
    private AssessmentDOMWriter() {
    }

    public static Element buildDOM(AssessmentProfile assessmentProfile, Document document) {
        List list = assessmentProfile.getRules();
        Element element = null;
        element = document.createElement("assessment");
        if (assessmentProfile.isShowReportAtEnd()) {
            element.setAttribute("show-report-at-end", "yes");
        } else {
            element.setAttribute("show-report-at-end", "no");
        }
        if (!assessmentProfile.isShowReportAtEnd() || !assessmentProfile.isSendByEmail()) {
            element.setAttribute("send-to-email", "");
        } else if (assessmentProfile.getEmail() == null || !assessmentProfile.getEmail().contains("@")) {
            element.setAttribute("send-to-email", "");
        } else {
            element.setAttribute("send-to-email", assessmentProfile.getEmail());
        }
        if (assessmentProfile.isScorm12()) {
            element.setAttribute("scorm12", "yes");
        } else {
            element.setAttribute("scorm12", "no");
        }
        if (assessmentProfile.isScorm2004()) {
            element.setAttribute("scorm2004", "yes");
        } else {
            element.setAttribute("scorm2004", "no");
        }
        element.setAttribute("name", assessmentProfile.getName());
        Element element2 = document.createElement("smtp-config");
        element2.setAttribute("smtp-ssl", assessmentProfile.isSmtpSSL() ? "yes" : "no");
        element2.setAttribute("smtp-server", assessmentProfile.getSmtpServer());
        element2.setAttribute("smtp-port", assessmentProfile.getSmtpPort());
        element2.setAttribute("smtp-user", assessmentProfile.getSmtpUser());
        element2.setAttribute("smtp-pwd", assessmentProfile.getSmtpPwd());
        element.appendChild(element2);
        for (AssessmentRule assessmentRule : list) {
            Element element3;
            Node node;
            Object object;
            if (assessmentRule instanceof TimedAssessmentRule) {
                Node node2;
                object = (TimedAssessmentRule)assessmentRule;
                node = document.createElement("timed-assessment-rule");
                node.setAttribute("id", object.getId());
                node.setAttribute("importance", AssessmentRule.IMPORTANCE_VALUES[object.getImportance()]);
                node.setAttribute("usesEndConditions", object.isUsesEndConditions() ? "yes" : "no");
                node.setAttribute("repeatRule", object.isRepeatRule() != false ? "yes" : "no");
                if (object.getConcept() != null && !object.getConcept().equals("")) {
                    node2 = document.createElement("concept");
                    node2.appendChild(document.createTextNode(object.getConcept()));
                    node.appendChild(node2);
                }
                if (!object.getInitConditions().isEmpty()) {
                    node2 = ConditionsDOMWriter.buildDOM(1, object.getInitConditions());
                    document.adoptNode(node2);
                    node.appendChild(node2);
                }
                if (!object.getEndConditions().isEmpty()) {
                    node2 = ConditionsDOMWriter.buildDOM(2, object.getEndConditions());
                    document.adoptNode(node2);
                    node.appendChild(node2);
                }
                for (int i = 0; i < object.getEffectsCount(); ++i) {
                    Object object2 = document.createElement("assessEffect");
                    object2.setAttribute("time-min", Integer.toString(object.getMinTime(i)));
                    object2.setAttribute("time-max", Integer.toString(object.getMaxTime(i)));
                    element3 = (TimedAssessmentEffect)object.getEffects().get(i);
                    if (element3.getText() != null && !element3.getText().equals("")) {
                        Element element4 = document.createElement("set-text");
                        element4.appendChild(document.createTextNode(element3.getText()));
                        object2.appendChild(element4);
                    }
                    for (AssessmentProperty assessmentProperty : element3.getAssessmentProperties()) {
                        Element element5 = document.createElement("set-property");
                        element5.setAttribute("id", assessmentProperty.getId());
                        element5.setAttribute("value", String.valueOf(assessmentProperty.getValue()));
                        object2.appendChild(element5);
                    }
                    node.appendChild((Node)object2);
                }
                element.appendChild(node);
                continue;
            }
            object = document.createElement("assessment-rule");
            object.setAttribute("id", assessmentRule.getId());
            object.setAttribute("importance", AssessmentRule.IMPORTANCE_VALUES[assessmentRule.getImportance()]);
            object.setAttribute("repeatRule", assessmentRule.isRepeatRule() != false ? "yes" : "no");
            if (assessmentRule.getConcept() != null && !assessmentRule.getConcept().equals("")) {
                node = document.createElement("concept");
                node.appendChild(document.createTextNode(assessmentRule.getConcept()));
                object.appendChild(node);
            }
            if (!assessmentRule.getConditions().isEmpty()) {
                node = ConditionsDOMWriter.buildDOM(assessmentRule.getConditions());
                document.adoptNode(node);
                object.appendChild(node);
            }
            node = document.createElement("assessEffect");
            if (assessmentRule.getText() != null && !assessmentRule.getText().equals("")) {
                Element element6 = document.createElement("set-text");
                element6.appendChild(document.createTextNode(assessmentRule.getText()));
                node.appendChild(element6);
            }
            for (Object object2 : assessmentRule.getAssessmentProperties()) {
                element3 = document.createElement("set-property");
                element3.setAttribute("id", object2.getId());
                element3.setAttribute("value", object2.getValue());
                if (object2.getVarName() != null) {
                    element3.setAttribute("varName", object2.getVarName());
                }
                node.appendChild(element3);
            }
            object.appendChild(node);
            element.appendChild((Node)object);
        }
        return element;
    }
}

