/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer.domwriters;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Action;
import es.eucm.eadventure.common.data.chapter.CustomAction;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.writer.domwriters.ConditionsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.EffectsDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ResourcesDOMWriter;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ActionsDOMWriter {
    private ActionsDOMWriter() {
    }

    public static Node buildDOM(List<Action> list) {
        Element element = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            element = document.createElement("actions");
            if (!list.isEmpty()) {
                for (Action action : list) {
                    Object object;
                    Element element2 = null;
                    switch (action.getType()) {
                        case 0: {
                            element2 = document.createElement("examine");
                            break;
                        }
                        case 1: {
                            element2 = document.createElement("grab");
                            break;
                        }
                        case 4: {
                            element2 = document.createElement("use");
                            break;
                        }
                        case 7: {
                            element2 = document.createElement("talk-to");
                            break;
                        }
                        case 3: {
                            element2 = document.createElement("use-with");
                            element2.setAttribute("idTarget", action.getTargetId());
                            break;
                        }
                        case 2: {
                            element2 = document.createElement("give-to");
                            element2.setAttribute("idTarget", action.getTargetId());
                            break;
                        }
                        case 8: {
                            element2 = document.createElement("drag-to");
                            element2.setAttribute("idTarget", action.getTargetId());
                            break;
                        }
                        case 5: {
                            Node node;
                            element2 = document.createElement("custom");
                            element2.setAttribute("name", ((CustomAction)action).getName());
                            for (Resources resources : ((CustomAction)action).getResources()) {
                                node = ResourcesDOMWriter.buildDOM(resources, 6);
                                document.adoptNode(node);
                                element2.appendChild(node);
                            }
                            break;
                        }
                        case 6: {
                            Node node;
                            element2 = document.createElement("custom-interact");
                            element2.setAttribute("idTarget", action.getTargetId());
                            element2.setAttribute("name", ((CustomAction)action).getName());
                            for (Resources resources : ((CustomAction)action).getResources()) {
                                node = ResourcesDOMWriter.buildDOM(resources, 6);
                                document.adoptNode(node);
                                element2.appendChild(node);
                            }
                            break;
                        }
                    }
                    element2.setAttribute("needsGoTo", action.isNeedsGoTo() != false ? "yes" : "no");
                    element2.setAttribute("keepDistance", "" + action.getKeepDistance());
                    element2.setAttribute("not-effects", action.isActivatedNotEffects() ? "yes" : "no");
                    if (action.getDocumentation() != null) {
                        object = document.createElement("documentation");
                        object.appendChild(document.createTextNode(action.getDocumentation()));
                        element2.appendChild((Node)object);
                    }
                    if (!action.getConditions().isEmpty()) {
                        object = ConditionsDOMWriter.buildDOM(action.getConditions());
                        document.adoptNode((Node)object);
                        element2.appendChild((Node)object);
                    }
                    if (!action.getEffects().isEmpty()) {
                        object = EffectsDOMWriter.buildDOM("effect", action.getEffects());
                        document.adoptNode((Node)object);
                        element2.appendChild((Node)object);
                    }
                    if (action.getNotEffects() != null && !action.getNotEffects().isEmpty()) {
                        object = EffectsDOMWriter.buildDOM("not-effect", action.getNotEffects());
                        document.adoptNode((Node)object);
                        element2.appendChild((Node)object);
                    }
                    element.appendChild(element2);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)"UNKNOWERROR");
        }
        return element;
    }
}

