/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer;

import es.eucm.eadventure.common.auxiliar.File;
import es.eucm.eadventure.common.auxiliar.ReleaseFolders;
import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.adaptation.AdaptationProfile;
import es.eucm.eadventure.common.data.adaptation.AdaptationRule;
import es.eucm.eadventure.common.data.adaptation.AdaptedState;
import es.eucm.eadventure.common.data.assessment.AssessmentProfile;
import es.eucm.eadventure.common.data.assessment.AssessmentRule;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.common.data.chapter.conversation.node.ConversationNodeView;
import es.eucm.eadventure.common.gui.TC;
import es.eucm.eadventure.editor.auxiliar.filefilters.XMLFileFilter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.AdventureDataControl;
import es.eucm.eadventure.editor.control.controllers.AssetsController;
import es.eucm.eadventure.editor.control.controllers.character.NPCDataControl;
import es.eucm.eadventure.editor.control.controllers.conversation.ConversationDataControl;
import es.eucm.eadventure.editor.control.controllers.cutscene.CutsceneDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.security.JARSigner;
import es.eucm.eadventure.editor.control.writer.domwriters.AdaptationDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.AssessmentDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ChapterDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.DescriptorDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ExpectedGameIODOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.ims.IMSDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.lom.LOMDOMWriter;
import es.eucm.eadventure.editor.control.writer.domwriters.lomes.LOMESDOMWriter;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Writer {
    private static final String RESOURCE_IDENTIFIER = "res_eAdventure";
    private static final String ITEM_IDENTIFIER = "itm_eAdventure";
    private static final String ORGANIZATION_IDENTIFIER = "eAdventure";
    private static final String ORGANIZATION_TITLE = "eAdventure course";
    private static final String ORGANIZATION_STRUCTURE = "hierarchical";

    private Writer() {
    }

    public static boolean writeData(String string, AdventureDataControl adventureDataControl, boolean bl) {
        boolean bl2 = false;
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(string);
            if (file.exists()) {
                object = file.listFiles((FileFilter)((Object)new XMLFileFilter()));
                for (Object object2 : object) {
                    if (!object2.isFile()) continue;
                    object2.delete();
                }
            }
            AssetsController.addSpecialAssets();
            object = DescriptorDOMWriter.buildDOM(adventureDataControl, bl);
            Writer.indentDOM((Node)object, 0);
            document = documentBuilder.newDocument();
            document.adoptNode((Node)object);
            document.appendChild((Node)object);
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-system", "descriptor.dtd");
            fileOutputStream = new FileOutputStream(string + "/descriptor.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            int n = 1;
            for (Chapter chapter : adventureDataControl.getChapters()) {
                document = documentBuilder.newDocument();
                object = ChapterDOMWriter.buildDOM(chapter, string, document);
                for (AdaptationProfile adaptationProfile : chapter.getAdaptationProfiles()) {
                    object.appendChild(Writer.writeAdaptationData(adaptationProfile, true, document));
                }
                for (AdaptationProfile adaptationProfile : chapter.getAssessmentProfiles()) {
                    object.appendChild(Writer.writeAssessmentData((AssessmentProfile)adaptationProfile, true, document));
                }
                Writer.indentDOM((Node)object, 0);
                document = documentBuilder.newDocument();
                document.adoptNode((Node)object);
                document.appendChild((Node)object);
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("doctype-system", "eadventure.dtd");
                fileOutputStream = new FileOutputStream(string + "/chapter" + n++ + ".xml");
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
                outputStreamWriter.close();
                ((OutputStream)fileOutputStream).close();
            }
            bl2 = true;
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
        }
        return bl2;
    }

    public static Element writeAssessmentData(AssessmentProfile assessmentProfile, boolean bl, Document document) {
        Element element = null;
        if (assessmentProfile.getName() != null && !assessmentProfile.getName().equals("")) {
            element = AssessmentDOMWriter.buildDOM(assessmentProfile, document);
        }
        return element;
    }

    public static Element writeAdaptationData(AdaptationProfile adaptationProfile, boolean bl, Document document) {
        Element element = null;
        String string = adaptationProfile.getName();
        if (string != null && !adaptationProfile.getName().equals("")) {
            List list = adaptationProfile.getRules();
            AdaptedState adaptedState = adaptationProfile.getInitialState();
            boolean bl2 = adaptationProfile.isScorm2004();
            boolean bl3 = adaptationProfile.isScorm12();
            element = AdaptationDOMWriter.buildDOM(list, adaptedState, bl3, bl2, string, document);
        }
        return element;
    }

    private static void indentDOM(Node node, int n) {
        Document document = node.getOwnerDocument();
        NodeList nodeList = node.getChildNodes();
        boolean bl = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            node.insertBefore(document.createTextNode("\n" + Writer.getTab(n + 1)), node2);
            Writer.indentDOM(node2, n + 1);
            bl = false;
            ++i;
        }
        if (!bl) {
            node.appendChild(document.createTextNode("\n" + Writer.getTab(n)));
        }
    }

    private static boolean writeWebPage(String string, String string2, boolean bl, String string3) {
        return Writer.writeWebPage(string, string2, bl, string3, null);
    }

    private static boolean writeWebPage(String string, String string2, boolean bl, String string3, HashMap<String, String> hashMap) {
        boolean bl2 = true;
        try {
            String string4 = "";
            boolean bl3 = true;
            if (string3.equals("es.eucm.eadventure.engine.EAdventureAppletLAMS")) {
                bl3 = true;
            }
            string4 = string4 + "\t\t<script type='text/javascript' language='JavaScript'>\n";
            string4 = string4 + "\t\t\t<!--\n";
            string4 = string4 + "\t\t\tfunction hideText(){\n";
            string4 = string4 + "\t\t\t\tmsg = document.getElementById('loadingMessage');\n";
            string4 = string4 + "\t\t\t\tmsg.style.display = 'none';\n";
            string4 = string4 + "\t\t\t}\n";
            if (bl3) {
                string4 = string4 + "\t\t\tfunction getParams(){\n";
                string4 = string4 + "\t\t\t\tparent.setParams();\n";
                string4 = string4 + "\t\t\t}\n";
                string4 = string4 + "\t\t\tfunction showButton(){\n";
                string4 = string4 + "\t\t\t\ttop.contentFrame.frames[0].showButton();\n";
                string4 = string4 + "\t\t\t}\n";
            }
            string4 = string4 + "\t\t//-->\n";
            string4 = string4 + "\t\t</script>\n";
            if (string3.equals("es.eucm.eadventure.engine.EAdventureAppletScorm")) {
                string4 = string4 + "\n\t\t<script type='text/javascript' src='eadventure.js'></script>\n";
            }
            String string5 = "<html>\n\t<head>\n" + string4 + "\t</head>\n" + "\t<body>\n" + "\t\t<applet code=\"" + string3 + "\" archive=\"./" + string2 + ".jar\" name=\"eadventure\" id=\"eadventure\" " + (bl ? "width=\"200\" height=\"150\"" : "width=\"800\" height=\"600\"") + " MAYSCRIPT>\n" + "\t\t<param name=\"WINDOWED\" value=\"" + (bl ? "yes" : "no") + "\"/>\n" + "\t\t<param name=\"java_arguments\" value=\"-Xms256m -Xmx512m\"/>\n" + "\t\t<param name=\"image\" value=\"splashScreen.gif\"/>\n";
            if (hashMap != null) {
                for (String object2 : hashMap.keySet()) {
                    if (object2 == null || hashMap.get(object2) == null) continue;
                    String string6 = hashMap.get(object2);
                    string5 = string5 + "\t\t<param name=\"" + object2 + "\" value=\"" + string6 + "\"/>\n";
                }
            }
            string5 = string5 + "\t\t</applet>\n<div id=\"loadingMessage\"><p><b>" + TC.get((String)"Applet.LoadingMessage") + "</b></p></div>\n" + "\t</body>\n" + "</html>\n";
            File file = new File(string + "/" + string2 + ".html");
            file.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream((java.io.File)file);
            ((OutputStream)fileOutputStream).write(string5.getBytes());
            ((OutputStream)fileOutputStream).close();
            bl2 = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ReportDialog.GenerateErrorReport((Exception)fileNotFoundException, (boolean)true, (String)"UNKNOWNERROR");
            bl2 = false;
        }
        catch (IOException iOException) {
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWNERROR");
            bl2 = false;
        }
        return bl2;
    }

    public static String defaultManifestFile(String string) {
        String string2 = "Manifest-Version: 1.0\nAnt-Version: Apache Ant 1.7.0\nCreated-By: 1.6.0_02-b06 (Sun Microsystems Inc.)\nMain-Class: " + string + "\n";
        return string2;
    }

    public static boolean export(String string, String string2) {
        boolean bl = false;
        String string3 = string2.substring(0, string2.lastIndexOf("."));
        String string4 = string3 + ".zip";
        File.zipDirectory((String)string, (String)string4);
        File file = new File(string4);
        File file2 = new File(string2);
        bl = file.renameTo((java.io.File)file2);
        return bl;
    }

    public static void addNeededLibrariesToJar(ZipOutputStream zipOutputStream, Controller controller) {
        File.addJarContentsToZip((String)"jars/tritonus_share.jar", (ZipOutputStream)zipOutputStream);
        File.addJarContentsToZip((String)"jars/mp3spi1.9.4.jar", (ZipOutputStream)zipOutputStream);
        File.addJarContentsToZip((String)"jars/jl1.0.jar", (ZipOutputStream)zipOutputStream);
        File.addJarContentsToZip((String)"jars/jmf.jar", (ZipOutputStream)zipOutputStream);
        File.addJarContentsToZip((String)"jars/mailapi.jar", (ZipOutputStream)zipOutputStream);
        File.addJarContentsToZip((String)"jars/smtp.jar", (ZipOutputStream)zipOutputStream);
        File.addJarContentsToZip((String)"jars/activation.jar", (ZipOutputStream)zipOutputStream);
        boolean bl = false;
        boolean bl2 = false;
        for (ChapterDataControl chapterDataControl : controller.getCharapterList().getChapters()) {
            for (CutsceneDataControl cutsceneDataControl : chapterDataControl.getCutscenesList().getCutscenes()) {
                if (cutsceneDataControl.getType() != 37) continue;
                bl2 = true;
            }
            for (NPCDataControl nPCDataControl : chapterDataControl.getNPCsList().getNPCs()) {
                if (!nPCDataControl.isAlwaysSynthesizer()) continue;
                bl = true;
            }
            if (chapterDataControl.getPlayer().isAlwaysSynthesizer()) {
                bl = true;
            }
            for (ConversationDataControl conversationDataControl : chapterDataControl.getConversationsList().getConversations()) {
                for (ConversationNodeView conversationNodeView : conversationDataControl.getAllNodes()) {
                    for (int i = 0; i < conversationNodeView.getLineCount(); ++i) {
                        if (!conversationNodeView.getConversationLine(i).getSynthesizerVoice().booleanValue()) continue;
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            File.addJarContentsToZip((String)"jars/freetts.jar", (ZipOutputStream)zipOutputStream);
            File.addJarContentsToZip((String)"jars/cmu_time_awb.jar", (ZipOutputStream)zipOutputStream);
            File.addJarContentsToZip((String)"jars/cmulex.jar", (ZipOutputStream)zipOutputStream);
            File.addJarContentsToZip((String)"jars/cmutimelex.jar", (ZipOutputStream)zipOutputStream);
            File.addJarContentsToZip((String)"jars/cmudict04.jar", (ZipOutputStream)zipOutputStream);
            File.addJarContentsToZip((String)"jars/en_us.jar", (ZipOutputStream)zipOutputStream);
            File.addJarContentsToZip((String)"jars/cmu_us_kal.jar", (ZipOutputStream)zipOutputStream);
        }
        if (bl2) {
            File.addJarContentsToZip((String)"jars/jffmpeg-1.1.0.jar", (ZipOutputStream)zipOutputStream);
        }
        File.addFileToZip((File)new File(ReleaseFolders.getLanguageFilePath4Engine((String)Controller.getInstance().getLanguage())), (String)"i18n/engine/en_EN.xml", (ZipOutputStream)zipOutputStream);
    }

    public static boolean exportStandalone(String string, String string2) {
        boolean bl = true;
        try {
            File file = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream((java.io.File)file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            String string3 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureStandalone");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(string3.getBytes());
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
            ReportDialog.GenerateErrorReport((Exception)fileNotFoundException, (boolean)true, (String)"UNKNOWNERROR");
        }
        catch (IOException iOException) {
            bl = false;
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)"UNKNOWNERROR");
        }
        return bl;
    }

    public static boolean exportAsLearningObject(String string, String string2, String string3, String string4, boolean bl, String string5, AdventureDataControl adventureDataControl) {
        boolean bl2 = true;
        try {
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(Controller.createTempDirectory().getAbsolutePath());
            for (Object object2 : file.listFiles()) {
                if (object2.isDirectory()) {
                    object2.deleteAll();
                }
                object2.delete();
            }
            bl2 &= Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureApplet ");
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream2 = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream2);
            object2 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureApplet");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(((String)object2).getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            bl2 &= file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            bl2 = JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = null;
            element = document.createElement("manifest");
            element.setAttribute("identifier", "imsaccmdv1p0_manifest");
            element.setAttribute("xmlns", "http://www.imsglobal.org/xsd/imscp_v1p1");
            element.setAttribute("xmlns:imsmd", "http://www.imsglobal.org/xsd/imsmd_v1p2");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.imsglobal.org/xsd/imscp_v1p1 imscp_v1p1.xsd http://www.imsglobal.org/xsd/imsmd_v1p2 imsmd_v1p2p4.xsd");
            element.setAttribute("version", "IMS CP 1.1.3");
            Element element2 = document.createElement("organizations");
            element2.setAttribute("default", ORGANIZATION_IDENTIFIER);
            Element element3 = document.createElement("organization");
            element3.setAttribute("identifier", ORGANIZATION_IDENTIFIER);
            Element element4 = document.createElement("title");
            element4.setTextContent(ORGANIZATION_TITLE);
            element3.appendChild(element4);
            Element element5 = document.createElement("item");
            element5.setAttribute("identifier", ITEM_IDENTIFIER);
            element5.setAttribute("identifierref", RESOURCE_IDENTIFIER);
            element5.setAttribute("isvisible", "1");
            element5.setAttribute("parameters", "");
            Element element6 = document.createElement("title");
            element6.setTextContent(adventureDataControl.getTitle());
            element5.appendChild(element6);
            element3.appendChild(element5);
            element2.appendChild(element3);
            element.appendChild(element2);
            Element element7 = document.createElement("resources");
            Element element8 = document.createElement("resource");
            element8.setAttribute("identifier", RESOURCE_IDENTIFIER);
            element8.setAttribute("type", "webcontent");
            element8.setAttribute("href", string2 + ".html");
            Element element9 = document.createElement("metadata");
            Node node = LOMDOMWriter.buildLOMDOM(adventureDataControl.getLomController(), false);
            document.adoptNode(node);
            element9.appendChild(node);
            element8.appendChild(element9);
            Element element10 = document.createElement("file");
            element10.setAttribute("href", string2 + ".html");
            element8.appendChild(element10);
            Element element11 = document.createElement("file");
            element11.setAttribute("href", string2 + ".jar");
            element8.appendChild(element11);
            Element element12 = document.createElement("file");
            element12.setAttribute("href", "splashScreen.gif");
            element8.appendChild(element12);
            element7.appendChild(element8);
            element.appendChild(element7);
            Writer.indentDOM(element, 0);
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/imsmanifest.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File file3 = new File("web/splashScreen.gif");
            if (bl) {
                file3 = new File("web/splashScreen_red.gif");
            }
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/splashScreen.gif"));
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        return bl2;
    }

    public static boolean exportAsLAMSLearningObject(String string, String string2, String string3, String string4, boolean bl, String string5, AdventureDataControl adventureDataControl) {
        boolean bl2 = true;
        try {
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(Controller.createTempDirectory().getAbsolutePath());
            for (Object object2 : file.listFiles()) {
                if (object2.isDirectory()) {
                    object2.deleteAll();
                }
                object2.delete();
            }
            bl2 &= Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureAppletLAMS ");
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream2 = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream2);
            object2 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureAppletLAMS");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(((String)object2).getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            bl2 &= file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            bl2 = JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = null;
            element = document.createElement("manifest");
            element.setAttribute("identifier", "imsaccmdv1p0_manifest");
            element.setAttribute("xmlns", "http://www.imsglobal.org/xsd/imscp_v1p1");
            element.setAttribute("xmlns:imsmd", "http://www.imsglobal.org/xsd/imsmd_v1p2");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.imsglobal.org/xsd/imscp_v1p1 imscp_v1p1.xsd http://www.imsglobal.org/xsd/imsmd_v1p2 imsmd_v1p2p4.xsd");
            element.setAttribute("version", "IMS CP 1.1.3");
            Element element2 = document.createElement("organizations");
            element2.setAttribute("default", ORGANIZATION_IDENTIFIER);
            Element element3 = document.createElement("organization");
            element3.setAttribute("identifier", ORGANIZATION_IDENTIFIER);
            Element element4 = document.createElement("title");
            element4.setTextContent(ORGANIZATION_TITLE);
            element3.appendChild(element4);
            Element element5 = document.createElement("item");
            element5.setAttribute("identifier", ITEM_IDENTIFIER);
            element5.setAttribute("identifierref", RESOURCE_IDENTIFIER);
            element5.setAttribute("isvisible", "1");
            element5.setAttribute("parameters", "");
            Element element6 = document.createElement("title");
            element6.setTextContent(adventureDataControl.getTitle());
            element5.appendChild(element6);
            element3.appendChild(element5);
            element2.appendChild(element3);
            element.appendChild(element2);
            Element element7 = document.createElement("resources");
            Element element8 = document.createElement("resource");
            element8.setAttribute("identifier", RESOURCE_IDENTIFIER);
            element8.setAttribute("type", "webcontent");
            element8.setAttribute("href", string2 + ".html");
            Element element9 = document.createElement("metadata");
            Node node = LOMDOMWriter.buildLOMDOM(adventureDataControl.getLomController(), false);
            document.adoptNode(node);
            element9.appendChild(node);
            element8.appendChild(element9);
            Element element10 = document.createElement("file");
            element10.setAttribute("href", string2 + ".html");
            element8.appendChild(element10);
            Element element11 = document.createElement("file");
            element11.setAttribute("href", string2 + ".jar");
            element8.appendChild(element11);
            Element element12 = document.createElement("file");
            element12.setAttribute("href", "splashScreen.gif");
            element8.appendChild(element12);
            element7.appendChild(element8);
            element.appendChild(element7);
            Writer.indentDOM(element, 0);
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/imsmanifest.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File file3 = new File("web/splashScreen.gif");
            if (bl) {
                file3 = new File("web/splashScreen_red.gif");
            }
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/splashScreen.gif"));
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element13 = ExpectedGameIODOMWriter.buildExpectedInputs(document, Writer.getAdaptationRules(adventureDataControl.getAdventureData().getChapters()), Writer.getAssessmemtRules(adventureDataControl.getAdventureData().getChapters()));
            Writer.indentDOM(element13, 0);
            document.adoptNode(element13);
            document.appendChild(element13);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/ead-parameters.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        return bl2;
    }

    public static boolean exportAsGAMETELLearningObject(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, AdventureDataControl adventureDataControl) {
        boolean bl2 = true;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(Controller.createTempDirectory().getAbsolutePath());
            for (File object2 : file.listFiles()) {
                if (object2.isDirectory()) {
                    object2.deleteAll();
                }
                object2.delete();
            }
            HashMap hashMap = new HashMap();
            if (string6 != null && string7 != null && string6.length() > 0 && string7.length() > 0) {
                hashMap.put("return-uri", string6);
                hashMap.put("user-id", string7);
            }
            bl2 &= Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureAppletGAMETEL", hashMap);
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream2 = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream2);
            String string8 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureAppletGAMETEL");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(string8.getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            bl2 &= file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            bl2 = JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            File file3 = new File("web/splashScreen.gif");
            if (bl) {
                file3 = new File("web/splashScreen_red.gif");
            }
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/splashScreen.gif"));
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = ExpectedGameIODOMWriter.buildExpectedInputs(document, Writer.getAdaptationRules(adventureDataControl.getAdventureData().getChapters()), Writer.getAssessmemtRules(adventureDataControl.getAdventureData().getChapters()));
            Writer.indentDOM(element, 0);
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/ead-parameters.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        return bl2;
    }

    private static List<AdaptationRule> getAdaptationRules(List<Chapter> list) {
        ArrayList<AdaptationRule> arrayList = new ArrayList<AdaptationRule>();
        for (Chapter chapter : list) {
            for (AdaptationProfile adaptationProfile : chapter.getAdaptationProfiles()) {
                arrayList.addAll(adaptationProfile.getRules());
            }
        }
        return arrayList;
    }

    private static List<AssessmentRule> getAssessmemtRules(List<Chapter> list) {
        ArrayList<AssessmentRule> arrayList = new ArrayList<AssessmentRule>();
        for (Chapter chapter : list) {
            for (AssessmentProfile assessmentProfile : chapter.getAssessmentProfiles()) {
                arrayList.addAll(assessmentProfile.getRules());
            }
        }
        return arrayList;
    }

    public static boolean exportAsSCORM(String string, String string2, String string3, String string4, boolean bl, String string5, AdventureDataControl adventureDataControl) {
        boolean bl2 = true;
        try {
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(Controller.createTempDirectory().getAbsolutePath());
            for (Object object2 : file.listFiles()) {
                if (object2.isDirectory()) {
                    object2.deleteAll();
                }
                object2.delete();
            }
            bl2 &= Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureAppletScorm");
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream2 = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream2);
            object2 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureAppletScorm");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(((String)object2).getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            bl2 &= file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            bl2 = JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = null;
            element = document.createElement("manifest");
            element.setAttribute("identifier", "imsaccmdv1p0_manifest");
            element.setAttribute("xmlns", "http://www.imsproject.org/xsd/imscp_rootv1p1p2");
            element.setAttribute("xmlns:imsmd", "http://www.imsglobal.org/xsd/imsmd_rootv1p2p1");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.imsproject.org/xsd/imscp_rootv1p1p2 imscp_rootv1p1p2.xsd http://www.imsglobal.org/xsd/imsmd_rootv1p2p1 imsmd_rootv1p2p1.xsd http://www.adlnet.org/xsd/adlcp_rootv1p2 adlcp_rootv1p2.xsd");
            element.setAttribute("xmlns:adlcp", "http://www.adlnet.org/xsd/adlcp_rootv1p2");
            element.setAttribute("version", "1.1");
            Element element2 = document.createElement("organizations");
            element2.setAttribute("default", ORGANIZATION_IDENTIFIER);
            Element element3 = document.createElement("organization");
            element3.setAttribute("identifier", ORGANIZATION_IDENTIFIER);
            Element element4 = document.createElement("title");
            element4.setTextContent(ORGANIZATION_TITLE);
            element3.appendChild(element4);
            Element element5 = document.createElement("item");
            element5.setAttribute("identifier", ITEM_IDENTIFIER);
            element5.setAttribute("identifierref", RESOURCE_IDENTIFIER);
            element5.setAttribute("isvisible", "true");
            Element element6 = document.createElement("title");
            element6.setTextContent(adventureDataControl.getTitle());
            element5.appendChild(element6);
            element3.appendChild(element5);
            element2.appendChild(element3);
            element.appendChild(element2);
            Element element7 = document.createElement("resources");
            Element element8 = document.createElement("resource");
            element8.setAttribute("adlcp:scormtype", "sco");
            element8.setAttribute("identifier", RESOURCE_IDENTIFIER);
            element8.setAttribute("type", "webcontent");
            element8.setAttribute("href", string2 + ".html");
            Element element9 = document.createElement("metadata");
            Element element10 = document.createElement("schema");
            element10.setTextContent("ADL SCORM");
            element9.appendChild(element10);
            Element element11 = document.createElement("schemaversion");
            element11.setTextContent("1.2");
            element9.appendChild(element11);
            Node node = IMSDOMWriter.buildIMSDOM(adventureDataControl.getImsController());
            document.adoptNode(node);
            element9.appendChild(node);
            element8.appendChild(element9);
            Element element12 = document.createElement("file");
            element12.setAttribute("href", string2 + ".html");
            element8.appendChild(element12);
            Element element13 = document.createElement("file");
            element13.setAttribute("href", "eadventure.js");
            element8.appendChild(element13);
            Element element14 = document.createElement("file");
            element14.setAttribute("href", string2 + ".jar");
            element8.appendChild(element14);
            Element element15 = document.createElement("file");
            element15.setAttribute("href", "splashScreen.gif");
            element8.appendChild(element15);
            element7.appendChild(element8);
            element.appendChild(element7);
            Writer.indentDOM(element, 0);
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/imsmanifest.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File file3 = new File("web/adlcp_rootv1p2.xsd");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/adlcp_rootv1p2.xsd"));
            file3 = new File("web/ims_xml.xsd");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/ims_xml.xsd"));
            file3 = new File("web/imscp_rootv1p1p2.xsd");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/imscp_rootv1p1p2.xsd"));
            file3 = new File("web/imsmd_rootv1p2p1.xsd");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/imsmd_rootv1p2p1.xsd"));
            File file4 = new File("web/eadventure.js");
            file4.copyTo((java.io.File)new File(file.getAbsolutePath() + "/eadventure.js"));
            File file5 = new File("web/splashScreen.gif");
            if (bl) {
                file5 = new File("web/splashScreen_red.gif");
            }
            file5.copyTo((java.io.File)new File(file.getAbsolutePath() + "/splashScreen.gif"));
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        return bl2;
    }

    public static boolean exportAsSCORM2004(String string, String string2, String string3, String string4, boolean bl, String string5, AdventureDataControl adventureDataControl) {
        boolean bl2 = true;
        try {
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(Controller.createTempDirectory().getAbsolutePath());
            for (Object object2 : file.listFiles()) {
                if (object2.isDirectory()) {
                    object2.deleteAll();
                }
                object2.delete();
            }
            bl2 &= Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureAppletScorm");
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream2 = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream2);
            object2 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureAppletScorm");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(((String)object2).getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            bl2 &= file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            bl2 = JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = null;
            element = document.createElement("manifest");
            element.setAttribute("identifier", "eAdventureGame");
            element.setAttribute("xmlns", "http://www.imsglobal.org/xsd/imscp_v1p1");
            element.setAttribute("xmlns:imsmd", "http://ltsc.ieee.org/xsd/LOM");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xmlns:adlcp", "http://www.adlnet.org/xsd/adlcp_v1p3");
            element.setAttribute("xmlns:imsss", "http://www.imsglobal.org/xsd/imsss");
            element.setAttribute("xmlns:adlseq", "http://www.adlnet.org/xsd/adlseq_v1p3");
            element.setAttribute("xmlns:adlnav", "http://www.adlnet.org/xsd/adlnav_v1p3");
            element.setAttribute("xsi:schemaLocation", "http://www.imsglobal.org/xsd/imscp_v1p1 imscp_v1p1.xsd http://ltsc.ieee.org/xsd/LOM lom.xsd http://www.adlnet.org/xsd/adlcp_v1p3 adlcp_v1p3.xsd http://www.imsglobal.org/xsd/imsss imsss_v1p0.xsd http://www.adlnet.org/xsd/adlseq_v1p3 adlseq_v1p3.xsd http://www.adlnet.org/xsd/adlnav_v1p3 adlnav_v1p3.xsd");
            Element element2 = document.createElement("metadata");
            Element element3 = document.createElement("schema");
            element3.setTextContent("ADL SCORM");
            element2.appendChild(element3);
            Element element4 = document.createElement("schemaversion");
            element4.setTextContent("2004 3rd Edition");
            element2.appendChild(element4);
            element.appendChild(element2);
            Element element5 = document.createElement("organizations");
            element5.setAttribute("default", ORGANIZATION_IDENTIFIER);
            Element element6 = document.createElement("organization");
            element6.setAttribute("identifier", ORGANIZATION_IDENTIFIER);
            element6.setAttribute("structure", ORGANIZATION_STRUCTURE);
            Element element7 = document.createElement("title");
            element7.setTextContent(adventureDataControl.getTitle());
            element6.appendChild(element7);
            Element element8 = document.createElement("item");
            element8.setAttribute("identifier", ITEM_IDENTIFIER);
            element8.setAttribute("identifierref", RESOURCE_IDENTIFIER);
            element8.setAttribute("isvisible", "true");
            Element element9 = document.createElement("title");
            element9.setTextContent(adventureDataControl.getTitle());
            element8.appendChild(element9);
            element6.appendChild(element8);
            element5.appendChild(element6);
            element.appendChild(element5);
            Element element10 = document.createElement("resources");
            Element element11 = document.createElement("resource");
            element11.setAttribute("identifier", RESOURCE_IDENTIFIER);
            element11.setAttribute("adlcp:scormType", "sco");
            element11.setAttribute("type", "webcontent");
            element11.setAttribute("href", string2 + ".html");
            Element element12 = document.createElement("metadata");
            Node node = LOMDOMWriter.buildLOMDOM(adventureDataControl.getLomController(), true);
            document.adoptNode(node);
            element12.appendChild(node);
            element11.appendChild(element12);
            Element element13 = document.createElement("file");
            element13.setAttribute("href", string2 + ".html");
            element11.appendChild(element13);
            Element element14 = document.createElement("file");
            element14.setAttribute("href", "eadventure.js");
            element11.appendChild(element14);
            Element element15 = document.createElement("file");
            element15.setAttribute("href", string2 + ".jar");
            element11.appendChild(element15);
            Element element16 = document.createElement("file");
            element16.setAttribute("href", "splashScreen.gif");
            element11.appendChild(element16);
            element10.appendChild(element11);
            element.appendChild(element10);
            Writer.indentDOM(element, 0);
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/imsmanifest.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File.unzipDir((String)"web/Scorm2004Content.zip", (String)(file.getAbsolutePath() + "/"));
            File file3 = new File("web/eadventure.js");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/eadventure.js"));
            File file4 = new File("web/splashScreen.gif");
            if (bl) {
                file4 = new File("web/splashScreen_red.gif");
            }
            file4.copyTo((java.io.File)new File(file.getAbsolutePath() + "/splashScreen.gif"));
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        return bl2;
    }

    public static boolean exportAsAGREGA(String string, String string2, String string3, String string4, boolean bl, String string5, AdventureDataControl adventureDataControl) {
        boolean bl2 = true;
        try {
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = null;
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            File file = new File(Controller.createTempDirectory().getAbsolutePath());
            for (Object object2 : file.listFiles()) {
                if (object2.isDirectory()) {
                    object2.deleteAll();
                }
                object2.delete();
            }
            bl2 &= Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureAppletScorm");
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream2 = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream2);
            object2 = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureAppletScorm");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(((String)object2).getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            bl2 &= file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            bl2 = JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = null;
            element = document.createElement("manifest");
            element.setAttribute("identifier", "eAdventureGame");
            element.setAttribute("xmlns", "http://www.imsglobal.org/xsd/imscp_v1p1");
            element.setAttribute("xmlns:lomes", "http://ltsc.ieee.org/xsd/LOM");
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xmlns:adlcp", "http://www.adlnet.org/xsd/adlcp_v1p3");
            element.setAttribute("xmlns:imsss", "http://www.imsglobal.org/xsd/imsss");
            element.setAttribute("xmlns:adlseq", "http://www.adlnet.org/xsd/adlseq_v1p3");
            element.setAttribute("xmlns:adlnav", "http://www.adlnet.org/xsd/adlnav_v1p3");
            element.setAttribute("xsi:schemaLocation", "http://www.imsglobal.org/xsd/imscp_v1p1 imscp_v1p1.xsd http://ltsc.ieee.org/xsd/LOM lom.xsd http://www.adlnet.org/xsd/adlcp_v1p3 adlcp_v1p3.xsd http://www.imsglobal.org/xsd/imsss imsss_v1p0.xsd http://www.adlnet.org/xsd/adlseq_v1p3 adlseq_v1p3.xsd http://www.adlnet.org/xsd/adlnav_v1p3 adlnav_v1p3.xsd");
            Element element2 = document.createElement("metadata");
            Element element3 = document.createElement("schema");
            element3.setTextContent("ADL SCORM");
            element2.appendChild(element3);
            Element element4 = document.createElement("schemaversion");
            element4.setTextContent("2004 3rd Edition");
            element2.appendChild(element4);
            Node node = LOMESDOMWriter.buildLOMESDOM(adventureDataControl.getLOMESController());
            document.adoptNode(node);
            element2.appendChild(node);
            element.appendChild(element2);
            Element element5 = document.createElement("organizations");
            element5.setAttribute("default", ORGANIZATION_IDENTIFIER);
            Element element6 = document.createElement("organization");
            element6.setAttribute("identifier", ORGANIZATION_IDENTIFIER);
            element6.setAttribute("structure", ORGANIZATION_STRUCTURE);
            Element element7 = document.createElement("title");
            element7.setTextContent(adventureDataControl.getTitle());
            element6.appendChild(element7);
            Element element8 = document.createElement("item");
            element8.setAttribute("identifier", ITEM_IDENTIFIER);
            element8.setAttribute("identifierref", RESOURCE_IDENTIFIER);
            element8.setAttribute("isvisible", "true");
            Element element9 = document.createElement("title");
            element9.setTextContent(adventureDataControl.getTitle());
            element8.appendChild(element9);
            element6.appendChild(element8);
            element5.appendChild(element6);
            element.appendChild(element5);
            Element element10 = document.createElement("resources");
            Element element11 = document.createElement("resource");
            element11.setAttribute("identifier", RESOURCE_IDENTIFIER);
            element11.setAttribute("adlcp:scormType", "sco");
            element11.setAttribute("type", "webcontent");
            element11.setAttribute("href", string2 + ".html");
            Element element12 = document.createElement("file");
            element12.setAttribute("href", string2 + ".html");
            element11.appendChild(element12);
            Element element13 = document.createElement("file");
            element13.setAttribute("href", "eadventure.js");
            element11.appendChild(element13);
            Element element14 = document.createElement("file");
            element14.setAttribute("href", string2 + ".jar");
            element11.appendChild(element14);
            Element element15 = document.createElement("file");
            element15.setAttribute("href", "splashScreen.gif");
            element11.appendChild(element15);
            element10.appendChild(element11);
            element.appendChild(element10);
            Writer.indentDOM(element, 0);
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            fileOutputStream = new FileOutputStream(file.getAbsolutePath() + "/imsmanifest.xml");
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            File.unzipDir((String)"web/Scorm2004AgregaContent.zip", (String)(file.getAbsolutePath() + "/"));
            File file3 = new File("web/eadventure.js");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/eadventure.js"));
            File file4 = new File("web/splashScreen.gif");
            if (bl) {
                file4 = new File("web/splashScreen_red.gif");
            }
            file4.copyTo((java.io.File)new File(file.getAbsolutePath() + "/splashScreen.gif"));
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (IOException iOException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)iOException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)parserConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerConfigurationException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        catch (TransformerException transformerException) {
            Controller.getInstance().showErrorDialog(TC.get((String)"Error.Title"), TC.get((String)"Error.WriteData"));
            ReportDialog.GenerateErrorReport((Exception)transformerException, (boolean)true, (String)TC.get((String)"Error.WriteData"));
            bl2 = false;
        }
        return bl2;
    }

    private static String getTab(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string;
    }

    public static boolean exportAsWebCTObject(String string, String string2, String string3, String string4, boolean bl, String string5, AdventureDataControl adventureDataControl) {
        File file;
        try {
            file = new File(Controller.createTempDirectory().getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        for (Object object : file.listFiles()) {
            if (object.isDirectory()) {
                object.deleteAll();
            }
            object.delete();
        }
        try {
            Object object;
            File file2 = new File(file.getAbsolutePath() + "/eAdventure.zip");
            FileOutputStream fileOutputStream = new FileOutputStream((java.io.File)file2);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            object = Writer.defaultManifestFile("es.eucm.eadventure.engine.EAdventureAppletScorm");
            ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
            ZipEntry zipEntry2 = new ZipEntry("META-INF/services/javax.xml.parsers.SAXParserFactory");
            ZipEntry zipEntry3 = new ZipEntry("META-INF/services/javax.xml.parsers.DocumentBuilderFactory");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(((String)object).getBytes());
            zipOutputStream.putNextEntry(zipEntry2);
            zipOutputStream.putNextEntry(zipEntry3);
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            File.mergeZipAndDirToJar((String)"web/eAdventure_temp.jar", (String)string5, (ZipOutputStream)zipOutputStream);
            Writer.addNeededLibrariesToJar(zipOutputStream, Controller.getInstance());
            zipOutputStream.close();
            String string6 = "learningObject";
            file2.renameTo((java.io.File)new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar"));
            File.unzipDir((String)"web/webct_temp.zip", (String)(file.getAbsolutePath() + "/"));
            JARSigner.signJar(string3, string4, file.getAbsolutePath() + "/" + string2 + "_unsigned.jar", file.getAbsolutePath() + "/CMD_6988980_M/my_files/" + string2 + ".jar");
            new File(file.getAbsolutePath() + "/" + string2 + "_unsigned.jar").delete();
            Writer.writeWebPage(file.getAbsolutePath(), string2, bl, "es.eucm.eadventure.engine.EAdventureApplet");
            File file3 = new File(file.getAbsolutePath() + "/" + string2 + ".html");
            file3.copyTo((java.io.File)new File(file.getAbsolutePath() + "/CMD_6988980_M/my_files/" + string6 + ".html"));
            file3.delete();
            File file4 = new File("web/splashScreen.gif");
            if (bl) {
                file4 = new File("web/splashScreen_red.gif");
            }
            file4.copyTo((java.io.File)new File(file.getAbsolutePath() + "/CMD_6988980_M/my_files/splashScreen.gif"));
            File.zipDirectory((String)(file.getAbsolutePath() + "/"), (String)string);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

