/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.writer;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.animation.Animation;
import es.eucm.eadventure.common.data.animation.Frame;
import es.eucm.eadventure.common.data.animation.Transition;
import es.eucm.eadventure.common.data.chapter.resources.Resources;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.writer.domwriters.ResourcesDOMWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnimationWriter {
    private AnimationWriter() {
    }

    public static boolean writeAnimation(String string, Animation animation) {
        boolean bl = false;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Transformer transformer = null;
            FileOutputStream fileOutputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            Element element = document.createElement("animation");
            element.setAttribute("id", animation.getId());
            element.setAttribute("usetransitions", animation.isUseTransitions() ? "yes" : "no");
            element.setAttribute("slides", animation.isSlides() ? "yes" : "no");
            Element element2 = document.createElement("documentation");
            if (animation.getDocumentation() != null && animation.getDocumentation().length() > 0) {
                element2.setTextContent(animation.getDocumentation());
            }
            element.appendChild(element2);
            for (Resources resources : animation.getResources()) {
                Node node = ResourcesDOMWriter.buildDOM(resources, 5);
                document.adoptNode(node);
                element.appendChild(node);
            }
            for (int i = 0; i < animation.getFrames().size(); ++i) {
                element.appendChild(AnimationWriter.createTransitionElement((Transition)animation.getTransitions().get(i), document));
                element.appendChild(AnimationWriter.createFrameElement((Frame)animation.getFrames().get(i), document));
            }
            element.appendChild(AnimationWriter.createTransitionElement(animation.getEndTransition(), document));
            document.adoptNode(element);
            document.appendChild(element);
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-system", "animation.dtd");
            try {
                fileOutputStream = new FileOutputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileOutputStream = new FileOutputStream(Controller.getInstance().getProjectFolder() + "/" + string);
            }
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            transformer.transform(new DOMSource(document), new StreamResult(outputStreamWriter));
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
            bl = true;
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)"UNKNOWERROR");
        }
        return bl;
    }

    private static Element createTransitionElement(Transition transition, Document document) {
        Element element = document.createElement("transition");
        if (transition.getType() == 0) {
            element.setAttribute("type", "none");
        } else if (transition.getType() == 1) {
            element.setAttribute("type", "fadein");
        } else if (transition.getType() == 3) {
            element.setAttribute("type", "horizontal");
        } else if (transition.getType() == 2) {
            element.setAttribute("type", "vertical");
        }
        element.setAttribute("time", "" + transition.getTime());
        return element;
    }

    public static Element createFrameElement(Frame frame, Document document) {
        Element element = document.createElement("frame");
        element.setAttribute("uri", frame.getUri() != null ? frame.getUri() : "");
        if (frame.getType() == 0) {
            element.setAttribute("type", "image");
        } else if (frame.getType() == 1) {
            element.setAttribute("type", "video");
        }
        element.setAttribute("time", String.valueOf(frame.getTime()));
        element.setAttribute("waitforclick", frame.isWaitforclick() ? "yes" : "no");
        element.setAttribute("soundUri", frame.getSoundUri() != null ? frame.getSoundUri() : "");
        element.setAttribute("maxSoundTime", String.valueOf(frame.getMaxSoundTime()));
        return element;
    }
}

