/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.timer;

import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.timer.TimerDataControl;
import es.eucm.eadventure.editor.control.controllers.timer.TimersListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DuplicateTimerTool
extends Tool {
    private TimersListDataControl dataControl;
    private TimerDataControl newTimer;
    private int selected;

    public DuplicateTimerTool(TimersListDataControl timersListDataControl, int n) {
        this.dataControl = timersListDataControl;
        this.selected = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.dataControl.duplicateElement(this.dataControl.getTimers().get(this.selected))) {
            this.newTimer = this.dataControl.getLastTimer();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.getTimers().add(this.newTimer);
        this.dataControl.getTimersList().add((Timer)this.newTimer.getContent());
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.deleteElement(this.newTimer, false);
        Controller.getInstance().updatePanel();
        return true;
    }
}

