/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.timer;

import es.eucm.eadventure.common.data.chapter.Timer;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.timer.TimerDataControl;
import es.eucm.eadventure.editor.control.controllers.timer.TimersListDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;

public class DeleteTimerTool
extends Tool {
    private TimersListDataControl dataControl;
    private TimerDataControl element;
    private int position;

    public DeleteTimerTool(TimersListDataControl timersListDataControl, int n) {
        this.dataControl = timersListDataControl;
        this.position = n;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        this.element = this.dataControl.getTimers().get(this.position);
        this.dataControl.deleteElement(this.dataControl.getTimers().get(this.position), true);
        return true;
    }

    @Override
    public boolean redoTool() {
        this.dataControl.deleteElement(this.element, true);
        Controller.getInstance().updatePanel();
        return true;
    }

    @Override
    public boolean undoTool() {
        this.dataControl.getTimersList().add(this.position, (Timer)this.element.getContent());
        this.dataControl.getTimers().add(this.position, this.element);
        Controller.getInstance().updatePanel();
        return true;
    }
}

