/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.structurepanel;

import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.DataControl;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.structurepanel.StructureControl;

public class RenameElementTool
extends Tool {
    private DataControl dataControl;
    private String oldName;
    private String newName;

    public RenameElementTool(DataControl dataControl, String string) {
        this.dataControl = dataControl;
        this.newName = string;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.oldName != null;
    }

    @Override
    public boolean doTool() {
        if (this.newName.length() == 0) {
            return false;
        }
        if (this.dataControl.canBeRenamed()) {
            this.oldName = this.dataControl.renameElement(this.newName);
            this.renameSelectedProfile(this.oldName, this.newName);
            if (this.oldName != null && !this.oldName.equals(this.newName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        if (this.dataControl.canBeRenamed()) {
            this.oldName = this.dataControl.renameElement(this.newName);
            this.renameSelectedProfile(this.oldName, this.newName);
            if (this.oldName != null) {
                Controller.getInstance().updateStructure();
                StructureControl.getInstance().changeDataControl(this.dataControl);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean undoTool() {
        if (this.dataControl.canBeRenamed()) {
            this.newName = this.dataControl.renameElement(this.oldName);
            this.renameSelectedProfile(this.newName, this.oldName);
            if (this.newName != null) {
                Controller.getInstance().updateStructure();
                StructureControl.getInstance().changeDataControl(this.dataControl);
                return true;
            }
        }
        return false;
    }

    private void renameSelectedProfile(String string, String string2) {
        if (this.dataControl instanceof AdaptationProfileDataControl && Controller.getInstance().getSelectedChapterDataControl().getAdaptationName().equals(string)) {
            ((Chapter)Controller.getInstance().getSelectedChapterDataControl().getContent()).setAdaptationName(string2);
        }
        if (this.dataControl instanceof AssessmentProfileDataControl && Controller.getInstance().getSelectedChapterDataControl().getAssessmentName().equals(string)) {
            ((Chapter)Controller.getInstance().getSelectedChapterDataControl().getContent()).setAssessmentName(string2);
        }
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }
}

