/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.structurepanel;

import es.eucm.eadventure.common.auxiliar.ReportDialog;
import es.eucm.eadventure.common.data.chapter.Chapter;
import es.eucm.eadventure.editor.control.Controller;
import es.eucm.eadventure.editor.control.controllers.adaptation.AdaptationProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.assessment.AssessmentProfileDataControl;
import es.eucm.eadventure.editor.control.controllers.general.ChapterDataControl;
import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.structurepanel.StructureElement;
import javax.swing.JTable;

public class RemoveElementTool
extends Tool {
    private StructureElement element;
    private ChapterDataControl chapterDataControl;
    private Chapter chapter;
    private JTable table;

    public RemoveElementTool(JTable jTable, StructureElement structureElement) {
        this.element = structureElement;
        this.table = jTable;
        this.chapterDataControl = Controller.getInstance().getSelectedChapterDataControl();
        try {
            this.chapter = (Chapter)((Chapter)this.chapterDataControl.getContent()).clone();
        }
        catch (Exception exception) {
            ReportDialog.GenerateErrorReport((Exception)exception, (boolean)true, (String)"Could not clone chapter");
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return this.chapter != null;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }

    @Override
    public boolean doTool() {
        if (this.element.delete(true)) {
            this.table.clearSelection();
            this.removeSelectedProfile();
            Controller.getInstance().updateStructure();
            return true;
        }
        return false;
    }

    @Override
    public boolean redoTool() {
        Controller.getInstance().replaceSelectedChapter((Chapter)this.chapterDataControl.getContent());
        Controller.getInstance().reloadData();
        return true;
    }

    @Override
    public boolean undoTool() {
        Controller.getInstance().replaceSelectedChapter(this.chapter);
        Controller.getInstance().reloadData();
        return true;
    }

    public void removeSelectedProfile() {
        if (this.element.getDataControl() instanceof AdaptationProfileDataControl && Controller.getInstance().getSelectedChapterDataControl().getAdaptationName().equals(((AdaptationProfileDataControl)this.element.getDataControl()).getName())) {
            ((Chapter)Controller.getInstance().getSelectedChapterDataControl().getContent()).setAdaptationName("");
        }
        if (this.element.getDataControl() instanceof AssessmentProfileDataControl && Controller.getInstance().getSelectedChapterDataControl().getAssessmentName().equals(((AssessmentProfileDataControl)this.element.getDataControl()).getName())) {
            ((Chapter)Controller.getInstance().getSelectedChapterDataControl().getContent()).setAssessmentName("");
        }
    }
}

