/*
 * Decompiled with CFR 0.152.
 */
package es.eucm.eadventure.editor.control.tools.structurepanel;

import es.eucm.eadventure.editor.control.tools.Tool;
import es.eucm.eadventure.editor.gui.structurepanel.StructureElement;
import es.eucm.eadventure.editor.gui.structurepanel.StructureListElement;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DuplicateElementTool
extends Tool {
    private StructureElement element;
    private JTable table;
    private StructureListElement parent;
    private StructureElement newElement;

    public DuplicateElementTool(StructureElement structureElement, JTable jTable, StructureListElement structureListElement) {
        this.element = structureElement;
        this.parent = structureListElement;
        this.table = jTable;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean doTool() {
        if (this.parent.getDataControl().duplicateElement(this.element.getDataControl())) {
            ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
            this.table.changeSelection(this.parent.getChildCount() - 1, 0, false, false);
            this.newElement = this.parent.getChild(this.parent.getChildCount() - 1);
            return true;
        }
        return false;
    }

    @Override
    public String getToolName() {
        return "Duplicate element";
    }

    @Override
    public boolean undoTool() {
        this.newElement.delete(false);
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.clearSelection();
        return true;
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public boolean redoTool() {
        return false;
    }

    @Override
    public boolean combine(Tool tool) {
        return false;
    }
}

